#pragma once

#include <H3D/Macros.h>
#include <string>

namespace H3D
{
	namespace Sound
	{
		class H3D_API H3D
		{
			public:

				typedef struct
				{
					int magic;
					unsigned int rate;
					unsigned int nchannels;
					unsigned int nframes;
				} Info;

				typedef struct
				{
					short* samples;
				} Content;

				Info info;
				Content content;

				H3D(void);

				virtual
				~H3D(void);

				bool
				load(const std::string& filename);

				virtual
				void
				unload(void);

				bool
				save(const std::string& filename);
		};

		namespace VORBIS
		{
			H3D_API
			H3D*
			import(const std::string& filename);
		}

		namespace MIME
		{
			H3D_API
			H3D*
			import(const std::string& filename);
		}

		namespace NAME
		{
			H3D_API
			H3D*
			import(const std::string& filename);
		}
	}
}