#pragma once

#include <H3D/Macros.h>
#include <string>

namespace H3D
{
	namespace Image
	{
		class H3D_API H3D
		{
			public:

				typedef struct
				{
					int magic;
					unsigned int width;
					unsigned int height;
					unsigned int bpp;
				} Info;

				typedef struct
				{
					unsigned char* pixels;
				} Content;

				Info info;
				Content content;

				H3D(void);

				virtual
				~H3D(void);

				bool
				load(const std::string& filename);

				virtual
				void
				unload(void);

				bool
				save(const std::string& filename);
		};

		namespace PNG
		{
			H3D_API
			H3D*
			import(const std::string& filename);
		}

		namespace JPEG
		{
			H3D_API
			H3D*
			import(const std::string& filename);
		}

		namespace TGA
		{
			H3D_API
			H3D*
			import(const std::string& filename);
		}

		namespace MIME
		{
			H3D_API
			H3D*
			import(const std::string& filename);
		}

		namespace NAME
		{
			H3D_API
			H3D*
			import(const std::string& filename);
		}
	}
}
