#pragma once

#include <H3D/Macros.h>
#include <string>
#include <ft2build.h>
#include FT_FREETYPE_H
#include <GL/glew.h>
#include <GL/gl.h>
#include <AL/al.h>
#include <ode/ode.h>
#undef PACKAGE
#undef PACKAGE_BUGREPORT
#undef PACKAGE_NAME
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef PACKAGE_VERSION
#undef VERSION
#include <H3D/Mesh.h>

namespace H3D
{
	namespace Helper
	{
		namespace FreeType
		{
			H3D_API
			void
			StringMetrics(FT_Face face, const std::wstring& string, unsigned int *w, unsigned int *h);
		}

		namespace OpenGL
		{
			namespace FreeType
			{
				typedef enum
				{
					TEXTURE,
					OUTLINE,
					WIRE,
					FILL,
					SOLID
				} DrawMode;

				H3D_API
				void
				TexGlyph2D(unsigned int w, unsigned int h, FT_GlyphSlot glyph);

				H3D_API
				void
				DrawTextureGlyph(FT_GlyphSlot glyph);

				H3D_API
				void
				DrawOutlineGlyph(FT_GlyphSlot glyph);

				H3D_API
				void
				DrawWireGlyph(FT_GlyphSlot glyph, unsigned int z);

				H3D_API
				void
				DrawFillGlyph(FT_GlyphSlot glyph, GLUtesselator *tess);

				H3D_API
				void
				DrawSolidGlyph(FT_GlyphSlot glyph, unsigned int z, GLUtesselator *tess);

				H3D_API
				void
				DrawGlyph(FT_GlyphSlot glyph, DrawMode mode, unsigned int z = 1);

				H3D_API
				void
				DrawString(FT_Face face, DrawMode mode, const std::wstring& string, unsigned int z = 1, GLUtesselator *tess = NULL);
			}

			namespace Image
			{
				H3D_API
				inline
				GLenum
				Format(unsigned int bpp)
				{
					GLenum format;
					switch(bpp)
					{
						case 3: format = GL_RGB; break;
						case 4: format = GL_RGBA; break;
					}
					return format;
				}
			}

			namespace OpenDE
			{
				H3D_API
				void
				Matrix(const float *position, const float *rotation, float *matrix);
			}

			namespace Frustum
			{
				H3D_API
				void
				Load(float *frustum);
			}
		}

		namespace OpenAL
		{
			namespace Sound
			{
				H3D_API
				inline
				ALenum
				Format(unsigned int nchannels)
				{
					GLenum format;
					switch(nchannels)
					{
						case 1: format = AL_FORMAT_MONO16; break;
						case 4: format = AL_FORMAT_STEREO16; break;
					}
					return format;
				}
			}
		}

		namespace OpenDE
		{
			H3D_API
			void
			Rotation(const float *matrix, float *rotation);
		}

		namespace Mesh
		{
			class H3D_API H3D:
				public ::H3D::Mesh::H3D
			{
				public:

					GLuint* textures;
					GLuint list;
					dGeomID geom;
					dTriMeshDataID data;

					H3D(void);

					virtual
					~H3D(void);

					void
					glLoad(const std::string& path);
			
					virtual
					void
					glUnload(void);

					void
					deLoad(dSpaceID space);

					virtual
					void
					deUnload(void);

					void
					draw(void);
			};
		}
	}
}
