// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#define _POSIX_C_SOURCE 1
#include "sl.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <magic.h>
//#include <AL/alext.h>
#include <vorbis/vorbisfile.h>

// Loader

int
slBufferLoad(SLenum loader, const char *filename, ALsizei *size, ALsizei *freq, ALvoid **data, ALenum *format)
{
	int r;

	switch(loader)
	{
		case SL_VORBIS: r = slBufferLoadVORBIS(filename, size, freq, data, format); break;
		case SL_MIME: r = slBufferLoadMIME(filename, size, freq, data, format); break;
		default: r = -1; break;
	}
	return r;
}

// MIME

int
slBufferLoadMIME(const char *filename, ALsizei *size, ALsizei *freq, ALvoid **data, ALenum *format)
{
	const char *mime;
	SLenum loader;
	magic_t cookie;

	loader = SL_MIME;
	cookie = magic_open(MAGIC_MIME_TYPE | MAGIC_NO_CHECK_COMPRESS | MAGIC_NO_CHECK_TAR);
	magic_load(cookie, NULL);
	mime = magic_file(cookie, filename);
	if(!strcmp(mime, "application/ogg")) loader = SL_VORBIS;
	magic_close(cookie);
	return loader != SL_MIME ? slBufferLoad(loader, filename, size, freq, data, format) : 1;
}

// VORBIS

int
slBufferLoadVORBIS(const char *filename, ALsizei *size, ALsizei *freq, ALvoid **data, ALenum *format)
{
/*
	FILE *stream;
	struct stat s;

	stream = fopen(filename, "rb");
	if(!stream)
		return -1;

	if(fstat(fileno(stream), &s) == 0)
	{
		*data = malloc(s.st_size);
		fread(*data, 1, s.st_size, stream);
		*size = s.st_size;
		*format = AL_FORMAT_VORBIS_EXT;
		*freq = 44100;
	}
	fclose(stream);
*/

	FILE *stream;
	OggVorbis_File ogg;
	char read[1 << 20];
	int endian = 0;
	int bitstream;
	unsigned int bytes;
	vorbis_info *info;

	stream = fopen(filename, "rb");
	ov_open(stream, &ogg, NULL, 0);
	info = ov_info(&ogg, -1);
	*format = (info->channels == 1) ? AL_FORMAT_MONO16 : AL_FORMAT_STEREO16;
	*freq = info->rate;
	*size = 0;
	do
	{
		bytes = ov_read(&ogg, read + *size, (1 << 20) - *size, endian, 2, 1, &bitstream);
		*size += bytes;
	}	
	while(*size < (1 << 20) && bytes > 0);
	if(*size > 0)
	{
		*data = malloc(*size);
		memcpy(*data, read, *size);
	}
	ov_clear(&ogg);
	return *size > 0;
}
