// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#define _XOPEN_SOURCE 500
#include "menuoptions.h"
#include "menumain.h"
#include "main.h"
#include "cl.h"
#include <stdio.h>
#include <stdlib.h>
#include <X11/keysym.h>
#include <GL/glu.h>

static const wchar_t *options[] = 
{
	L"Machines",
	L"Players",
	L"Track",
	L"Machine"
};
static int selection = 0;
static float selectoranim = 0;

void
FM_EnterMenuOptions(FM_Game *game)
{
	alSourcePlay(game->menu.audiosources[FM_GAME_MENU_MUSIC]);

	FM_SetKeyPressEventHandler(FM_KeyPressEventMenuOptions);
	FM_SetKeyReleaseEventHandler(FM_KeyReleaseEventMenuOptions);
	FM_SetUpdateHandler(FM_UpdateMenuOptions);
	FM_SetExitHandler(FM_ExitMenuOptions);
}

void
FM_ExitMenuOptions(FM_Game *game)
{
	alSourcePause(game->menu.audiosources[FM_GAME_MENU_MUSIC]);
}

static
void
FM_RenderMenuOptions(FM_Game *game)
{
	const float aspect = (float)game->screen.w / game->screen.h;
	unsigned int metrics[2];
	int i;

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	glLoadIdentity();
	
	gluLookAt(0, 0, 100, 0, 0, 0, 0, 1, 0);

	glBindTexture(GL_TEXTURE_2D, game->menu.background);
	glPushMatrix();
		glTranslatef((float)rand() / RAND_MAX - 0.5, (float)rand() / RAND_MAX - 0.5, 0);
		glBegin(GL_QUADS);
			glTexCoord2i(0, 0); glVertex2f(-52 * aspect, -52);
			glTexCoord2i(1, 0); glVertex2f(52 * aspect, -52);
			glTexCoord2i(1, 1); glVertex2f(52 * aspect, 52);
			glTexCoord2i(0, 1); glVertex2f(-52 * aspect, 52);
		glEnd();
	glPopMatrix();

	glDisable(GL_TEXTURE_2D);
	for(i = 0; i < 4; i++)
	{
		wchar_t text[128];
		switch(i)
		{
			case 0: swprintf(text, 128, L"%ls:%i", options[i], game->options.nmachines); break;
			case 1: swprintf(text, 128, L"%ls:%i", options[i], game->options.nplayers); break;
			case 2: swprintf(text, 128, L"%ls:%s", options[i], game->tracknames[game->options.track]); break;
			case 3: swprintf(text, 128, L"%ls:%s", options[i], game->machinenames[game->options.machine]); break;
		}
		clStringMetrics(game->face, text, &metrics[0], &metrics[1]);
		glPushMatrix();
		if(i == selection) glTranslatef((float) rand() / RAND_MAX - 0.5, (float)rand() / RAND_MAX - 0.5, 0);
		glScalef(0.125, 0.125, 1);
		glTranslatef(- (int) metrics[0] / 2, (1.5 - i) * 80, 1);
		clRenderString(game->face, CL_FILL, text, 1);
		glPopMatrix();

		if(i == selection)
		{
			glEnable(GL_TEXTURE_2D);
			glPushMatrix();
			glTranslatef(- (int) metrics[0] / 16 - 10, (1.5 - selection) * 10 + 2.5, 1);
			glRotatef(selectoranim, 10, 0, 0);
			glScalef(5, 5, 5);
			btmRender(&game->menu.selector);
			glPopMatrix();

			glPushMatrix();
			glTranslatef((int) metrics[0] / 16 + 10, (1.5 - selection) * 10 + 2.5, 1);
			glRotatef(selectoranim, 1, 0, 0);
			glScalef(5, 5, 5);
			btmRender(&game->menu.selector);
			glPopMatrix();
			glDisable(GL_TEXTURE_2D);
		}
	}
	glEnable(GL_TEXTURE_2D);
	selectoranim += 10;
}

bool
FM_KeyPressEventMenuOptions(FM_Game *game, XEvent *event)
{
	KeySym keysym;

	keysym = XLookupKeysym(&event->xkey, 0);
	switch(keysym)
	{
		case XK_Left:
			switch(selection)
			{
				case 0:
					game->options.nmachines = ((game->options.nmachines - 1) + 3) % 4 + 1;
					if(game->options.nplayers > game->options.nmachines)
						game->options.nplayers = game->options.nmachines;
					break;
				case 1: game->options.nplayers = ((game->options.nplayers - 1) + (game->options.nmachines - 1)) % game->options.nmachines + 1; break;
				case 2: game->options.track = (game->options.track + (game->ntracknames -1)) % game->ntracknames; break;
				case 3: game->options.machine = (game->options.machine + (game->nmachinenames -1)) % game->nmachinenames; break;
			}
			break;
		case XK_Right:
			switch(selection)
			{
				case 0:
					game->options.nmachines = game->options.nmachines % 4 + 1;
					if(game->options.nplayers > game->options.nmachines)
						game->options.nplayers = game->options.nmachines;
					break;
				case 1: game->options.nplayers = game->options.nplayers % game->options.nmachines + 1; break;
				case 2: game->options.track = (game->options.track + 1) % game->ntracknames; break;
				case 3: game->options.machine = (game->options.machine + 1) % game->nmachinenames; break;
			}
			break;
		case XK_Up: selection = (selection + 3) % 4; break;
		case XK_Down: selection = (selection + 1) % 4; 	break;
	}
	return true;
}

bool
FM_KeyReleaseEventMenuOptions(FM_Game *game, XEvent *event)
{
	KeySym keysym;

	keysym = XLookupKeysym(&event->xkey, 0);
	switch(keysym)
	{
		case XK_Escape: FM_ExitMenuOptions(game); FM_EnterMenuMain(game); break;
	}
	return true;
}

bool
FM_UpdateMenuOptions(FM_Game *game)
{
	FM_RenderMenuOptions(game);
	return true;
}

