// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#include "menumain.h"
#include "main.h"
#include "menuload.h"
#include "menuoptions.h"
#include "menuhelp.h"
#include "menuedit.h"
#include "il.h"
#include "cl.h"
#include <stdlib.h>
#include <X11/keysym.h>
#include <GL/glu.h>
#include "config.h"

static const wchar_t *entries[] = 
{
	L"Play",
	L"Options",
	L"Help",
	L"Exit"
};
static int selection = 0;
static float selectoranim = 0;

void
FM_EnterMenuMain(FM_Game *game)
{
	alSourcePlay(game->menu.audiosources[FM_GAME_MENU_MUSIC]);

	FM_SetKeyPressEventHandler(FM_KeyPressEventMenuMain);
	FM_SetKeyReleaseEventHandler(FM_KeyReleaseEventMenuMain);
	FM_SetUpdateHandler(FM_UpdateMenuMain);
	FM_SetExitHandler(FM_ExitMenuMain);
}

void
FM_ExitMenuMain(FM_Game *game)
{
	alSourcePause(game->menu.audiosources[FM_GAME_MENU_MUSIC]);
}

static
void
FM_RenderMenuMain(FM_Game *game)
{
	const float aspect = (float) game->screen.w / game->screen.h;
	unsigned int metrics[2];
	int i;

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	glLoadIdentity();
	
	gluLookAt(0, 0, 100, 0, 0, 0, 0, 1, 0);

	glBindTexture(GL_TEXTURE_2D, game->menu.background);
	glPushMatrix();
		glTranslatef((float) rand() / RAND_MAX - 0.5, (float)rand() / RAND_MAX - 0.5, 0);
		glBegin(GL_QUADS);
			glTexCoord2i(0, 0); glVertex2f(-52 * aspect, -52);
			glTexCoord2i(1, 0); glVertex2f(52 * aspect, -52);
			glTexCoord2i(1, 1); glVertex2f(52 * aspect, 52);
			glTexCoord2i(0, 1); glVertex2f(-52 * aspect, 52);
		glEnd();
	glPopMatrix();

	glDisable(GL_TEXTURE_2D);
	for(i = 0; i < 4; i++)
	{
		clStringMetrics(game->face, entries[i], &metrics[0], &metrics[1]);
		glPushMatrix();
		if(i == selection) glTranslatef((float) rand() / RAND_MAX - 0.5, (float)rand() / RAND_MAX - 0.5, 0);
		glScalef(0.2, 0.2 , 1);
		glTranslatef(- (int) metrics[0] / 2, (1.5 - i) * 75, 1);
		clRenderString(game->face, CL_FILL, entries[i], 1);
		glPopMatrix();
		if(i == selection)
		{
			glEnable(GL_TEXTURE_2D);
			glPushMatrix();
			glTranslatef(- (int) metrics[0] / 10 - 10, (1.5 - selection) * 15 + 3.75, 1);
			glRotatef(selectoranim, 1, 0, 0);
			glScalef(5, 5, 5);
			btmRender(&game->menu.selector);
			glPopMatrix();

			glPushMatrix();
			glTranslatef((int)metrics[0] / 10 + 10, (1.5 - selection) * 15 + 3.75, 1);
			glRotatef(selectoranim, 1, 0, 0);
			glScalef(5, 5, 5);
			btmRender(&game->menu.selector);
			glPopMatrix();
			glDisable(GL_TEXTURE_2D);
		}
	}
	glEnable(GL_TEXTURE_2D);
	selectoranim += 10;
}

bool
FM_UpdateMenuMain(FM_Game *game)
{
	FM_RenderMenuMain(game);
	return true;
}

bool
FM_KeyPressEventMenuMain(FM_Game *game, XEvent *event)
{
	KeySym keysym;

	keysym = XLookupKeysym(&event->xkey, 0);
	switch(keysym)
	{
		case XK_Up: selection = (selection + 3) % 4; break;
		case XK_Down: selection = (selection + 1) % 4; break;
	}
	return true;
}

bool
FM_KeyReleaseEventMenuMain(FM_Game *game, XEvent *event)
{
	KeySym keysym;
	bool loop = true;

	keysym = XLookupKeysym(&event->xkey, 0);
	switch(keysym)
	{
		case XK_e: FM_ExitMenuMain(game); FM_EnterMenuEdit(game); break;
		case XK_Return:
			switch(selection)
			{
				case 0: FM_ExitMenuMain(game); FM_EnterMenuLoad(game); break;
				case 1: FM_ExitMenuMain(game); FM_EnterMenuOptions(game); break;
				case 2: FM_ExitMenuMain(game); FM_EnterMenuHelp(game); break;
				case 3: FM_ExitMenuMain(game); loop = false; break;
			}
			break;
		case XK_Escape: FM_ExitMenuMain(game); loop = false; break;
	}
	return loop;
}
