// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#include "menuload.h"
#include "menumain.h"
#include "menuplay.h"
#include "main.h"
#include "cl.h"
#include <stdlib.h>
#include <X11/keysym.h>
#include <GL/glu.h>
#include "config.h"

static bool load;

static const wchar_t *info[] = 
{
	L"Loading",
};

void
FM_EnterMenuLoad(FM_Game *game)
{
	load = false;

	alSourcePlay(game->menu.audiosources[FM_GAME_MENU_MUSIC]);

	FM_SetKeyPressEventHandler(FM_KeyPressEventMenuLoad);
	FM_SetKeyReleaseEventHandler(FM_KeyReleaseEventMenuLoad);
	FM_SetUpdateHandler(FM_UpdateMenuLoad);
	FM_SetExitHandler(FM_ExitMenuLoad);
}

void
FM_ExitMenuLoad(FM_Game *game)
{
	alSourcePause(game->menu.audiosources[FM_GAME_MENU_MUSIC]);
}

static
void
FM_RenderMenuLoad(FM_Game *game)
{
	const float aspect = (float) game->screen.w / game->screen.h;
	unsigned int metrics[2];
	int i;

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	glLoadIdentity();
	
	gluLookAt(0, 0, 100, 0, 0, 0, 0, 1, 0);

	glBindTexture(GL_TEXTURE_2D, game->menu.background);
	glPushMatrix();
		glTranslatef((float) rand() / RAND_MAX - 0.5, (float)rand() / RAND_MAX - 0.5, 0);
		glBegin(GL_QUADS);
			glTexCoord2i(0, 0); glVertex2f(-52 * aspect, -52);
			glTexCoord2i(1, 0); glVertex2f(52 * aspect, -52);
			glTexCoord2i(1, 1); glVertex2f(52 * aspect, 52);
			glTexCoord2i(0, 1); glVertex2f(-52 * aspect, 52);
		glEnd();
	glPopMatrix();

	glDisable(GL_TEXTURE_2D);
	glPushMatrix();
	glScalef(0.05, 0.05, 1);
	for(i = 0; i < sizeof(info) / sizeof(info[0]); i++)
	{
		clStringMetrics(game->face, info[i], &metrics[0], &metrics[1]);
		glPushMatrix();
		glTranslatef((float) rand() / RAND_MAX * 20.0 - 10.0, (float) rand() / RAND_MAX * 20.0 - 10.0, 0);
		glTranslatef(-(int) metrics[0] / 2, 0, 1);
		clRenderString(game->face, CL_FILL, info[i], 1);
		glPopMatrix();
	}	
	glPopMatrix();
	glEnable(GL_TEXTURE_2D);
}

bool
FM_KeyPressEventMenuLoad(FM_Game *game, XEvent *event)
{
	return true;
}

bool
FM_KeyReleaseEventMenuLoad(FM_Game *game, XEvent *event)
{
	KeySym keysym;

	keysym = XLookupKeysym(&event->xkey, 0);
	switch(keysym)
	{
		case XK_Escape: FM_ExitMenuLoad(game); FM_EnterMenuMain(game); break;
	}
	return true;
}

bool
FM_UpdateMenuLoad(FM_Game *game)
{
	bool r;

	if(!load)
	{
		FM_RenderMenuLoad(game);
		load = true;
		r = true;
	}
	else
	{
		FM_ExitMenuLoad(game);
		FM_EnterMenuPlay(game);
		r = FM_UpdateMenuPlay(game);
	}
	return r;
}

