// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#include "menuhelp.h"
#include "menumain.h"
#include "main.h"
#include "cl.h"
#include <stdlib.h>
#include <X11/keysym.h>
#include <GL/glu.h>
#include "config.h"

static const wchar_t *help[] = 
{
	L"A free machines game",
	L"Drive the machines in the various tracks",
	L"Player 1 keys: up, down, left, right",
	L"Player 2 keys: w, s, a, d",
	L"Player 3 keys: i, k, j, l",
	L"Player 4 keys: t, g, f, h",
	L"Have fun",
};

void
FM_EnterMenuHelp(FM_Game *game)
{
	alSourcePlay(game->menu.audiosources[FM_GAME_MENU_MUSIC]);

	FM_SetKeyPressEventHandler(FM_KeyPressEventMenuHelp);
	FM_SetKeyReleaseEventHandler(FM_KeyReleaseEventMenuHelp);
	FM_SetUpdateHandler(FM_UpdateMenuHelp);
	FM_SetExitHandler(FM_ExitMenuHelp);
}

void
FM_ExitMenuHelp(FM_Game *game)
{
	alSourcePause(game->menu.audiosources[FM_GAME_MENU_MUSIC]);
}

static
void
FM_RenderMenuHelp(FM_Game *game)
{
	const float aspect = (float) game->screen.w / game->screen.h;
	unsigned int metrics[2];
	int i;

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	glLoadIdentity();
	
	gluLookAt(0, 0, 100, 0, 0, 0, 0, 1, 0);

	glBindTexture(GL_TEXTURE_2D, game->menu.background);
	glPushMatrix();
		glTranslatef((float) rand() / RAND_MAX - 0.5, (float)rand() / RAND_MAX - 0.5, 0);
		glBegin(GL_QUADS);
			glTexCoord2i(0, 0); glVertex2f(-52 * aspect, -52);
			glTexCoord2i(1, 0); glVertex2f(52 * aspect, -52);
			glTexCoord2i(1, 1); glVertex2f(52 * aspect, 52);
			glTexCoord2i(0, 1); glVertex2f(-52 * aspect, 52);
		glEnd();
	glPopMatrix();

	glDisable(GL_TEXTURE_2D);
	glPushMatrix();
	glScalef(0.05, 0.05, 1);
	for(i = 0; i < 7; i++)
	{
		clStringMetrics(game->face, help[i], &metrics[0], &metrics[1]);
		glPushMatrix();
		glTranslatef((float) rand() / RAND_MAX * 20.0 - 10.0, (float) rand() / RAND_MAX * 20.0 - 10.0, 0);
		glTranslatef(-(int) metrics[0] / 2, (3 - i) * 200, 1);
		clRenderString(game->face, CL_FILL, help[i], 1);
		glPopMatrix();
	}	
	glPopMatrix();
	glEnable(GL_TEXTURE_2D);
}

bool
FM_KeyPressEventMenuHelp(FM_Game *game, XEvent *event)
{
	return true;
}

bool
FM_KeyReleaseEventMenuHelp(FM_Game *game, XEvent *event)
{
	KeySym keysym;

	keysym = XLookupKeysym(&event->xkey, 0);
	switch(keysym)
	{
		case XK_Escape: FM_ExitMenuHelp(game); FM_EnterMenuMain(game); break;
	}
	return true;
}

bool
FM_UpdateMenuHelp(FM_Game *game)
{
	FM_RenderMenuHelp(game);
	return true;
}

