// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#ifndef MAIN_H
#define MAIN_H

#include "freemachinestypes.h"
#include <stdbool.h>
#include "btm.h"
#include <X11/Xlib.h>
#include <GL/gl.h>
#include <AL/al.h>
#include <ode/ode.h>
#undef PACKAGE
#undef PACKAGE_BUGREPORT
#undef PACKAGE_NAME
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef PACKAGE_VERSION
#undef VERSION
#include <ft2build.h>
#include FT_FREETYPE_H

#define FM_FONT PACKAGE_DATADIR "/VeraBd.ttf"
#define FM_MENU_BACKGROUND PACKAGE_DATADIR "/Analog-Wind-1.jpg"
#define FM_MENU_SELECTOR PACKAGE_DATADIR "/selector.btm.bz2"
#define FM_MENU_MUSIC PACKAGE_DATADIR "/engine.ogg"

enum
{
	FM_GAME_MENU_MUSIC = 0
};

typedef enum
{
	FM_PROJECTION_2D,
	FM_PROJECTION_3D
} FM_Projection;

struct FM_Game
{
	FM_Projection projection;
	FT_Library freetype;
	FT_Face face;

	struct { unsigned int w, h; } screen;

	unsigned int ntracknames;
	const char **tracknames;

	unsigned int nmachinenames;
	const char **machinenames;

	struct
	{
		GLuint background;
		BTMmodel selector;
		ALuint audiosources[1];
	} menu;

	struct
	{
		unsigned int nmachines, nplayers;
		unsigned int track, machine;
	} options;

	struct
	{
		dWorldID world;
		dSpaceID space;
		dJointGroupID contactgroup;
		FM_Track *track;
		struct { unsigned int track; } cache;
	} play;

};

void
FM_SetUpdateHandler(bool (*handler)(FM_Game *));

void
FM_SetKeyPressEventHandler(bool (*handler)(FM_Game *, XEvent *));

void
FM_SetKeyReleaseEventHandler(bool (*handler)(FM_Game *, XEvent *));

void
FM_SetExitHandler(void (*handler)(FM_Game *));

void
FM_GL_2D(FM_Game *game);

void
FM_GL_3D(FM_Game *game);

#endif
