// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#ifndef IOL_H
#define IOL_H

#include <stdbool.h>
#include <stdio.h>

#define BZSTREAMSIZE 2048

typedef void BZFILE;

typedef struct
{
	char buffer[BZSTREAMSIZE];
	int pos;
	int read;
	bool eof;
	BZFILE *file;
} BZSTREAM;

typedef struct
{
	FILE *raw;
	BZFILE *compressed;
} IOLFILE;


IOLFILE
*iolfopenread(const char *filename);

void
iolfclose(IOLFILE *file);

int
iolfgetc(IOLFILE *file);

void
iolungetc(int c, IOLFILE *file);

unsigned int
iolgetline(char **line, unsigned int *n, IOLFILE *file);

#endif
