// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#ifndef IL_H
#define IL_H

#include <GL/gl.h>

#define ilSizeOfFormat(f) (((f) == GL_RGB ? 3 : 4) * sizeof(GLbyte))

// Loader

typedef enum
{
	IL_PNG,
	IL_JPEG,
	IL_MIME
} ILenum;

int
ilTexLoad(ILenum loader, const char *filename, GLubyte **pixels, GLuint *width, GLuint *height, GLenum *format);

// MIME

int
ilTexLoadMIME(const char *filename, GLubyte **pixels, GLuint *width, GLuint *height, GLenum *format);

// PNG

int
ilTexLoadPNG(const char *filename, GLubyte **pixels, GLuint *width, GLuint *height, GLenum *format);

// JPEG

int
ilTexLoadJPEG(const char *filename, GLubyte **pixels, GLuint *width, GLuint *height, GLenum *format);

#endif
