// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#ifndef CL_H
#define CL_H

#include <wchar.h>
#include <ft2build.h>
#include FT_FREETYPE_H

typedef enum
{
	CL_TEXTURE,
	CL_OUTLINE,
	CL_WIRE,
	CL_FILL,
	CL_SOLID
} CLenum;

void
clStringMetrics(FT_Face face, const wchar_t *string, unsigned int *w, unsigned int *h);

void
clTexGlyph2D(unsigned int w, unsigned int h, FT_GlyphSlot glyph);

void
clRenderTextureGlyph(FT_GlyphSlot glyph);

void
clRenderOutlineGlyph(FT_GlyphSlot glyph);

void
clRenderWireGlyph(FT_GlyphSlot glyph, unsigned int z);

void
clRenderFillGlyph(FT_GlyphSlot glyph);

void
clRenderSolidGlyph(FT_GlyphSlot glyph, unsigned int z);

void
clRenderGlyph(FT_GlyphSlot glyph, CLenum mode, unsigned int z);

void
clRenderString(FT_Face face, CLenum mode, const wchar_t *string, unsigned int z);

#endif
