// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#ifndef CHAIN_H
#define CHAIN_H

#include "freemachinestypes.h"

struct chain
{
	void *data;
	chain *prev, *next;
};

void
chain_free(chain *c);

chain *
chain_index(chain *c, unsigned int i);

unsigned int
chain_length(const chain *c);

chain *
chain_last(chain *c);

chain *
chain_contains(chain *c, void *data);

chain *
chain_append(chain *c, void *data);

chain *
chain_insert(chain *c, unsigned int i, void *data);

chain *
chain_prepend(chain *c, void *data);

chain *
chain_remove(chain *c, unsigned int i);

chain *
chain_remove_chain(chain *c, chain *h);

void
chain_scan(chain *c, scanner scanner);

void
chain_user_scan(chain *c, user_scanner scanner, void *data);

#endif
