// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#include "chain.h"
#include <stdlib.h>
#include <stdbool.h>

void
chain_free(chain *c)
{
	chain *ta = c, *tb;
	while(ta)
	{
		tb = ta->next;
		free(ta);
		ta = tb;
	}
}

chain *
chain_index(chain *c, unsigned int i)
{
	chain *t = c;
	unsigned int s;
	for(s = 0; s < i; s++)
		t = t->next;
	return t;
}

chain *
chain_last(chain *c)
{
	if(c)
	{
		chain *t = c;
		while(t->next)
			t = t->next;
		return t;
	}
	else
		return c;
}

unsigned int
chain_length(const chain *c)
{
	if(c)
	{
		const chain *t;
		unsigned int s = 0;
		for(t = c; t; t = t->next)
			s++;
		return s;
	}
	else
		return 0;
}

chain *
chain_contains(chain *c, void *data)
{
	chain *t;
	for(t = c; t && t->data != data; t = t->next);
	return t;
}

chain *
chain_append(chain *c, void *data)
{
	if(c)
	{
		chain *t = chain_last(c);
		t->next = malloc(sizeof(chain));
		t->next->next = NULL;
		t->next->data = data;
		t->next->prev = t;
	}
	else
	{
		c = malloc(sizeof(chain));
		c->next = NULL;
		c->data = data;
		c->prev = NULL;
	}
	return c;
}

chain *
chain_insert(chain *c, unsigned int i, void *data)
{
	if(i)
	{
		chain *t, *tn;
	       	t = chain_index(c, i - 1);
		tn = t->next;
		t->next = malloc(sizeof(chain));
		tn->prev = t->next;
		t->next->next = tn;
		t->next->data = data;
		t->next->prev = t;
		return c;
	}
	else
		return chain_prepend(c, data);
}
chain *
chain_prepend(chain *c, void *data)
{
	if(c)
	{
		chain *t;
		t = c;
		c = malloc(sizeof(chain));
		c->next = t;
		c->data = data;
		c->prev = NULL;
		t->prev = c;
		c = t;
	}
	else
	{
		c = malloc(sizeof(chain));
		c->next = NULL;
		c->data = data;
		c->prev = NULL;
	}
	return c;
}

chain *
chain_remove(chain *c, unsigned int i)
{
	if(i)
	{
		chain *ta = chain_index(c, i - 1);
		chain *tb = ta->next->next;
		free(ta->next);
		ta->next = tb;
		if(tb) tb->prev = ta;
		return c;
	}
	else
	{
		chain *t = NULL;
		if(c->next) t = c->next;
		free(c);
		if(t) t->prev = NULL;
		return t;
	}
}

chain *
chain_remove_chain(chain *c, chain *h)
{
	chain *r;
	r = c != h ? c : (c->next ? c->next : NULL);
	if(h->prev) h->prev->next = h->next;
	if(h->next) h->next->prev = h->prev;
	free(h);
	return r;
}

void
chain_scan(chain *c, scanner scanner)
{
	chain *t;
	for(t = c; t; t = t->next)
		scanner(t->data);
}

void
chain_user_scan(chain *c, user_scanner scanner, void *data)
{
	chain *t;
	for(t = c; t; t = t->next)
		scanner(t->data, data);
}
