// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#ifndef CAMERA_H
#define CAMERA_H

#include "freemachinestypes.h"
#include <stdbool.h>

struct FM_Camera
{
	float object[9];
	float frustum[6][4];
};

void
FM_CameraGLFrustumLoad(FM_Camera *camera);

bool
FM_CameraFrustumPoint(const FM_Camera *camera, const float *point);

bool
FM_CameraFrustumSphere(const FM_Camera *camera, float *sphere);

bool
FM_CameraFrustumTriangle(const FM_Camera *camera, float *triangle);

bool
FM_CameraFrustumCube(const FM_Camera *camera, float *cube);

bool
FM_CameraFrustumPolygon(const FM_Camera *camera, int npoints, float *points);

#endif
