// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#ifndef BTM_H
#define BTM_H

#include "camera.h"

typedef struct
{
	char *name;
	char *texture;
	float alpha;
	float emit;
	float ambient[3];
	float diffuse[3];
	float specular[3];
} BTMmaterial;

typedef struct
{
	float co[3];
	float no[3];
} BTMvertex;

typedef struct
{
	unsigned int mat;
	unsigned int verts[3];
	float uv[3][2];
	float no[3];
} BTMface;

typedef struct
{
	char *name;
	BTMmaterial *materials;
	unsigned int nmaterials;
	BTMvertex *vertices;
	unsigned int nvertices;
	BTMface *faces;
	unsigned int nfaces;
} BTMmesh;

typedef struct
{
	char *name;
	BTMmesh mesh;
} BTMobject;

typedef struct
{
	char *name;
	char *path;
	BTMobject *objects;
	unsigned int nobjects;
	unsigned int **textures;
	int **alphafaces;
	unsigned int *displaylists;
} BTMmodel;

void
btmLoad(BTMmodel *model, const char *filename);

void
btmUnload(BTMmodel *model);

void
btmRender(const BTMmodel *model);

void
btmRenderWithCamera(const FM_Camera *camera, const BTMmodel *model);

#endif
