// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#include "rilmedia.h"
#include <vorbis/vorbisfile.h>
#include <stdlib.h>
#include <string.h>
#include <IL/ilut.h>

#define BUFFER_SIZE 32768

ALuint
rilMediaALCreateBufferFromOgg(const char *filename)
{
	int endian = 0;
	int bitstream;
	long bytes, read = 0;
	char fbuffer[BUFFER_SIZE];
	char *data = NULL;
	FILE *stream;
	vorbis_info *info;
	OggVorbis_File ogg;
	ALenum format;
	ALsizei freq;
	ALuint buffer;

	stream = fopen(filename, "rb");
	ov_open(stream, &ogg, NULL, 0);
	info = ov_info(&ogg, -1);
	format = (info->channels == 1) ? AL_FORMAT_MONO16 : AL_FORMAT_STEREO16;
	freq = info->rate;
	do
	{
		bytes = ov_read(&ogg, fbuffer, BUFFER_SIZE, endian, 2, 1, &bitstream);
		if(bytes > 0)
		{
			data = realloc(data, read + bytes);
			memcpy(data + read, fbuffer, bytes);
			read += bytes;
		}
	} while(bytes > 0);
	ov_clear(&ogg);
	alGenBuffers(1, &buffer);
	alBufferData(buffer, format, data, read, freq);
	return buffer;
	
}

