// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#include "menumain.h"
#include <GL/glu.h>
#include "main.h"
#include "rilimage.h"
#include "rilmedia.h"
#include "menuplay.h"
#include "menuoptions.h"
#include "menuhelp.h"
#include "menuedit.h"
#include "config.h"

static const wchar_t *entries[] = 
{
	L"Play",
	L"Options",
	L"Help",
	L"Exit"
};
static int selection = 0;
static float selectoranim = 0;

void
FM_EnterMenuMain(FM_Game *game)
{
	alSourcePlay(game->menuaudiosources[FM_GAME_MENU_MUSIC]);

	FM_SetEventHandler(FM_EventMenuMain);
	FM_SetUpdateHandler(FM_UpdateMenuMain);
}

void
FM_ExitMenuMain(FM_Game *game)
{
	alSourcePause(game->menuaudiosources[FM_GAME_MENU_MUSIC]);
}

static
void
FM_RenderMenuMain(FM_Game *game)
{
	const float aspect = (float)game->screen->w / game->screen->h;
	float bbox[6];
	int i;

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	glLoadIdentity();
	
	gluLookAt(0, 0, 100, 0, 0, 0, 0, 1, 0);

	glBindTexture(GL_TEXTURE_2D, game->menubackground);
	glPushMatrix();
		glTranslatef((float)rand() / RAND_MAX - 0.5, (float)rand() / RAND_MAX - 0.5, 0);
		glBegin(GL_QUADS);
			glTexCoord2i(0, 0); glVertex2f(-52 * aspect, -52);
			glTexCoord2i(1, 0); glVertex2f(52 * aspect, -52);
			glTexCoord2i(1, 1); glVertex2f(52 * aspect, 52);
			glTexCoord2i(0, 1); glVertex2f(-52 * aspect, 52);
		glEnd();
	glPopMatrix();

	rilFontFaceSize(game->menufont, 10);
	rilFontDepth(game->menufont, 1);
	for(i = 0; i < sizeof(entries) / sizeof(entries[0]); i++)
	{
		rilFontBBoxWide(game->menufont, entries[i], bbox);
		glPushAttrib(GL_ALL_ATTRIB_BITS);
		glDisable(GL_TEXTURE_2D);
		glPushMatrix();
		if(i == selection)
			glTranslatef((float)rand() / RAND_MAX - 0.5, (float)rand() / RAND_MAX - 0.5, 0);
		glTranslatef((bbox[0] - bbox[3]) / 2, (1.5 - i) * 15, 0);
		rilFontRenderWide(game->menufont, entries[i]);
		glPopMatrix();
		glPopAttrib();

		if(i == selection)
		{
			glPushMatrix();
			glTranslatef((bbox[0] - bbox[3]) / 2 - 10, (1.5 - selection) * 15 + 3.75, 0);
			glRotatef(selectoranim, 1, 0, 0);
			glScalef(5, 5, 5);
			btmRender(&game->menuselector);
			glPopMatrix();

			glPushMatrix();
			glTranslatef((bbox[3] - bbox[0]) / 2 + 10, (1.5 - selection) * 15 + 3.75, 0);
			glRotatef(selectoranim, 1, 0, 0);
			glScalef(5, 5, 5);
			btmRender(&game->menuselector);
			glPopMatrix();
		}
	}
	selectoranim += 10;

	SDL_GL_SwapBuffers();
}

bool
FM_UpdateMenuMain(FM_Game *game)
{
	FM_RenderMenuMain(game);
	return false;
}

bool
FM_EventMenuMain(FM_Game *game, SDL_Event *event)
{
	bool exitrequest = false;
	switch(event->type)
	{
		case SDL_KEYDOWN:
			switch(event->key.keysym.sym)
			{
				case SDLK_UP:
					selection = (selection + 3) % 4;
					break;
				case SDLK_DOWN:
					selection = (selection + 1) % 4;
					break;
				default:
					break;
			}
			break;
		case SDL_KEYUP:
			switch(event->key.keysym.sym)
			{
				case SDLK_e:
					FM_ExitMenuMain(game);
					FM_EnterMenuEdit(game);
					break;
				case SDLK_RETURN:
					switch(selection)
					{
						case 0:
							FM_ExitMenuMain(game);
							FM_EnterMenuPlay(game);
							break;
						case 1:
							FM_ExitMenuMain(game);
							FM_EnterMenuOptions(game);
							break;
						case 2:
							FM_ExitMenuMain(game);
							FM_EnterMenuHelp(game);
							break;
						case 3:
							FM_ExitMenuMain(game);
							exitrequest = true;
							break;

					}
					break;
				case SDLK_ESCAPE:
					FM_ExitMenuMain(game);
					exitrequest = true;
					break;
				default:
					break;
			}
			break;
		case SDL_QUIT:
			FM_ExitMenuMain(game);
			exitrequest = true;
			break;
	}
	return exitrequest;
}
