// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#ifndef MAIN_H
#define MAIN_H

#include <SDL/SDL.h>
#include <GL/gl.h>
#include <AL/al.h>
#include <stdbool.h>
#include "rilfont.h"
#include "btm.h"

#define FM_SCREEN_WIDTH 640
#define FM_SCREEN_HEIGHT 480
#define FM_SCREEN_BPP 32
#define FM_FONT PACKAGE_DATADIR "/VeraBd.ttf"
#define FM_MENU_BACKGROUND PACKAGE_DATADIR "/Analog-Wind-1.jpg"
#define FM_MENU_SELECTOR PACKAGE_DATADIR "/selector.btm.bz2"
#define FM_MENU_MUSIC PACKAGE_DATADIR "/engine.ogg"

enum
{
	FM_GAME_MENU_MUSIC = 0
};

typedef enum
{
	FM_PROJECTION_2D,
	FM_PROJECTION_3D
} FM_Projection;

typedef struct
{
	SDL_Surface *screen;
	FM_Projection projection;
	Uint8 *keys;

	unsigned int ntracknames;
	const char **tracknames;

	unsigned int nmachinenames;
	const char **machinenames;

	// Menu
	GLuint menubackground;
	RILfont *menufont;
	BTMmodel menuselector;
	ALuint menuaudiobuffers[1], menuaudiosources[1];

	// Options
	unsigned int nmachines, nplayers;
	unsigned int track;
	unsigned int machine;
} FM_Game;

void
FM_EnterMain();

void
FM_ExitMain();

void
FM_SetUpdateHandler(bool (*handler)(FM_Game *));

void
FM_SetEventHandler(bool (*handler)(FM_Game *, SDL_Event *));

void
FM_GL_2D(FM_Game *game);

void
FM_GL_3D(FM_Game *game);

#endif
