// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#ifndef LIST_H
#define LIST_H

#include <stdlib.h>

typedef struct list
{
	void *data;
	struct list *next;
} list;

typedef void (*list_scanner)(void *);
typedef void (*list_user_scanner)(void *, void *);

void
list_free(list *a);

list *
list_index(list *a, size_t i);

size_t
list_length(const list *a);

list *
list_last(list *a);

list *
list_append(list *a, void *data);

list *
list_insert(list *a, size_t i, void *data);

list *
list_prepend(list *a, void *data);

list *
list_remove(list *a, size_t i);

void
list_scan(list *a, list_scanner scanner);

void
list_user_scan(list *a, list_user_scanner scanner, void *data);

#endif
