// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#ifndef TRACK_H
#define TRACK_H

#include "btm.h"
#include "machine.h"
#include <ode/ode.h>
#include "rilcamera.h"

typedef struct
{
	BTMmodel model;
	dGeomID geom;
	dVector3 *vertices;
	int *indices;
	dTriMeshDataID trimeshdata;
	unsigned int ncheckpoints;
	float *checkpoints;
} FM_Track;

FM_Track *
FM_LoadTrack(dSpaceID space, const char *name);

void
FM_FreeTrack(FM_Track *track);

void
FM_UpdateTrack(FM_Track *track, FM_Machine *machine);

void
FM_RenderTrack(const FM_Track *track, const RILcamera *camera);

#endif
