// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#ifndef RILFONT_H
#define RILFONT_H

#ifdef __cplusplus
extern "C"
{
#endif

struct _RILfont;
typedef struct _RILfont RILfont;

typedef enum
{
	RIL_FONT_BITMAP,
	RIL_FONT_PIXMAP,
	RIL_FONT_OUTLINE,
	RIL_FONT_POLYGON,
	RIL_FONT_EXTRUDE,
	RIL_FONT_TEXTURE
} RILfonttype;


RILfont *
rilFontLoad(const char *filename, RILfonttype type);

void
rilFontUnload(RILfont *font);

void
rilFontFaceSize(RILfont *font, unsigned int facesize);

void
rilFontDepth(RILfont *font, float depth);

void
rilFontBBox(RILfont *font, const char *text, float *bbox);

void
rilFontBBoxWide(RILfont *font, const wchar_t *text, float *bbox);

void
rilFontRender(RILfont *font, const char *text);

void
rilFontRenderWide(RILfont *font, const wchar_t *text);

#ifdef __cplusplus
}
#endif

#endif
