// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#include "rilfont.h"
#include <FTGL/FTFont.h>
#include <FTGL/FTGLBitmapFont.h>
#include <FTGL/FTGLPixmapFont.h>
#include <FTGL/FTGLOutlineFont.h>
#include <FTGL/FTGLPolygonFont.h>
#include <FTGL/FTGLExtrdFont.h>
#include <FTGL/FTGLTextureFont.h>

struct _RILfont
{
	FTFont *wrap;
};

RILfont *
rilFontLoad(const char *filename, RILfonttype type)
{
	RILfont *font;

	font = (RILfont *)malloc(sizeof(RILfont));

	switch(type)
	{
		case RIL_FONT_BITMAP: font->wrap = new FTGLBitmapFont(filename); break;
		case RIL_FONT_PIXMAP: font->wrap = new FTGLPixmapFont(filename); break;
		case RIL_FONT_OUTLINE: font->wrap = new FTGLOutlineFont(filename); break;
		case RIL_FONT_POLYGON: font->wrap = new FTGLPolygonFont(filename); break;
		case RIL_FONT_EXTRUDE: font->wrap = new FTGLExtrdFont(filename); break;
		case RIL_FONT_TEXTURE: font->wrap = new FTGLTextureFont(filename); break;
	}

	return font;
}

void
rilFontUnload(RILfont *font)
{
	delete font->wrap;
	free(font);
}

void
rilFontFaceSize(RILfont *font, unsigned int facesize)
{
	font->wrap->FaceSize(facesize);
}

void
rilFontDepth(RILfont *font, float depth)
{
	font->wrap->Depth(depth);
}

void
rilFontBBox(RILfont *font, const char *text, float *bbox)
{
	font->wrap->BBox(text, bbox[0], bbox[1], bbox[2], bbox[3], bbox[4], bbox[5]);
}

void
rilFontBBoxWide(RILfont *font, const wchar_t *text, float *bbox)
{
	font->wrap->BBox(text, bbox[0], bbox[1], bbox[2], bbox[3], bbox[4], bbox[5]);
}

void
rilFontRender(RILfont *font, const char *text)
{
	font->wrap->Render(text);
}

void
rilFontRenderWide(RILfont *font, const wchar_t *text)
{
	font->wrap->Render(text);
}
