// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#define _XOPEN_SOURCE 500
#include "menuoptions.h"
#include "main.h"
#include <stdio.h>
#include <wchar.h>
#include <GL/glu.h>
#include "menumain.h"
#include "rilfont.h"

static const wchar_t *options[] = 
{
	L"Machines",
	L"Players",
	L"Track",
	L"Machine"
};
static int selection = 0;
static float selectoranim = 0;

void
FM_EnterMenuOptions(FM_Game *game)
{
	alSourcePlay(game->menuaudiosources[FM_GAME_MENU_MUSIC]);

	FM_SetEventHandler(FM_EventMenuOptions);
	FM_SetUpdateHandler(FM_UpdateMenuOptions);
}

void
FM_ExitMenuOptions(FM_Game *game)
{
	alSourcePause(game->menuaudiosources[FM_GAME_MENU_MUSIC]);
}

static
void
FM_RenderMenuOptions(FM_Game *game)
{
	const float aspect = (float)game->screen->w / game->screen->h;
	float bbox[6];
	int i;

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	glLoadIdentity();
	
	gluLookAt(0, 0, 100, 0, 0, 0, 0, 1, 0);

	glBindTexture(GL_TEXTURE_2D, game->menubackground);
	glPushMatrix();
		glTranslatef((float)rand() / RAND_MAX - 0.5, (float)rand() / RAND_MAX - 0.5, 0);
		glBegin(GL_QUADS);
			glTexCoord2i(0, 0); glVertex2f(-52 * aspect, -52);
			glTexCoord2f(1, 0); glVertex2f(52 * aspect, -52);
			glTexCoord2f(1, 1); glVertex2f(52 * aspect, 52);
			glTexCoord2f(0, 1); glVertex2f(-52 * aspect, 52);
		glEnd();
	glPopMatrix();

	rilFontFaceSize(game->menufont, 3);
	rilFontDepth(game->menufont, 1);

	for(i = 0; i < sizeof(options) / sizeof(options[0]); i++)
	{
		wchar_t text[128];
		switch(i)
		{
			case 0:
				swprintf(text, 128, L"%ls:%i", options[i], game->nmachines);
				break;
			case 1:
				swprintf(text, 128, L"%ls:%i", options[i], game->nplayers);
				break;
			case 2:
				swprintf(text, 128, L"%ls:%s", options[i], game->tracknames[game->track]);
				break;
			case 3:
				swprintf(text, 128, L"%ls:%s", options[i], game->machinenames[game->machine]);
				break;
		}
		rilFontBBoxWide(game->menufont, text, bbox);
		glPushAttrib(GL_ALL_ATTRIB_BITS);
		glDisable(GL_TEXTURE_2D);
		glPushMatrix();
		if(i == selection)
			glTranslatef((float)rand() / RAND_MAX - 0.5, (float)rand() / RAND_MAX - 0.5, 0);
		glTranslatef((bbox[0] - bbox[3]) / 2, (1.5 - i) * 10, 0);
		rilFontRenderWide(game->menufont, text);
		glPopMatrix();
		glPopAttrib();

		if(i == selection)
		{
			glPushMatrix();
			glTranslatef((bbox[0] - bbox[3]) / 2 - 10, (1.5 - selection) * 10 + 3.75, 0);
			glRotatef(selectoranim, 1, 0, 0);
			glScalef(5, 5, 5);
			btmRender(&game->menuselector);
			glPopMatrix();

			glPushMatrix();
			glTranslatef((bbox[3] - bbox[0]) / 2 + 10, (1.5 - selection) * 10 + 3.75, 0);
			glRotatef(selectoranim, 1, 0, 0);
			glScalef(5, 5, 5);
			btmRender(&game->menuselector);
			glPopMatrix();
		}
	}
	selectoranim += 10;
	SDL_GL_SwapBuffers();
}

bool
FM_UpdateMenuOptions(FM_Game *game)
{
	FM_RenderMenuOptions(game);
	return false;
}

bool
FM_EventMenuOptions(FM_Game *game, SDL_Event *event)
{
	bool exitrequest = false;
	switch(event->type)
	{
		case SDL_KEYDOWN:
			switch(event->key.keysym.sym)
			{
				case SDLK_LEFT:
					switch(selection)
					{
						case 0:
							game->nmachines = ((game->nmachines - 1) + 3) % 4 + 1;
							if(game->nplayers > game->nmachines)
								game->nplayers = game->nmachines;
							break;
						case 1:
							game->nplayers = ((game->nplayers - 1) + (game->nmachines - 1)) % game->nmachines + 1;
							break;
						case 2:
							game->track = (game->track + (game->ntracknames -1)) % game->ntracknames;
							break;
						case 3:
							game->machine = (game->machine + (game->nmachinenames -1)) % game->nmachinenames;
							break;
					}
					break;
				case SDLK_RIGHT:
					switch(selection)
					{
						case 0:
							game->nmachines = game->nmachines % 4 + 1;
							if(game->nplayers > game->nmachines)
								game->nplayers = game->nmachines;
							break;
						case 1:
							game->nplayers = game->nplayers % game->nmachines + 1;
							break;
						case 2:
							game->track = (game->track + 1) % game->ntracknames;
							break;
						case 3:
							game->machine = (game->machine + 1) % game->nmachinenames;
							break;
					}
					break;
				case SDLK_UP:
					selection = (selection + 3) % 4;
					break;
				case SDLK_DOWN:
					selection = (selection + 1) % 4;
					break;
				default:
					break;
			}
			break;
		case SDL_KEYUP:
			switch(event->key.keysym.sym)
			{
				case SDLK_ESCAPE:
					FM_ExitMenuOptions(game);
					FM_EnterMenuMain(game);
					break;
				default:
					break;
			}
			break;
		case SDL_QUIT:
			FM_ExitMenuOptions(game);
			exitrequest = true;
			break;
	}
	return exitrequest;
}
