// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#include "menucredits.h"
#include <GL/glu.h>
#include "main.h"
#include "menumain.h"
#include "rilimage.h"
#include "rilfont.h"

static const wchar_t *credits[] = 
{
	L"Juan Manuel Borges Caño",
};

void
FM_EnterMenuCredits(FM_Game *game)
{
	alSourcePlay(game->menuaudiosources[FM_GAME_MENU_MUSIC]);

	FM_SetEventHandler(FM_EventMenuCredits);
	FM_SetUpdateHandler(FM_UpdateMenuCredits);
}

void
FM_ExitMenuCredits(FM_Game *game)
{
	alSourcePause(game->menuaudiosources[FM_GAME_MENU_MUSIC]);
}

static
void
FM_RenderMenuCredits(FM_Game *game)
{
	const float aspect = (float)game->screen->w / game->screen->h;
	float bbox[6];
	int i;

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	glLoadIdentity();
	
	gluLookAt(0, 0, 100, 0, 0, 0, 0, 1, 0);

	glBindTexture(GL_TEXTURE_2D, game->menubackground);
	glPushMatrix();
		glTranslatef((float)rand() / RAND_MAX - 0.5, (float)rand() / RAND_MAX - 0.5, 0);
		glBegin(GL_QUADS);
			glTexCoord2i(0, 0); glVertex2f(-52 * aspect, -52);
			glTexCoord2f(1, 0); glVertex2f(52 * aspect, -52);
			glTexCoord2f(1, 1); glVertex2f(52 * aspect, 52);
			glTexCoord2f(0, 1); glVertex2f(-52 * aspect, 52);
		glEnd();
	glPopMatrix();

	rilFontFaceSize(game->menufont, 3);
	rilFontDepth(game->menufont, 1);
	for(i = 0; i < sizeof(credits) / sizeof(credits[0]); i++)
	{
		rilFontBBoxWide(game->menufont, credits[i], bbox);
		glPushAttrib(GL_ALL_ATTRIB_BITS);
		glDisable(GL_TEXTURE_2D);
		glPushMatrix();
		glTranslatef((float)rand() / RAND_MAX - 0.5, (float)rand() / RAND_MAX - 0.5, 0);
		glTranslatef((bbox[0] - bbox[3]) / 2, 0, 0);
		rilFontRenderWide(game->menufont, credits[i]);
		glPopMatrix();
		glPopAttrib();
	}

	SDL_GL_SwapBuffers();
}

bool
FM_UpdateMenuCredits(FM_Game *game)
{
	FM_RenderMenuCredits(game);
	return false;
}

bool
FM_EventMenuCredits(FM_Game *game, SDL_Event *event)
{
	bool exitrequest = false;
	switch(event->type)
	{
		case SDL_KEYUP:
			switch(event->key.keysym.sym)
			{
				case SDLK_ESCAPE:
					FM_ExitMenuCredits(game);
					FM_EnterMenuMain(game);
					break;
				default:
					break;
			}
			break;
		case SDL_QUIT:
			FM_ExitMenuCredits(game);
			exitrequest = true;
			break;
	}
	return exitrequest;
}
