// Copyright (C) 2008 Juan Manuel Borges Caño

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#ifndef MACHINE_H
#define MACHINE_H

#include <stdbool.h>
#include "btm.h"
#include <ode/ode.h>
#include <AL/al.h>
#include "rilcamera.h"

typedef struct
{
	float cfgspeed, cfgsteer;
	BTMmodel chassis, wheel;
	dBodyID body[5];
	dGeomID geom[5];
	dJointID joint[4];
	int speed, steer;
	ALuint buffer, source;
	unsigned int checkpoint;
	float checkpointdistance;
} FM_Machine;

FM_Machine *
FM_LoadMachine(dWorldID world, dSpaceID space, float cfgspeed, float cfgsteer, const float *position, float steer, const char *name);

void
FM_FreeMachine(FM_Machine *machine);

void
FM_ControlMachine(FM_Machine *machine, int up, int down, int left, int right);

bool
FM_UpdateMachine(FM_Machine *machine, const RILcamera *camera);

void
FM_RenderMachine(FM_Machine *machine);

#endif
