;###############################################################################
;# constant.inc version 1.0
;# 2002 Copyright (C) A.M. ten Doesschate <a.doesschate@hccnet.nl>
;#
;# This program is free software; you can redistribute it and/or modify
;# it under the terms of the GNU General Public License as published by
;# the Free Software Foundation; either version 2 of the License, or
;# (at your option) any later version.
;#
;# This program is distributed in the hope that it will be useful,
;# but WITHOUT ANY WARRANTY; without even the implied warranty of
;# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;# GNU General Public License for more details.
;#
;# You should have received a copy of the GNU General Public License
;# along with this program; if not, write to the Free Software
;# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;#
;###############################################################################

		.equ		MAX_BUF		= 40
		.equ		BAUD_9600	= 207		; in system with 16 MHz clock
		.equ		BAUD_38400	= 51		; in system with 16 MHz clock
		.equ		BAUD_115200	= 16		; in system with 16 MHz clock
;
; (A) uart status bit numbers
;
		.equ		MULTI_PROC	= 0
		.equ		U2X		= 1
		.equ		PE		= 2
		.equ		OR		= 3
		.equ		FE		= 4
		.equ		UDRE		= 5
		.equ		RXC		= 6
		.equ		TXC		= 7
;
; (B) uart control bit numbers
;
		.equ		TX_B8		= 0
		.equ		RX_B8		= 1
		.equ		CHR_9		= 2
		.equ		TX_EN		= 3
		.equ		RX_EN		= 4
		.equ		UDRIE		= 5
		.equ		TXCIE		= 6
		.equ		RXCIE		= 7
;
; (C) uart control bit numbers
;
		.equ		UCPOL		= 0
		.equ		CHAR_SIZ0	= 1
		.equ		CHAR_SIZ1	= 2
		.equ		STOPBIT1	= 3
		.equ		PARITY0		= 4
		.equ		PARITY1		= 5
		.equ		UART_MODE	= 6
		.equ		UR_SEL		= 7
;
; mcu control bit numbers
;
		.equ		IRQ_SENSE00	= 0
		.equ		IRQ_SENSE01	= 1
		.equ		IRQ_SENSE10	= 2
		.equ		IRQ_SENSE11	= 3
		.equ		SLEEP_MODE	= 4
		.equ		SLEEP_ENABLE	= 5
		.equ		WAIT_ST_ENABLE	= 6
		.equ		EXT_SRAM_ENABLE	= 7
;
; gicr control bit numbers
;
		.equ		IVCE		= 0
		.equ		IVSEL		= 1
		.equ		INT2		= 5
		.equ		INT0		= 6
		.equ		INT1		= 7
;
; gifr control bit numbers
;
		.equ		INTF2		= 5
		.equ		INTF0		= 6
		.equ		INTF1		= 7
;
; jtag bit number definitions
;
		.equ		TDO		= 4
		.equ		TDI		= 3
		.equ		TMS		= 5
;
; bit variabelen
;
		.equ		BIT0		= 1<<0
		.equ		BIT1		= 1<<1
		.equ		BIT2		= 1<<2
		.equ		BIT3		= 1<<3
		.equ		BIT4		= 1<<4
		.equ		BIT5		= 1<<5
		.equ		BIT6		= 1<<6
		.equ		BIT7		= 1<<7

;
; parallel port output definitions
;
		.equ		STROBE		= BIT0
		.equ		AUTOFEED	= BIT1
		.equ		SELECT_IN	= BIT2
		.equ		INIT		= BIT3
;
; parallel port input definitions
; will be used in future implementation as ieee1284 device
;
		.equ		ERROR		= BIT0
		.equ		SELECT		= BIT1
		.equ		PAPER_EMPTY	= BIT2
		.equ		BUSY		= BIT3
		.equ		ACK		= BIT4
;
; supported extensibiltity flags of ieee1284 
; will be used in future implementation as ieee1284 device
;
		.equ		NIBBLE_MODE	= 0
		.equ		BYTE_MODE	= BIT1
		.equ		REQUEST_ID	= BIT3
		.equ		EPP_MODE	= BIT6
		.equ		REQ_EXT_LNK	= BIT7
;
; jtag state machine
;
		.equ		IDLE		= 0
		.equ		SELECT_DR	= 1 + IDLE
		.equ		CAPTURE_DR	= 1 + SELECT_DR
		.equ		SHIFT_DR	= 1 + CAPTURE_DR
		.equ		EXIT_DR		= 1 + SHIFT_DR
		.equ		PAUSE_DR	= 1 + EXIT_DR
		.equ		EXIT2_DR	= 1 + PAUSE_DR
		.equ		UPDATE_DR	= 1 + EXIT2_DR
		.equ		SELECT_IR	= 1 + UPDATE_DR 
		.equ		CAPTURE_IR	= 1 + SELECT_IR
		.equ		SHIFT_IR	= 1 + CAPTURE_IR
		.equ		EXIT_IR		= 1 + SHIFT_IR
		.equ		PAUSE_IR	= 1 + EXIT_IR
		.equ		EXIT2_IR	= 1 + PAUSE_IR
		.equ		UPDATE_IR	= 1 + EXIT2_IR
		.equ		RESET		= 1 + UPDATE_IR
;
; ascii 
;
		.equ		CR		= 13
		.equ		LF		= 10
		.equ		SPACE		= 32
		.equ		TAB		= 8
