/* 
   extension.c: freehoo extensions to guile
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */


#include <guile/gh.h>
#include "extension.h"
#include "freehoo.h"
#include "scm-procedures.h"
#include "compat.h"

SCM ex_message_send_hook;
SCM ex_message_receive_hook;
SCM ex_contact_added_hook;
SCM ex_message_receive_offline_hook;
SCM ex_login_post_hook;
SCM ex_mail_notify_hook;
int hook_return = 0;

int
get_hook_return (void)
{
  return hook_return;
}

void
set_hook_return (int hook_return_value)
{
  hook_return = hook_return_value;
}

SCM
get_message_send_hook ()
{
  return (ex_message_send_hook);
}

SCM
get_message_receive_hook ()
{
  return (ex_message_receive_hook);
}

SCM
get_contact_added_hook ()
{
 return (ex_contact_added_hook);
}

SCM
get_message_receive_offline_hook ()
{
  return (ex_message_receive_offline_hook);
}

SCM
get_login_post_hook ()
{
  return (ex_login_post_hook);
}

SCM
get_mail_notify_hook ()
{
  return (ex_mail_notify_hook);
}

void
install_new_variables (void)
{
  // This is this is the place to install new variables
}

void
install_new_hooks (void)
{
  /* 
     ;; sample eqivalent code in scheme

     (define hook-test (make-hook 2))
     (define hook-proc (lambda (frm message)
     (display frm)
     (newline)
     (display message)
     (newline)))
     (add-hook! hook-test hook-proc)
     (run-hook hook-test "hi" "test")
   */

  ex_message_send_hook =  scm_make_hook (scm_from_int (2));
  scm_c_define ("fh-message-send-hook", ex_message_send_hook);
  /* hook: fh-message-send-hook

     is called from
     file: yahoo-adapter.c
     function: send_message (...)

     with arguments
     "message-to" and "message-data"

     set the hook like this
     (add-hook! fh-message-send-hook (lambda (to message) (do-something)))
   */

  ex_message_receive_hook = scm_make_hook (scm_from_int (2));
  scm_c_define ("fh-message-receive-hook", ex_message_receive_hook);
  /* hook: fh-message-receive-offline-hook
     is called from
     file: yafh-adapter.c
     function: send_message (...)
     with arguments
     "message-from" and "message-data"

     set the hook like this
     (add-hook! fh-message-receive-hook (lambda (from message) (do-something)))
   */
  ex_contact_added_hook = scm_make_hook (scm_from_int (2));
  scm_c_define ("fh-contact-added-hook", ex_contact_added_hook);
  /*
    set the hook like this
    (add-hook! fh-contact-added-hook (lambda (from message)  (do-something)))
   */

  ex_message_receive_offline_hook = scm_make_hook (scm_from_int (3));
  scm_c_define ("fh-message-receive-offline-hook", ex_message_receive_offline_hook);
  /* hook: fh-message-receive-offline-hook

     is called from
     file: yahoo-adapter.c
     function: process_offline_message (...)
     with arguments
     "message-from" "message-data" "message-time"
     
     set the hook like this
     (add-hook! fh-message-send-hook (lambda (from message time) (do-something)))
   */

  ex_login_post_hook = scm_make_hook (scm_from_int (0));
  scm_c_define ("fh-login-post-hook", ex_login_post_hook);
  /* hook: fh-login-post-hook
     is called from
     file: messenger.c
     function: send_message (...)
     with arguments
     "message-from" and "message-data"

     set the hook like this
     (add-hook! fh-login-post-hook (lambda () (do-something)))
   */

  ex_mail_notify_hook = scm_make_hook (scm_from_int (2));
  scm_c_define ("fh-mail-notify-hook", ex_mail_notify_hook);
  /* hook: fh-mail-notify-hook
     is called from
     file: yahoo_backend.c
     function: ext_yahoo_mail_notify (...)
     with arguments
     "mail-from" and "mail-subject"

     set the hook like this
     (add-hook! fh-mail-notify-hook (lambda (from subject) (do-something)))
   */
}

void
install_new_procedures (void)
{
  /* installing general procedures */
  scm_c_define_gsubr ("fh-load", 1, 0, 0, ex_load);
  /* this way you call me
     (fh-load "aliases.scm")
  */

  scm_c_define_gsubr ("fh-send-message", 2, 0, 0, ex_send_message);
  /* this way you call me
     (fh-send-message "hello gnu")
  */

  scm_c_define_gsubr ("fh-send-message-no-hook", 2, 0, 0, ex_send_message);
  /* this way you call me
     (fh-send-message-no-hook "hello gnu")
  */

  scm_c_define_gsubr ("fh-set-current-target-buddy!", 2, 0, 0, ex_set_current_target_buddy_x);
  /* this way you call me
     (fh-set-current-target-buddy! "my_friend")
  */

  scm_c_define_gsubr ("fh-register-command!", 1, 0, 0, ex_register_command_x);
  /* this way you call me
     (fh-register-command  "/ping")
  */

  scm_c_define_gsubr ("fh-unregister-command!", 1, 0, 0, ex_unregister_command_x);
  /* this way you call me
     (fh-unregister-command  "/ping")
  */

  scm_c_define_gsubr ("fh-version", 0, 0, 0, ex_version);
  /* this way you call me
     (display (fh-version))
  */

  scm_c_define_gsubr ("fh-display", 1, 0, 0, ex_display);
  /* this way you call me
     (fh-display "Hello GNU")
  */

  scm_c_define_gsubr ("fh-get-buddy-list", 0, 0, 0, ex_get_buddy_list);
  /* this way you call me
     (define buddy_list (fh-get-buddy-list))
  */

  scm_c_define_gsubr ("fh-add-buddy", 1, 1, 0, ex_add_buddy);
    
  /* this way you call me
     (fh-add-buddy "balugi" "GNU")
  */

  /* installing configuration procedures */
  scm_c_define_gsubr ("fh-bell!", 0, 0, 0, ex_bell);
  /* this way you call me
     (fh-bell!)
  */

  scm_c_define_gsubr ("fh-toggle!", 1, 0, 0, ex_toggle_x);
  /* this way you call me
     (fh-bell-toggle! 'bell)
  */

  scm_c_define_gsubr ("fh-get-home-dir", 0, 0, 0, ex_get_home_dir);
  /* this way you call me
     (display (fh-get-home-dir))
  */

  scm_c_define_gsubr ("fh-get-config-dir", 0, 0, 0, ex_get_config_dir);
  /* this way you call me
     (display (fh-get-config-dir))
  */

  scm_c_define_gsubr ("fh-get-config-filename", 0, 0, 0, ex_get_config_filename);
  /* this way you call me
     (display (fh-get-config-filename)
  */

  scm_c_define_gsubr ("fh-get-download-filename", 0, 0, 0, ex_get_download_filename);
  /* this way you call me
     (display (fh-get-downlaod-filename)
  */

  scm_c_define_gsubr ("fh-get-global-extensions-directory", 0, 0, 0, ex_get_global_extensions_directory);
  /* this way you call me
     (display (fh-get-global-extensions-directory))
  */

  scm_c_define_gsubr ("fh-get-local-extensions-directory", 0, 0, 0, ex_get_local_extensions_directory);
  /* this way you call me
     (display (fh-get-local-extensions-directory))
  */

  scm_c_define_gsubr ("fh-get-default-login-id", 0, 0, 0, ex_get_default_login_id);
  /* this way you call me
     (display (fh-get-login-id))
  */

  scm_c_define_gsubr ("fh-set-default-login-id!", 1, 0, 0, ex_set_default_login_id_x);
  /* this way you call me
     (fh-set-login-id! "abindian")
  */

  scm_c_define_gsubr ("fh-set-default-password!", 1, 0, 0, ex_set_default_password_x);
  /* this way you call me
     (fh-set-login-id! "press_enter")
  */

  scm_c_define_gsubr ("fh-set-default-status!", 1, 0, 0, ex_set_default_status_x);
  /* this way you call me
     ;; default to invisible mode
     (fh-set-status! 12)
  */

  scm_c_define_gsubr ("fh-set-prompt!", 1, 0, 0, ex_set_prompt_x);
  /* this way you call me
     ;; set prompt string
     (fh-set-prompt! "~qp~> ")
  */

  /* installing hook related procedures */
  scm_c_define_gsubr ("fh-hook-return", 0, 0, 0, ex_hook_return);
  /* this way you call me
     (fh-hook-return)
  */

  /* installing hook related procedures */
  scm_c_define_gsubr ("fh-quit", 0, 0, 0, ex_fh_quit);
  /* this way you call me
     (fh-quit)
  */

  /* installing hook related procedures */
  scm_c_define_gsubr ("fh-logoff", 0, 0, 0, ex_fh_logoff);
  /* this way you call me
     (fh-logoff)
  */

  /* add new word for dictionary autocomplete */
  scm_c_define_gsubr ("fh-dict-add-word!", 1, 0, 0, ex_fh_dict_add_word);
  /* this way you call me
   * (fh-dict-add-word! "newbigword")
   */

  /* add new word for dictionary autocomplete in pre sorted sequence */
  scm_c_define_gsubr ("fh-dict-add-word-sorted!", 1, 0, 0, ex_fh_dict_add_word_sorted);
  /* this way you call me
   * (fh-dict-add-word-sorted! "newbigword")
   */

  /* delete word from automplete dictionary */
  scm_c_define_gsubr ("fh-dict-del-word!", 1, 0, 0, ex_fh_dict_del_word);
  /* this way you call me
   * (fh-dict-del-word! "easy")
   */
}

// guile initialization area
void
guile_env_init (void)
{
  install_new_variables ();
  install_new_procedures ();
  install_new_hooks ();
}
