/*
   yahoo-backend.h: core file, controls the whole flow, easily
   integrates with libyahoo2

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */


#ifndef _YAHOO_BACKEND_H
#define _YAHOO_BACKEND_H

#include <yahoo2.h>
#include <yahoo2_callbacks.h>

#define MAX_PREF_LEN 255
#define YAHOO_DEBUGLOG ext_yahoo_log

#define LOG(x) if(do_yahoo_debug) { YAHOO_DEBUGLOG("%s:%d: ", __FILE__, __LINE__); \
	YAHOO_DEBUGLOG x; \
	YAHOO_DEBUGLOG("\n"); }

#define WARNING(x) if(do_yahoo_debug) { YAHOO_DEBUGLOG("%s:%d: warning: ", __FILE__, __LINE__); \
	YAHOO_DEBUGLOG x; \
	YAHOO_DEBUGLOG("\n"); }

#define print_message(x) { printf x; printf("\n"); }

typedef struct
{
  char yahoo_id[255];
  char password[255];
  int id;
  int fd;
  int status;
  char *msg;
} yahoo_local_account;

typedef struct
{
  char yahoo_id[255];
  char name[255];
  int status;
  int away;
  char *msg;
  char group[255];
} yahoo_account;

typedef struct
{
  int id;
  char *label;
} yahoo_idlabel;

typedef struct
{
  int id;
  char *who;
} yahoo_authorize_data;

typedef struct
{
  int id;
  char * room_name;
  char * host;
  YList * members;
  int joined;
} conf_room;

struct connect_callback_data
{
  yahoo_connect_callback callback;
  void * callback_data;
  int id;
  int tag;
};

struct _conn
{
  int tag;
  int fd;
  int id;
  yahoo_input_condition cond;
  void *data;
  int remove;
};

struct get_file_geturl_data
{ 
  char *who, *fname, *url, *msg;
  unsigned long fsize;
};
typedef struct get_file_geturl_data get_file_geturl_data_t;

void get_file_geturl_callback(int id, int fd, int error, const char * filename, unsigned long size, void *data);

void ext_yahoo_got_im (int id, char *who, char *msg, long tm,
		       int stat, int utf8);
void register_callbacks ();
int fileno (FILE * stream);
FILE *popen (const char *command, const char *type);
int pclose (FILE * stream);
int gethostname (char *name, size_t len);
conf_room *find_conf_room_by_name_and_id (int id, const char * name);
void main_loop ();
int messenger_main (int argc, char *argv[]);
char *yahoo_status_code(enum yahoo_status s);
int get_quit_flag (void);
void set_quit_flag (int quit_flag_value);
void fh_quit ();
int get_yahoo_session_id ();
yahoo_local_account *get_fh_session ();
YList *get_fh_buddies ();
YList *get_fh_conferences ();
YList *get_fh_ignores ();

#endif /* _YAHOO_BACKEND_H */
