(define dit ".")
(define daw "-")
(use-modules (ice-9 string-fun))

(define (etom alpha)
   "convert alphabet to morse equivalent"
   (cond 
         ((string=? alpha "a") (string-append dit daw))
         ((string=? alpha "b") (string-append daw dit dit dit))
         ((string=? alpha "c") (string-append daw dit daw dit))
         ((string=? alpha "d") (string-append daw dit dit))
         ((string=? alpha "e") (string-append dit))
         ((string=? alpha "f") (string-append dit dit daw dit))
         ((string=? alpha "g") (string-append daw daw dit))
         ((string=? alpha "h") (string-append dit dit dit dit))
         ((string=? alpha "i") (string-append dit dit))
         ((string=? alpha "j") (string-append dit daw daw daw))
         ((string=? alpha "k") (string-append daw dit daw))
         ((string=? alpha "l") (string-append dit daw dit dit))
         ((string=? alpha "m") (string-append daw daw))
         ((string=? alpha "n") (string-append daw dit))
         ((string=? alpha "o") (string-append daw daw daw))
         ((string=? alpha "p") (string-append dit daw daw dit))
         ((string=? alpha "q") (string-append daw daw dit daw))
         ((string=? alpha "r") (string-append dit daw dit))
         ((string=? alpha "s") (string-append dit dit dit))
         ((string=? alpha "t") (string-append daw))
         ((string=? alpha "u") (string-append dit dit daw))
         ((string=? alpha "v") (string-append dit dit dit daw))
         ((string=? alpha "w") (string-append dit daw daw))
         ((string=? alpha "x") (string-append daw dit dit daw))
         ((string=? alpha "y") (string-append daw dit daw daw))
         ((string=? alpha "z") (string-append daw daw dit dit))

         ((string=? alpha "A") (string-append dit daw))
         ((string=? alpha "B") (string-append daw dit dit dit))
         ((string=? alpha "C") (string-append daw dit daw dit))
         ((string=? alpha "D") (string-append daw dit dit))
         ((string=? alpha "E") (string-append dit))
         ((string=? alpha "F") (string-append dit dit daw dit))
         ((string=? alpha "G") (string-append daw daw dit))
         ((string=? alpha "H") (string-append dit dit dit dit))
         ((string=? alpha "I") (string-append dit dit))
         ((string=? alpha "J") (string-append dit daw daw daw))
         ((string=? alpha "K") (string-append daw dit daw))
         ((string=? alpha "L") (string-append dit daw dit dit))
         ((string=? alpha "M") (string-append daw daw))
         ((string=? alpha "N") (string-append daw dit))
         ((string=? alpha "O") (string-append daw daw daw))
         ((string=? alpha "P") (string-append dit daw daw dit))
         ((string=? alpha "Q") (string-append daw daw dit daw))
         ((string=? alpha "R") (string-append dit daw dit))
         ((string=? alpha "S") (string-append dit dit dit))
         ((string=? alpha "T") (string-append daw))
         ((string=? alpha "U") (string-append dit dit daw))
         ((string=? alpha "V") (string-append dit dit dit daw))
         ((string=? alpha "W") (string-append dit daw daw))
         ((string=? alpha "X") (string-append daw dit dit daw))
         ((string=? alpha "Y") (string-append daw dit daw daw))
         ((string=? alpha "Z") (string-append daw daw dit dit))


         ((string=? alpha "0") (string-append daw daw daw daw daw))
         ((string=? alpha "1") (string-append dit daw daw daw daw))
         ((string=? alpha "2") (string-append dit dit daw daw daw))
         ((string=? alpha "3") (string-append dit dit dit daw daw))
         ((string=? alpha "4") (string-append dit dit dit dit daw))
         ((string=? alpha "5") (string-append dit dit dit dit dit))
         ((string=? alpha "6") (string-append daw dit dit dit dit))
         ((string=? alpha "7") (string-append daw daw dit dit dit))
         ((string=? alpha "8") (string-append daw daw daw dit dit))
         ((string=? alpha "9") (string-append daw daw daw daw dit))
         ((string=? alpha ".") (string-append dit daw dit daw dit daw))
         ((string=? alpha ",") (string-append daw daw dit dit daw daw))
         ((string=? alpha "?") (string-append dit dit daw daw dit dit))
         ((string=? alpha "'") (string-append dit daw daw daw daw dit))
         ((string=? alpha "!") (string-append daw dit daw dit daw daw))
         ((string=? alpha "/") (string-append daw dit dit daw dit))
         ((string=? alpha "(") (string-append daw dit daw daw dit daw))
         ((string=? alpha ")") (string-append daw dit daw daw dit daw))
         ((string=? alpha "&") (string-append dit dit dit dit))
         ((string=? alpha ":") (string-append daw daw daw dit dit dit))
         ((string=? alpha ";") (string-append daw dit daw dit daw dit))
         ((string=? alpha "=") (string-append daw dit dit dit daw))
         ((string=? alpha "-") (string-append daw dit dit dit dit daw))
         ((string=? alpha "_") (string-append dit dit daw daw dit daw))
         ((string=? alpha "\"") (string-append dit daw dit dit daw dit))
         ((string=? alpha "@") (string-append dit daw daw dit daw dit))
         ((string=? alpha " ") (string-append " "))
	 (else "")
   ))


(define (mtoe alpha)
   "convert alphabet to morse equivalent"
   (cond 
         ((string=? alpha (string-append dit daw )) "a")
         ((string=? alpha (string-append daw dit dit dit )) "b")
         ((string=? alpha (string-append daw dit daw dit )) "c")
         ((string=? alpha (string-append daw dit dit )) "d")
         ((string=? alpha (string-append dit )) "e")
         ((string=? alpha (string-append dit dit daw dit )) "f")
         ((string=? alpha (string-append daw daw dit )) "g")
         ((string=? alpha (string-append dit dit dit dit )) "h")
         ((string=? alpha (string-append dit dit )) "i")
         ((string=? alpha (string-append dit daw daw daw )) "j")
         ((string=? alpha (string-append daw dit daw )) "k")
         ((string=? alpha (string-append dit daw dit dit )) "l")
         ((string=? alpha (string-append daw daw )) "m")
         ((string=? alpha (string-append daw dit )) "n")
         ((string=? alpha (string-append daw daw daw )) "o")
         ((string=? alpha (string-append dit daw daw dit )) "p")
         ((string=? alpha (string-append daw daw dit daw )) "q")
         ((string=? alpha (string-append dit daw dit )) "r")
         ((string=? alpha (string-append dit dit dit )) "s")
         ((string=? alpha (string-append daw )) "t")
         ((string=? alpha (string-append dit dit daw )) "u")
         ((string=? alpha (string-append dit dit dit daw )) "v")
         ((string=? alpha (string-append dit daw daw )) "w")
         ((string=? alpha (string-append daw dit dit daw )) "x")
         ((string=? alpha (string-append daw dit daw daw )) "y")
         ((string=? alpha (string-append daw daw dit dit )) "z")

;         ((string=? alpha (string-append dit daw )) "A")
;         ((string=? alpha (string-append daw dit dit dit )) "B")
;         ((string=? alpha (string-append daw dit daw dit )) "C")
;         ((string=? alpha (string-append daw dit dit )) "D")
;         ((string=? alpha (string-append dit )) "E")
;         ((string=? alpha (string-append dit dit daw dit )) "F")
;         ((string=? alpha (string-append daw daw dit )) "G")
;         ((string=? alpha (string-append dit dit dit dit )) "H")
;         ((string=? alpha (string-append dit dit )) "I")
;         ((string=? alpha (string-append dit daw daw daw )) "J")
;         ((string=? alpha (string-append daw dit daw )) "K")
;         ((string=? alpha (string-append dit daw dit dit )) "L")
;         ((string=? alpha (string-append daw daw )) "M")
;         ((string=? alpha (string-append daw dit )) "N")
;         ((string=? alpha (string-append daw daw daw )) "O")
;         ((string=? alpha (string-append dit daw daw dit )) "P")
;         ((string=? alpha (string-append daw daw dit daw )) "Q")
;         ((string=? alpha (string-append dit daw dit )) "R")
;         ((string=? alpha (string-append dit dit dit )) "S")
;         ((string=? alpha (string-append daw )) "T")
;         ((string=? alpha (string-append dit dit daw )) "U")
;         ((string=? alpha (string-append dit dit dit daw )) "V")
;         ((string=? alpha (string-append dit daw daw )) "W")
;         ((string=? alpha (string-append daw dit dit daw )) "X")
;         ((string=? alpha (string-append daw dit daw daw )) "Y")
;         ((string=? alpha (string-append daw daw dit dit )) "Z")
;

         ((string=? alpha (string-append daw daw daw daw daw )) "0")
         ((string=? alpha (string-append dit daw daw daw daw )) "1")
         ((string=? alpha (string-append dit dit daw daw daw )) "2")
         ((string=? alpha (string-append dit dit dit daw daw )) "3")
         ((string=? alpha (string-append dit dit dit dit daw )) "4")
         ((string=? alpha (string-append dit dit dit dit dit )) "5")
         ((string=? alpha (string-append daw dit dit dit dit )) "6")
         ((string=? alpha (string-append daw daw dit dit dit )) "7")
         ((string=? alpha (string-append daw daw daw dit dit )) "8")
         ((string=? alpha (string-append daw daw daw daw dit )) "9")
         ((string=? alpha (string-append dit daw dit daw dit daw )) ".")
         ((string=? alpha (string-append daw daw dit dit daw daw )) ",")
         ((string=? alpha (string-append dit dit daw daw dit dit )) "?")
         ((string=? alpha (string-append dit daw daw daw daw dit )) "'")
         ((string=? alpha (string-append daw dit daw dit daw daw )) "!")
         ((string=? alpha (string-append daw dit dit daw dit )) "/")
         ((string=? alpha (string-append daw dit daw daw dit daw )) "(")
         ((string=? alpha (string-append daw dit daw daw dit daw )) ")")
         ((string=? alpha (string-append dit  dit dit dit )) "&")
         ((string=? alpha (string-append daw daw daw dit dit dit )) ":")
         ((string=? alpha (string-append daw dit daw dit daw dit )) ";")
         ((string=? alpha (string-append daw dit dit dit daw )) "=")
         ((string=? alpha (string-append daw dit dit dit dit daw )) "-")
         ((string=? alpha (string-append dit dit daw daw dit daw )) "_")
         ((string=? alpha (string-append dit daw dit dit daw dit )) "\"")
         ((string=? alpha (string-append dit daw daw dit daw dit )) "@")
         ((string=? alpha (string-append "")) " ")
	 (else "?")
   ))

(define (english-to-morse msg)
    "convert english msg to morse msg"
    (cond 
     ( (> (length (string->list msg)) 1 )
     (string-append (etom (list->string ( list (car (string->list msg))))) " "
         (english-to-morse (list->string (cdr (string->list msg))))
     ))
     ( (= (length (string->list msg)) 1 ) (etom msg))
    )
)

(define (m2e msg)
    "convert english msg to morse msg"
    (cond 
     ( (> (length msg) 1 )
     (string-append (mtoe (car msg)) 
         (m2e (cdr msg))
     ))
     ( (= (length msg) 1) (mtoe (car msg)))
    )
)

(define (morse-to-english msg)
 (m2e (separate-fields-discarding-char #\space msg list)))


(fh-register-command!
 '("/morse-send"
   "/morse-send BUDDY MORSE\n\t- xlate MORSE to english and send"))

(define (/morse-send args-list)
  (set! args-list (list->strlist args-list))
  (if (> (length args-list) 1)
    (begin
      (fh-send-message
       (car args-list)
       (morse-to-english
	      (list->asv (cdr args-list) " "))))
      (begin
	(display "/morse-send: wrong number of arguments\n")
	(display "usage: /morse-send BUDDY MORSE\n")) 
  ))


; incoming

(define enable-morse-recvs "no")

(define (fh-enable-morse-recvs)
  (set! enable-morse-recvs "yes"))


(define (fh-disable-morse-recvs)
  (set! enable-morse-recvs "no"))



(define (/morse-recv-on args-list)
  "enables morse-recving"
  (fh-enable-morse-recvs)
  (display "morse-recv turned [on], use /morse-recv-off to disable morse-recvs\n")
  (fh-register-command! 
   '("/morse-recv-off"
     "/morse-recv-off\n\t- disables morse-recv feature"))
  (fh-unregister-command! "/morse-recv-on"))

(define (morse? msg)
  (if (equal? enable-morse-recvs "yes")
   (english-to-morse msg)
   msg))
   
;;; Dynamic command support
(define (/morse-recv-off args-list)
  "disables morse-recving"
  (fh-disable-morse-recvs)
  (display "morse-recv turned [off], use /morse-recv-on to enable again\n")
  (fh-unregister-command! "/morse-recv-off")
  (fh-register-command! 
   '("/morse-recv-on"
     "/morse-recv-on\n\t- enables morse-recv feature")))


(fh-register-command! 
   '("/morse-recv-on"
     "/morse-recv-on\n\t- enables morse-recv feature"))

(fh-register-command!
   '("/morse-to-english"
     "/morse-to-english\n\t- xlate morse to english (locally)"))

(define (/morse-to-english args-list)
  (set! args-list (list->strlist args-list))
  (if (> (length args-list) 0)
      (begin
       (display (morse-to-english(list->asv  args-list " ")))
       (display "\n")
       )
      (begin
	(display "/morse-to-english: wrong number of arguments\n")
	(display "usage: /morse-to-english MORSE\n")) 
  ))



(fh-register-command!
   '("/english-to-morse"
     "/english-to-morse\n\t- xlate english to morse (locally)"))

(define (/english-to-morse args-list)
  (set! args-list (list->strlist args-list))
  (if (> (length args-list) 0)
      (begin
       (display (english-to-morse(list->asv  args-list " ")))
       (display "\n")
       )
      (begin
	(display "/english-to-morse: wrong number of arguments\n")
	(display "usage: /english-to-morse ENGLISH\n")) 
  ))


