;;; xmessage.scm: throw xmessage dialog with the message
;;; author: M.P.Anand Babu <ab@gnu.org.in>

;;; This program is free software; you can redistribute it and/or
;;; modify it under the terms of the GNU General Public License as
;;; published by the Free Software Foundation; either version 2, or (at
;;; your option) any later version.
;;; 
;;; This program is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;; General Public License for more details.
;;; 
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA

;;; example:
;;; ?xmessage bala hi, are you there
;;;

(define (xmessage from msg)
  "forward the messages sent to buddy"
  (if (string=? msg "")
      #f
      (if (string=? (car (sentence->words msg)) "?xmessage")
	  (begin
	    ;; gmessage -center -title Freehoo -button OK -default OK "balugi -> Hi AB"
	    (cond ((= (system "gmessage --help >> /dev/null 2>&1") 0)
		   (system (string-append
			    "gmessage -title Freehoo -center -buttons Close -default Close -wrap '"
			    from
			    " -> "
			    (list->asv (cdr (sentence->words msg)) " ")
			    "'&")))
		  ((= (system "xmessage >> /dev/null 2>&1") 256)
		   (system (string-append 
			    "xmessage -title Freehoo -center -buttons Close -default Close '"
			    from
			    " -> "
			    (list->asv (cdr (sentence->words msg)) " ")
			    "'&"))))))))

(add-hook! fh-message-receive-hook xmessage)

;; ;;; Dynamic command support
(fh-register-command!
 '("?xmessage"
   "?xmessage BUDDY MESSAGE\n\t- throw the MESSAGE in a xmessage dialog box"))
 
(define (?xmessage args-list)
  (set! args-list (list->strlist args-list))
  (if (> (length args-list) 1)
      (fh-send-message
       (car args-list)
       (string-append "?xmessage "
		      (list->asv (cdr args-list) " ")))
      (begin
	(display "?xmessage: wrong number of arguments\n")
	(display "usage: ?xmessage BUDDY MESSAGE\n"))))


