;;; init.scm: this initialization file is automatically loaded by default
;;; author: M.P.Anand Babu <ab@gnu.org.in>

;;; This program is free software; you can redistribute it and/or
;;; modify it under the terms of the GNU General Public License as
;;; published by the Free Software Foundation; either version 2, or (at
;;; your option) any later version.
;;; 
;;; This program is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;; General Public License for more details.
;;; 
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA
;;; 
;;; /usr/share/freehoo/extensions/init.scm will be automatically
;;; loaded during the startup. this file inturn loads the standard
;;; freehoo extensions and also does other external customizations.
;;; to overload this init.scm file, place your own init.scm in ur
;;; ~/.freehoo/extensions folder.

(use-modules (ice-9 debugger))
(debug-enable 'backtrace)

(define (delayed-loading)
  "loads module after post-login"
  ;; add your post-login modules
  ;  (fh-load "my-module")
  (if (string=? "gnubot" (fh-get-default-login-id))
      (fh-load "gnubot.scm")))

(catch #t
       (lambda ()
	 ;; set gnu prompt
	 (fh-set-prompt! "~qp~> ")
	 ;; turn bell ON
	 (fh-toggle! "bell")
	 ;; show all
	 (fh-toggle! "who")
	 ;; auto-insert mode
	 (fh-toggle! "session")
	 ;; show status messages
	 (fh-toggle! "status")
	 (fh-load "utils.scm")
	 (fh-load "color.scm")
	 (fh-load "alias.scm")
	 ;; obsoleted by actual yahoo protocol ignore facility
	 ;; (fh-load "ignore.scm")
	 (fh-load "cc.scm")
	 (fh-load "forward.scm")
	 (fh-load "conference.scm")
	 (fh-load "history.scm")
	 (fh-load "shell.scm")
	 (fh-load "ping.scm")
	 (fh-load "proud-of-freehoo.scm")
	 (fh-load "broadcast.scm")
	 (fh-load "xmessage.scm")
	 (if (= (system "dict gnu >> /dev/null 2>&1") 0)
	     (fh-load "dict-buddy.scm"))
	 (add-hook! fh-login-post-hook delayed-loading))
       (lambda (k args . opts)
	 (display "\n~qp~_~qp~_~qp~_~qp~_~qp~_~qp~")
	 (display "\n~qp  FreeHoo Exception!! ~qp~")
	 (display "\n~qp~_~qp~_~qp~_~qp~_~qp~_~qp~")
	 (display "\n(SCM exception handler)")
	 (display "\nkey        : ")
	 (display k)
	 (display "\nthrow args : ")
	 (display args)
	 (display "\nopts       : ")
	 (display opts)
	 (newline)
	 (backtrace)
	 (newline)))
