;;; forward.scm: Forward the messages to other buddies in the list too
;;; author: M.P.Anand Babu <ab@gnu.org.in>

;;; This program is free software; you can redistribute it and/or
;;; modify it under the terms of the GNU General Public License as
;;; published by the Free Software Foundation; either version 2, or (at
;;; your option) any later version.
;;; 
;;; This program is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;; General Public License for more details.
;;; 
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA

;;; example:
;;; forward.scm will be automatically loaded thru init.scm
;;; (define forward '((rms . (gnuindian nagappanal kvisu2000 bala))
;;; 		 (gopal . (mehta))))

(if (defined? 'forward)
    '()
    (begin
      (define forward '())))
 
(define (forward-buddy from msg)
  "forward the messages sent to buddy"
  (and (list? (assq-ref forward (string->symbol from)))
       (send-message-to-group (assq-ref forward (string->symbol from))
			      (string-append "Forward:" from " " msg))))

(add-hook! fh-message-receive-hook forward-buddy)

;;; Dynamic command support
(fh-register-command! '("?forward" "?forward BUDDY FORWARD-LIST\n\t- forward message of a BUDDY to a FORWARD-LIST"))

(define (?forward args-list)
  (if (> (length args-list) 1)
      (set! forward (assoc-set! forward (car args-list) (cdr args-list)))
      (begin (display "?forward: wrong number of arguments\n") 
	     (display "usage: ?forward buddy-name forward-list"))))

