;;; broadcast.scm: message broadcast facility
;;; author: K.Viswanathan <gnuvisu@yahoo.com>

;;; This program is free software; you can redistribute it and/or
;;; modify it under the terms of the GNU General Public License as
;;; published by the Free Software Foundation; either version 2, or (at
;;; your option) any later version.
;;; 
;;; This program is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;; General Public License for more details.
;;; 
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA
;;;
;;; broadcast.scm should be automatically loaded by init.scm
;;; usage:
;;; To broadcast a message to everbody in the list
;;;  /broadcast Hello Everybody
;;; (or) simply,
;;;  * Hello Everybody

;;; Dynamic command support
(fh-register-command! 
 '("/broadcast" 
   "/broadcast MESSAGE\n\t- broadcast MESSAGE to everybody"))

(fh-register-command!
 '("*"
   "* MESSAGE\n\t- broadcast MESSAGE to everybody"))

(define (/broadcast args-list)
  (set! args-list (list->strlist args-list))
  (if (> (length args-list) 0)
      (send-message-to-group
       (fh-get-buddy-list)
       (list->asv args-list " "))
      (begin
	(display "/broadcast: wrong number of arguments\n")
	(display "usage: /broadcast MESSAGE\n"))))

(define (* args-list)
  (set! args-list (list->strlist args-list))
  (if (> (length args-list) 0)
      (send-message-to-group
       (fh-get-buddy-list)
       (list->asv args-list " "))
      (begin
	(display "*: wrong number of arguments\n")
	(display "usage: * MESSAGE\n"))))
