//
// C++ Implementation: dlsmanager
//
// Description: 
//
//
// Author: Predrag Viceic <viceic@net2000.ch>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "dlsmanager.h"

DLSManager::DLSManager(QObject *parent, const char *name)
 : QObject(parent, name)
{
}


DLSManager::~DLSManager()
{
}

void DLSManager::writeDLS2File(QString outputfileName,QStringList* filenames,QValueList <beatline_data> bld){
    char nb_keygroups=filenames->size();
    qHeapSort(bld);
    
    IpatchFile *file;
    IpatchDLSFile *dlsfile;
    IpatchDLS2Sample *sample;

    IpatchConverter *conv;
    GType convtype;
    GError *err = NULL;
    char  *name;
    
    /* initialize libInstPatch */
    ipatch_init ();
    

    IpatchDLS2* dls2=ipatch_dls2_new();
    
    
    /*create new DLS2 instrument (++ ref) */
    IpatchDLS2Inst* inst = ipatch_dls2_inst_new ();
    /* set instrument name */
    g_object_set (inst, "name",
        QString(QFileInfo(outputfileName).fileName()).ascii(), NULL); 
    /* append instrument to DLS2 (ensure that its name is unique) */
    ipatch_container_add_unique (IPATCH_CONTAINER (dls2),IPATCH_ITEM (inst));



    
    for (int i=0;i<nb_keygroups;i++){
        QString filename=filenames->operator[](i);
        filename.prepend(outputfileName+"/");
        int midiNote=bld[i].midiNote;
        if (midiNote==-1){
            cout<<"file: "<<filename<<" midi: "<<midiNote<<"\n";
            continue;
        }
        /* identify and open file (++ new object reference) */
        file = ipatch_file_identify_open (filename.ascii(), "r", &err);
        if (!file){
	  fprintf (stderr, "Failed to identify file '%s': %s\n", filename.ascii(),
		   ipatch_gerror_message (err));
	  g_clear_error (&err);
	  continue;
	}
	/* lookup converter type for the given conversion (file -> DLS2Sample) */
        convtype = ipatch_find_converter (G_OBJECT_TYPE (file),
					IPATCH_TYPE_DLS2_SAMPLE,
					IPATCH_CONVERTER_FIND_PARENT, IPATCH_CONVERTER_FIND_PARENT);
        if (!convtype)		/* conversion type found? */
	{
	  fprintf (stderr, "Unable to convert file '%s', type %s to %s\n",
		   filename.ascii(), g_type_name (G_OBJECT_TYPE (file)),
		   g_type_name (IPATCH_TYPE_DLS2_SAMPLE));

	  g_object_unref (file); /* remove file reference */

	  continue;
	}
	
	sample = ipatch_dls2_sample_new (); /* ++ ref new DLS2 sample */
      

        conv = (IpatchConverter*)g_object_new (convtype, NULL); /* ++ ref new converter object */
    
        /* set input and output object of converter */
        ipatch_converter_add_input (conv, G_OBJECT (file));
        ipatch_converter_add_output (conv, G_OBJECT (sample));
    
        /* convert the sample file to a DLS2 sample */
        if (!ipatch_converter_convert (conv, &err))
        {
            fprintf (stderr,
                    "Failed to convert sample file to DLS2 sample: %s\n",
                    ipatch_gerror_message (err));
    
            g_clear_error (&err);
    
            g_object_unref (conv); /* -- unref converter */
            g_object_unref (sample); /* -- unref DLS2 sample */
            g_object_unref (file); /* -- unref file */
    
            continue;
        }
    
        g_object_unref (conv);	/* -- unref the converter */
        
        /* append sample to DLS2 (ensure that its name is unique) */
        ipatch_container_add_unique (IPATCH_CONTAINER (dls2),
                                    IPATCH_ITEM (sample));
    
        g_object_get (sample, "name", &name, NULL); /* get the sample's name */
        //g_object_set (sample, "root-note", midiNote, NULL); /* set the sample's root-note */      
        
        /* create new instrument zone and link sample to it */
        
        IpatchDLS2Region* region=ipatch_dls2_region_new();
        ipatch_dls2_region_set_sample(region,sample);
        ipatch_container_add (IPATCH_CONTAINER (inst), IPATCH_ITEM (region));
        
        
        g_object_set(region,"key-range-low", midiNote, NULL);
        g_object_set(region,"key-range-high", midiNote, NULL);
  
        g_object_unref(region);
        g_object_unref (sample); /* -- unref DLS sample */
        g_free (name);  /* free the name (returned from g_object_get) */
        g_object_unref (file);	/* -- unref file */
    }
    g_object_unref (inst);	/* -- unref DLS instrument */

    /* create DLS2 file object, set its name and open for writing */
    dlsfile = ipatch_dls_file_new ();
    
    if (!ipatch_file_open (IPATCH_FILE (dlsfile), outputfileName.append(".dls").ascii(), "w", &err)){
        fprintf (stderr, "Failed to open output file for writing: %s\n",
                ipatch_gerror_message (err));
    
        g_object_unref (dlsfile);	/* -- unref DLS file */
        g_object_unref (dls2);	/* -- unref DLS object */
    
        return;
    }
    

    /* lookup converter type for DLS2 -> File (save) */
    convtype = ipatch_find_converter (IPATCH_TYPE_DLS2, IPATCH_TYPE_DLS_FILE,
                                      IPATCH_CONVERTER_FIND_CHILD, IPATCH_CONVERTER_FIND_CHILD);
                                      
    if(convtype==0) cout<<"conftype null!\n";
    
    conv = (IpatchConverter*) g_object_new (convtype, NULL);	/* ++ ref new converter */

    
    /* set input and output objects of converter */
    ipatch_converter_add_input (conv, G_OBJECT (dls2));
    ipatch_converter_add_output (conv, G_OBJECT (dlsfile));
    cout<<"OK3\n";
    if (!ipatch_converter_convert (conv, &err)){
        fprintf (stderr, "Failed to save DLS2 to file: %s\n",
                ipatch_gerror_message (err));
        g_clear_error (&err);
    }
    cout<<"OK4\n";
    g_object_unref (conv);	/* -- unref converter */
    g_object_unref (dlsfile);	/* -- unref DLS2 file */
    g_object_unref (dls2);		/* -- unref DLS2 object */
    cout<<"OK5\n";
    //return (0);			/* we done, yeah! :) */

}


