/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "valueline.h"

ValueLine::ValueLine(QCanvas* canvas,long _pos,float* val)
    : QCanvasRectangle(canvas)
{
    samplePos=_pos;
    value=val;
}


ValueLine::~ValueLine()
{
}




/*!
    \fn ValueLine::getSamplePos()

    \return sample position of this value
*/
long ValueLine::getSamplePos()
{
    return samplePos;
}

/*!
    \fn ValueLine::getValue()

    \return the the value in LADSPAPort#valuesOverTime
*/

float ValueLine::getValue(){
    return *value;
}


/*!
    \fn ValueLine::getValuePointer()

    used for the modifications of the values in LADSPAPort::valuesOverTime

    \return the pointer to the value in LADSPAPort::valuesOverTime
 */
float* ValueLine::getValuePointer()
{
    return value;
}


/*!
    \fn ValueLine::rtti()

    \sa QCanvasItem#rtti()
 */
int ValueLine::rtti() const
{
    return RTTI_VALUELINE;
}

void ValueLine::drawShape ( QPainter & p ){
    if(width()>3){
        p.fillRect(x(),y(),width(),height(),QBrush(QColor(50,50,100)));
        p.drawRect(x(),y(),width(),height());
    }else{
        p.setPen(QColor(50,50,100));
        p.drawLine(x(),y(),x(),y()+height());
    }
    

}


/*!
    \fn ValueLine::startPoint()
 */
QPoint ValueLine::startPoint()
{
    return QPoint(x(),y());
}


/*!
    \fn ValueLine::endPoint()
 */
QPoint ValueLine::endPoint()
{
    return QPoint(x(),y()+height());
}


/*!
    \fn ValueLine::setPoints(int x1, int y1, int x2, int y2)
 */
void ValueLine::setPoints(int x1, int y1, int x2, int y2)
{
    setX(x1);
    setY(y1);
    setSize(x2-x1,y2-y1);
}


/*!
    \fn ValueLine::setWidth(int)
 */
void ValueLine::setWidth(int w)
{
    setSize(w,height());
}


/*!
    \fn ValueLine::setSamplePos(long pos)
 */
void ValueLine::setSamplePos(long pos)
{
    samplePos=pos;
}


/*!
    \fn ValueLine::setValuePointer(float* val)
 */
void ValueLine::setValuePointer(float* val)
{
    value=val;
}
