/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 /*
    JACK layer taken from AlsaModularSynth project by Matthias Nagorni
    http://alsamodular.sourceforge.net/

    /dev/dsp layer taken from libsndfile examples by Erik de Castro Lopo
    http://www.mega-nerd.com/libsndfile/
*/

#ifndef SOUNDPLAYER_H
#define SOUNDPLAYER_H

#include <qthread.h>
#include <sndfile.h>
#include <stdio.h>
#include <iostream>
#include 	<fcntl.h>
#include 	<sys/ioctl.h>
#include 	<sys/soundcard.h>
#include 	<string.h>
#include <unistd.h>
#include <qcanvas.h>
#include <qsplashscreen.h>
#include <qapplication.h>
#include "drawsoundwidget.h"
#include "spectrumview.h"
#include "soundmanager.h"
#include "playpositionchanged.h"
#include <jack/jack.h>
#include "portaudio.h"
#include "qdatetime.h"

/**
@author Predrag Viceic

\class SoundPlayer

\brief class used for playing

This class can play via JACK interface (OutputDriver::OUTPUT_JACK) or to /dev/dsp
(OutputDriver::OUTPUT_DEVDSP).
Depending of your system configuration this class will choose automatically between the two output methods
*/
class SoundPlayer :public QThread
{
public:
    SoundPlayer();
    ~SoundPlayer();
    void setSoundmanager(SoundManager*);
    int linux_open_dsp_device(int, int);
    void run();
    void exit(int);
    void playDevDsp();
    void stopPlay();
    void positionChanged(long);
    QPtrList <QObject> soundMonitors;
    bool isPlaying();
    void setPlaying(bool);
    void setLoop(long,long);
    void setOneTimeLoop(long,long);
    void setPlayingOnce(bool);
    int connect_jack();
    int connect_devdsp();
    enum OutputDriver {OUTPUT_NONE,OUTPUT_DEVDSP,OUTPUT_JACK,OUTPUT_PORTAUDIO};
    static const int PLAY_PORTS=2;
    OutputDriver output;
    static int jack_static_callback (jack_nframes_t , void *);
    int jack_callback (jack_nframes_t);
    void init();
    void setBufferLen(int);
    void setJackBuffersLen(int);
    int getOutputType();
    void cropped(long,long);
    int setJackNotPlaying(jack_default_audio_sample_t *, jack_nframes_t);
    void addSoundMonitor(QObject*);
    void initLoop();
    void playFromFile(QString path);
    void playFromFileThreaded();
    void stopPlayFromFile();
    void resetLoop();
    void setPosition(long pos);
    void close();
    void removeSoundMonitor(QObject* sm);
    void pausePlayFromFile();
    static int portaudio_static_callback( const void *inputBuffer, void *outputBuffer,
                     unsigned long framesPerBuffer,
                     const PaStreamCallbackTimeInfo* timeInfo,
                     PaStreamCallbackFlags statusFlags, void *userData );
    int portaudio_callback( const void *inputBuffer, void *outputBuffer,
                     unsigned long framesPerBuffer,
                     const PaStreamCallbackTimeInfo* timeInfo,
                     PaStreamCallbackFlags statusFlags);
    int connect_portaudio();
    void closePortaudio();
    int startPAStream();
    int stopPAStream();

	void setLeftLoop(const long& theValue);
	

	long getLeftLoop() const;
	
    

protected:
    SoundManager* soundManager;
    long position; /**< current playing position */
    bool playing; /**  are we playing? */
    bool playingOnce; /**< should we stop at the end of the loop ? */
    bool stopped; /**< should we stop at the next return from callback? */
    short* bufferLR;
    float* bufferPointerL;
    float* bufferPointerR;
    int buffer_len;
    long leftLoop;
    long rightLoop;
    long savedLeftLoop;
    long savedRightLoop;
    int closeJack();

	void setRightLoop(const long& theValue);
	

	long getRightLoop() const;
	
    int devdsp_audio_device;
    jack_client_t *jack_handle;
    jack_port_t *jack_out [PLAY_PORTS];
    QString playFromFilePath;
    SNDFILE* previewFile;
    SF_INFO sfinfoForPreview;
    bool closeV;
    PaStream *portaudio_stream;

private:
    bool playFromFileV;
};

#endif
