//
// C++ Implementation: showinsertatrect
//
// Description: 
//
//
// Author: Predrag Viceic <viceic@net2000.ch>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "showinsertatrect.h"

ShowInsertAtRect::ShowInsertAtRect(QCanvas* canvas)
 : QCanvasRectangle(canvas)
{
}


ShowInsertAtRect::~ShowInsertAtRect()
{
}

void ShowInsertAtRect::drawShape( QPainter &p ){
    
    RasterOp oldRop=p.rasterOp();
    p.setRasterOp(Qt::NotAndROP);
    p.fillRect(rect(),QBrush(QColor(0,0,100)));
    int image_pos_offset=rect().width()/2-13;
    image_pos_offset=image_pos_offset<0?0:image_pos_offset;
    p.drawPixmap(rect().x()+image_pos_offset,
                rect().height()/2-70,QPixmap(qembed_findImage("replace-label")));
    p.setRasterOp(oldRop);
}




/*!
    \fn ShowInsertAtRect::setGeom(int x, int width)
 */
void ShowInsertAtRect::setGeom(int x, int width)
{
    setX(x);
    setY(0);
    setSize(width, canvas()->height());
}

QPointArray  ShowInsertAtRect::areaPoints() const{
    int width=rect().width()>=26?rect().width():26; //image width is 26 ...
    QPointArray result(4);
    result.setPoint(0,QPoint((int)(rect().x())-1,-1));
    result.setPoint(1,QPoint((int)(rect().x())+width+1,-1));
    result.setPoint(2,QPoint((int)(rect().x())+width+1,canvas()->height()+1));
    result.setPoint(3,QPoint((int)(rect().x())-1,canvas()->height()+1));
    return result;
}
