//
// C++ Implementation: samplenumberdisplay
//
// Description: 
//
//
// Author: Predrag Viceic <viceic@net2000.ch>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "samplenumberdisplay.h"

SampleNumberDisplay::SampleNumberDisplay(QCanvas* canvas)
 : QCanvasRectangle(canvas)
{
    setSize(30,30);
    eraseRect=new QRect(0,0,8,8);
    sceneRect=new QRect(0,0,13,13);
    assignedFile="";
    scenes.resize(7);
    scenes.setAutoDelete(TRUE);
    scene* scene1=new scene;
    scene1->color=QColor(255,255,255);
    scene1->taken=FALSE;
    scenes.insert(0,scene1);
    
    scene* scene2=new scene;
    scene2->color=QColor(0,255,0);
    scene2->taken=FALSE;
    scenes.insert(1,scene2);
    
    scene* scene3=new scene;
    scene3->color=QColor(0,0,255);
    scene3->taken=FALSE;
    scenes.insert(2,scene3);
    
    scene* scene4=new scene;
    scene4->color=QColor(0,255,255);
    scene4->taken=FALSE;
    scenes.insert(3,scene4);
    
    scene* scene5=new scene;
    scene5->color=QColor(255,255,0);
    scene5->taken=FALSE;
    scenes.insert(4,scene5);
    
    scene* scene6=new scene;
    scene6->color=QColor(255,0,255);
    scene6->taken=FALSE;
    scenes.insert(5,scene6);
    
    scene* scene7=new scene;
    scene7->color=QColor(100,100,100);
    scene7->taken=FALSE;
    scenes.insert(6,scene7);

    sceneNumber=0;
    //sceneColors.append(QColor(255,255,255));
    
}


SampleNumberDisplay::~SampleNumberDisplay()
{
    delete eraseRect;
    QFile file(getAssignedFile());
    if(file.exists()) file.remove();
    current=FALSE;
}

void SampleNumberDisplay::drawShape( QPainter &p ){
    
    QFont oldfont=p.font();
    QFont newfont=oldfont;
    newfont.setPointSize(11);
    p.setFont(newfont);
    RasterOp oldRop=p.rasterOp();
    p.setRasterOp(Qt::AndROP);
    QRect drawRect=rect();
    drawRect.addCoords(4,4,-4,-4);
    
    if(getCurrent()){
        p.setBrush(QBrush(QColor(200,100,100)));
        p.drawEllipse(drawRect);
        p.setBrush(QBrush(Qt::NoBrush));
        p.drawEllipse(drawRect);
        p.drawText(drawRect,Qt::AlignCenter,QString::number(number));
    }else{
        p.setBrush(QBrush(QColor(200,200,200)));
        p.drawEllipse(drawRect);
        p.setBrush(QBrush(Qt::NoBrush));
        p.drawEllipse(drawRect);
        p.drawText(drawRect,Qt::AlignCenter,QString::number(number));
    }
    
    p.setBrush(QBrush(red));
    p.setRasterOp(Qt::CopyROP);
    eraseRect->moveBottomRight(rect().bottomRight());
    p.drawEllipse(*eraseRect);
    p.drawLine(eraseRect->topLeft(),eraseRect->bottomRight());
    p.drawLine(eraseRect->bottomLeft(),eraseRect->topRight());

    newfont.setPointSize(9);
    p.setFont(newfont);
    p.setBrush(QBrush(scenes[getScene()]->color));
    sceneRect->moveTopLeft(rect().topLeft());
    p.drawEllipse(*sceneRect);
    p.setBrush(QBrush(Qt::NoBrush));
    p.drawEllipse(*sceneRect);
    p.drawText(*sceneRect,Qt::AlignCenter,QString::number(getScene()));
    
    p.setRasterOp(oldRop);
    p.setFont(oldfont);
}

QPointArray  SampleNumberDisplay::areaPoints() const{
    return QCanvasRectangle::areaPoints();
    /*
    QPointArray result(4);
    result.setPoint(0,QPoint((int)(rect().x())-1,-1));
    result.setPoint(1,QPoint((int)(rect().x())+rect().width()+1,-1));
    result.setPoint(2,QPoint((int)(rect().x())+rect().width()+1,canvas()->height()+1));
    result.setPoint(3,QPoint((int)(rect().x())-1,canvas()->height()+1));
    return result;
    */
}




QString SampleNumberDisplay::getAssignedFile() const {
    return assignedFile;
}


int SampleNumberDisplay::getNumber() const {
    return number;
}

void SampleNumberDisplay::setCurrent(bool theValue) {
        current = theValue;
        //if(current) cout<<getAssignedFile()<<endl;
    }

bool SampleNumberDisplay::getCurrent() const {
    return current;
}


/*!
    \fn SampleNumberDisplay::getEraseHandle() const
 */
QRect* SampleNumberDisplay::getEraseHandle()
{
    return eraseRect;
}

void SampleNumberDisplay::setCanErase(bool theValue) {
        if(!theValue) eraseRect->setSize(QSize(0,0));
        else eraseRect->setSize(QSize(8,8));
}


/*!
    \fn SampleNumberDisplay::getSceneHandle()
 */
QRect* SampleNumberDisplay::getSceneHandle()
{
    return sceneRect;
}


/*!
    \fn SampleNumberDisplay::incrementScene()
 */
void SampleNumberDisplay::incrementScene()
{
    int oldNumber=sceneNumber;
    sceneNumber++;
    while(sceneNumber<scenes.count()){
        cout<<sceneNumber<<endl;
        if(!scenes[sceneNumber]->taken){
            scenes[sceneNumber]->setTaken(TRUE);
            scenes[oldNumber]->setTaken(FALSE);
            return;
        }
        sceneNumber++;
    }
    sceneNumber=0;
    scenes[oldNumber]->setTaken(FALSE);
}


int SampleNumberDisplay::getScene() const {
    return sceneNumber;
}

void SampleNumberDisplay::setScene(int sc){
    sceneNumber=sc;
    update();
}


/*!
    \fn SampleNumberDisplay::setSceneStatus(int sc,bool stat)
 */
void SampleNumberDisplay::setSceneStatus(int sc,bool stat)
{
    scenes[sc]->setTaken(stat);
}


/*!
    \fn SampleNumberDisplay::getSceneCount()
 */
int SampleNumberDisplay::getSceneCount()
{
    return scenes.count();
}


/*!
    \fn SampleNumberDisplay::getSceneStatus(int sc)
 */
bool SampleNumberDisplay::getSceneStatus(int sc)
{
    return scenes[sc]->taken;
}


/*!
    \fn SampleNumberDisplay::setSceneStatus(bool * scenestatus)
 */
void SampleNumberDisplay::setSceneStatus(bool * scenestatus)
{
    for (int i=0;i<scenes.count();i++){
        scenes[i]->setTaken(scenestatus[i]);
    }
}
