/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "replacedwaveholder.h"

ReplacedWaveHolder::ReplacedWaveHolder(QWidget *parent, const char *name)
 : QScrollView(parent, name)
{
    setAcceptDrops(TRUE);
    frames=0;
    zoomRatio=1;
    setVScrollBarMode(AlwaysOff);
    setHScrollBarMode(AlwaysOff);
    enableClipper(TRUE);
}


ReplacedWaveHolder::~ReplacedWaveHolder()
{
}

void ReplacedWaveHolder::dragEnterEvent(QDragEnterEvent* event)
{
    event->accept(
            QTextDrag::canDecode(event));
}

void ReplacedWaveHolder::dropEvent(QDropEvent* event)
{
    QString text;

    if ( QTextDrag::decode(event, text) ) {
        //setEnvelopeAt(event->pos(),text);
    }
}






/*!
    \fn EnvelopeHolder::setZoomRatio(long)
 */
void ReplacedWaveHolder::setZoomRatio(long _zr)
{
    zoomRatio=_zr;
    resizeContents((int)((double)frames/(double)zoomRatio),visibleHeight());
    //drawEnvelopes();
    repaint();
}

void ReplacedWaveHolder::setFrames(long _fr){
    frames=_fr;
}





/*!
    \fn ReplacedWaveHolder::setWaveAt(QPoint p,QString filename)
 */
void ReplacedWaveHolder::setWaveAt(QPoint p,QString filename)
{
    this->show();
}
