//
// C++ Interface: midiinput
//
// Description: 
//
//
// Author: Predrag Viceic <viceic@net2000.ch>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef MIDIINPUT_H
#define MIDIINPUT_H

#include <qobject.h>
#include "portmidi.h"
#include "porttime.h"
#include "defs.h"
#include "qstringlist.h"
#include "soundplayer.h"
#include "beatlinedata.h"
#include "midiinputevent.h"
/**
@author Predrag Viceic
*/
class MidiInput : public QObject
{
Q_OBJECT
public:
    struct noteAssignements_t{
        long start;
        long stop;
    };
    MidiInput(QObject *parent = 0, const char *name = 0);

    ~MidiInput();
    void process();
    void printMessage(int msg);
    QStringList getDevices();
    int openDevice(int id);
    int getDefaultDevice();
    int getSelectedDevice();
    QString getSelectedDeviceString();
    QString getDefaultDeviceString();
    int openDevice(QString device);
    void setMidiChannel(int c);
    void setSoundPlayer(SoundPlayer* sp);
    void addMidiMonitor(QObject* mm);
    void removeMidiMonitor(QObject* mm);
public slots:
    void setBeatlineData(QValueList <beatline_data> bld);
protected:
    PortMidiStream* stream;
    int deviceOpened;
    int serviceInitDone;
    int selectedDevice;
    long midiFilter;
    SoundPlayer* soundPlayer;
    noteAssignements_t* noteAssignements;
    PmEvent* midiEventBuffer;
    QPtrList <QObject> midiMonitors;
    void emitMidiNote(int onoff, int note, int velocity);


protected:
    void playNote(int note);
};

#endif
