//
// C++ Implementation: helpmanager
//
// Description: 
//
//
// Author: Predrag Viceic <viceic@net2000.ch>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "helpmanager.h"

HelpManager::HelpManager(QString root_temp_dir,QObject *parent, const char *name)
 : QObject(parent, name)
{
        rootHelpDir=root_temp_dir;
        helpClient=new QAssistantClient("");
}


HelpManager::~HelpManager()
{
}




/*!
    \fn HelpManager::open()
 */
void HelpManager::open()
{
    if(!helpClient->isOpen()){
        if(!hasHelp()){
            QString s = QFileDialog::getOpenFileName(
                        0,
                        "Compressed help file (*.tgz *.tar.gz)",
                        0,
                        "Open compressed help file dialog",
                        "Choose a compressed help file" );
            cout<<"Selected doc file: "<<s<<endl;
            if(s!=NULL && QFile(s).exists()) uncompress(s);
        }
        if(hasHelp()){
            QStringList args;
            args.append("-profile");
            args.append(rootHelpDir+"/doc/freecycle-help.adp");
            helpClient->setArguments(args);
            helpClient->showPage(rootHelpDir+"/doc/index.html");
        }
     }
}



/*!
    \fn HelpManager::hasHelp()
 */
bool HelpManager::hasHelp()
{
    QDir doc(rootHelpDir+"/doc");
    QFile index_html(doc.path()+"/index.html");
    QDir images(doc.path()+"/images/");
    return (doc.exists() && index_html.exists() && images.exists() && images.count()>0);
}


/*!
    \fn HelpManager::uncompress(QString help_file)
 */
void HelpManager::uncompress(QString help_file)
{
    QProcess proc(this);
    proc.addArgument("tar");
    proc.addArgument("xz");
    proc.addArgument("-C");
    proc.addArgument(rootHelpDir);
    proc.addArgument("-f");
    proc.addArgument(help_file);
    proc.start();
    while(proc.isRunning()) sleep(10);
}
