/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "fftdialog.h"

FFTDialog::FFTDialog(SoundManager* sm,QWidget* parent, const char* name, bool modal, WFlags fl)
    : FFTDialogBase(parent,name, modal,fl)
{
    soundManager=sm;
    bm_range->setMinimumRange(100);
    s_range->setMinimumRange(100);
    setDefault();
    }

FFTDialog::~FFTDialog()
{}

/*$SPECIALIZATION$*/
void FFTDialog::reject()
{
  QDialog::reject();
}

void FFTDialog::accept()
{
    QDialog::accept();
  int window=0;
  int bm_padding=SoundManager::PAD_ZERO;
  int s_padding=SoundManager::PAD_ZERO;

  if (bm_pad_signal->isChecked()) bm_padding=SoundManager::PAD_SIGNAL;
  if (s_pad_signal->isChecked()) s_padding=SoundManager::PAD_SIGNAL;

  if(hanning_window->isChecked()) window=SoundManager::WINDOW_HANNING;
  else if(rect_window->isChecked()) window=SoundManager::WINDOW_RECTANGULAR;
  else if(gauss_window->isChecked()) window=SoundManager::WINDOW_GAUSS;
  soundManager->setFFTParams(     s_width_value->text().toInt(),
                                                                s_adv_value->text().toInt(),
                                                                  s_nbb_value->text().toInt(),
                                                                  s_padding,
                                                                  s_startfreq_value->text().toInt(),
                                                                  s_endfreq_value->text().toInt(),
                                                              bm_width_value->text().toInt(),
                                                                bm_adv_value->text().toInt(),
                                                                  bm_nbb_value->text().toInt(),
                                                                  bm_padding,
                                                                  bm_startfreq_value->text().toInt(),
                                                                  bm_endfreq_value->text().toInt(),
                                                                  window,normalize->isChecked());
}



