/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "customeffects.h"

CustomEffects::CustomEffects(QObject *parent, const char *name)
 : QObject(parent, name)
{
    QPtrList<CustomEffect> effects;
    effects.setAutoDelete(TRUE);
}


CustomEffects::~CustomEffects()
{
    effects.clear();
}




/*!
    \fn CustomEffects::processEffects(int length)
 */
void CustomEffects::processEffects(long length,int preOrPost)
{
    for (QPtrList<CustomEffect>::Iterator it = effects.begin();it!=effects.end();++it){
        if((*it)->preOrPost()==preOrPost){
                //cout<<"Processing:\t"<<(*it)->getName()<<"\n";
                (*it)->process(length);
        }
    }
}


/*!
    \fn CustomEffects::initEffects(long length)
 */
void CustomEffects::initEffects(long length)
{
    for (QPtrList<CustomEffect>::Iterator it = effects.begin();it!=effects.end();++it){
        (*it)->init(length);
    }
}


/*!
    \fn CustomEffects::add(CustomEffect*)
 */
void CustomEffects::add(CustomEffect* ef)
{
    effects.append(ef);
}


/*!
    \fn CustomEffects::advanceOutputPosition(long length)
 */
void CustomEffects::advancePositions(long length)
{
    for (QPtrList<CustomEffect>::Iterator it = effects.begin();
            it!=effects.end();++it){
        (*it)->advancePosition(length);
    }
}


/*!
    \fn CustomEffects::clear()
 */
void CustomEffects::clear()
{
    effects.clear();
}


/*!
    \fn CustomEffects::setOutputPositions(long position)
 */
void CustomEffects::setPositions(long position)
{
    for (QPtrList<CustomEffect>::Iterator it = effects.begin();
            it!=effects.end();++it){
        (*it)->setPosition(position);
    }
}
