//
// C++ Interface: samplenumberdisplay
//
// Description: 
//
//
// Author: Predrag Viceic <viceic@net2000.ch>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef SAMPLENUMBERDISPLAY_H
#define SAMPLENUMBERDISPLAY_H

#include <qcanvas.h>
#include <qpainter.h>
#include <qfontmetrics.h>
#include <qfile.h>
#include <qptrvector.h>
#include "defs.h"
/**
@author Predrag Viceic
*/
class SampleNumberDisplay : public QCanvasRectangle
{
public:
    SampleNumberDisplay(QCanvas* canvas);

    ~SampleNumberDisplay();
    
    QPointArray areaPoints() const;
    bool getCurrent() const;
    void setCurrent(bool theValue);

    void setAssignedFile(const QString& theValue) {
        assignedFile = theValue;
    }

    void setNumber(const int& theValue) {
        number = theValue;
    }
    

    int getNumber() const;
    
    QString getAssignedFile() const;
    QRect* getEraseHandle();

    void setCanErase(bool theValue);
    QRect* getSceneHandle();
    void incrementScene();

    int getScene() const;
    void setScene(int sc);
    void setSceneStatus(int sc,bool stat);
    int getSceneCount();
    bool getSceneStatus(int sc);
    void setSceneStatus(bool * scenestatus);
	
    struct scene{
        QColor color;
        bool taken;
        void setTaken(bool tf){
            taken=tf;
        }
    };
	
protected:
    void drawShape( QPainter & p);

    int number;
    QString assignedFile;
    bool current;
    QRect* eraseRect;
    QRect* sceneRect;
    int sceneNumber;
    QPtrVector<SampleNumberDisplay::scene> scenes;

};

#endif
