/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef MYSAVEFILEDIALOG_H
#define MYSAVEFILEDIALOG_H

#include <qfiledialog.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qhbuttongroup.h>
#include <qradiobutton.h>
#include <qspinbox.h>
#include <qhbox.h>
#include <qvbox.h>
#include <qvbuttongroup.h>
#include "bitspersampledropdown.h"

/**
@author Predrag Viceic
*/
class MySaveFileDialog : public QFileDialog
{
Q_OBJECT
public:
    MySaveFileDialog(QWidget *parent = 0, const char *name = 0);

    ~MySaveFileDialog();
    static const int EXPORT_ALL=0;
    static const int EXPORT_LOOP=1;
    bool exportMidifile();
    bool exportAKP();
    int exportMode();
    int getAttackTime();
    int getExportBitsPerSample();
    void setBps(int);
    bool assignMissingMIDINotes();
    bool exportSF2();
    bool exportGiga();
    bool exportDLS();
    bool removeChunks();
private:
    QCheckBox* exportMidifileCheckbox;
    QCheckBox* exportAKPCheckbox;
    QCheckBox* exportSF2Checkbox;
    QCheckBox* removeChunksCheckbox;
    QCheckBox* exportGigaCheckbox;
    QCheckBox* exportDLSCheckbox;
    QCheckBox* assignMissingMIDINotesCheckbox;
    QRadioButton* exportAll;
    QRadioButton* exportLoop;
    QSpinBox* attackTimeSpinBox;
    BitsPerSampleDropdown* exportBitsPerSampleDropdown;

public slots:
    int exec();
    void exportToSoftSamplerClicked();
    void checkIfMidiAutoAssignementNeeded();
};

#endif
