//
// C++ Implementation: gigamanager
//
// Description: 
//
//
// Author: Predrag Viceic <viceic@net2000.ch>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "gigamanager.h"

GigaManager::GigaManager(QObject *parent, const char *name)
 : QObject(parent, name)
{
}


GigaManager::~GigaManager()
{
}

void GigaManager::writeGigaFile(QString outputfileName,QStringList* filenames,QValueList <beatline_data> bld){
    char nb_keygroups=filenames->size();
    qHeapSort(bld);
    IpatchFile *file;
    IpatchGigFile *gigfile;
    IpatchGigInst *inst;
    IpatchGigSample *sample;
    IpatchGigRegion *region;
    IpatchConverter *conv;
    GType convtype;
    GError *err = NULL;
    char  *name;
    
    /* initialize libInstPatch */
    ipatch_init ();
    IpatchGig* gig = ipatch_gig_new ();	/* ++ ref new Gig object */
    /*create new Gig instrument (++ ref) */
    inst = ipatch_gig_inst_new ();
    /* set instrument name */

    /* append instrument to Gig (ensure that its name is unique) */
    ipatch_container_add_unique (IPATCH_CONTAINER (gig),IPATCH_ITEM (inst));
    
     
    for (int i=0;i<nb_keygroups;i++){
        QString filename=filenames->operator[](i);
        filename.prepend(outputfileName+"/");
        int midiNote=bld[i].midiNote;
        if (midiNote==-1){
            cout<<"file: "<<filename<<" midi: "<<midiNote<<endl;
            continue;
        }
        /* identify and open file (++ new object reference) */
        file = ipatch_file_identify_open (filename.ascii(), "r", &err);
        if (!file){
	  fprintf (stderr, "Failed to identify file '%s': %s\n", filename.ascii(),
		   ipatch_gerror_message (err));
	  g_clear_error (&err);
	  continue;
	}
	
	/* lookup converter type for the given conversion (file -> GigSample) */
	
        convtype = ipatch_find_converter (G_OBJECT_TYPE (file),
					IPATCH_TYPE_GIG_SAMPLE,
					IPATCH_CONVERTER_FIND_PARENT,
					IPATCH_CONVERTER_FIND_PARENT);
        
        if (!convtype)		/* conversion type found? */
	{
	   
	  fprintf (stderr, "Unable to convert file '%s', type %s to %s\n",
		   filename.ascii(), g_type_name (G_OBJECT_TYPE (file)),
		   g_type_name (IPATCH_TYPE_GIG_SAMPLE));

	  g_object_unref (file); /* remove file reference */

	  continue;
	}
	
	sample = ipatch_gig_sample_new (); /* ++ ref new Giga sample */


        conv = (IpatchConverter*)g_object_new (convtype, NULL); /* ++ ref new converter object */
    
        /* set input and output object of converter */
        ipatch_converter_add_input (conv, G_OBJECT (file));
        ipatch_converter_add_output (conv, G_OBJECT (sample));
        
        /* convert the sample file to a Giga sample */
        if (!ipatch_converter_convert (conv, &err))
        {
            fprintf (stderr,
                    "Failed to convert sample file to Gig sample: %s\n",
                    ipatch_gerror_message (err));
    
            g_clear_error (&err);
    
            g_object_unref (conv); /* -- unref converter */
            g_object_unref (sample); /* -- unref SoundFont sample */
            g_object_unref (file); /* -- unref file */
    
            continue;
        }
    
        g_object_unref (conv);	/* -- unref the converter */
        
    //    region=ipatch_gig_region_new (); /* ++ ref new Giga region */
	
	//ipatch_container_add (IPATCH_CONTAINER (inst), IPATCH_ITEM (region));
/*
        IpatchRange* range=ipatch_range_new();
        range->low=midiNote;
        range->high=midiNote;
        g_object_set(region,"key-range", range, NULL);
    
        ipatch_range_free(range);
  */      
        
	
	
    }

}



