/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "bpmmodifierdropdown.h"

BPMModifierDropDown::BPMModifierDropDown(QWidget *parent, const char *name)
 : QComboBox(parent, name)
{

    insertItem("1/4",0);
    insertItem("1/3",1);
    insertItem("1/2",2);
    insertItem("2/3",3);
    insertItem("3/4",4);
    insertItem("1/1",5);
    insertItem("3/2",6);
    insertItem("4/3",7);
    insertItem("5/3",8);
    insertItem("2/1",9);
    insertItem("8/3",10);

    value=5;
    setCurrentItem(5);
    connect(this,SIGNAL(activated(int)),this,SLOT(valueChanged(int )));
}


BPMModifierDropDown::~BPMModifierDropDown()
{
}




/*!
    \fn BPMModifierDropDown::getModifier()
 */
float BPMModifierDropDown::getModifier()
{
    switch(value){
        case 0: return 1.0/4.0;break;
        case 1: return 1.0/3.0;break;
        case 2: return 1.0/2.0;break;
        case 3: return 2.0/3.0;break;
        case 4: return 3.0/4.0;break;
        case 5: return 1;break;
        case 6: return 3.0/2.0;break;
        case 7: return 4.0/3.0;break;
        case 8: return 5.0/3.0;break;
        case 9: return 2;break;
        case 10: return 8.0/3.0;break;
    }
}


/*!
    \fn BPMModifierDropDown::valueChanged()
 */
void BPMModifierDropDown::valueChanged(int id)
{
    value=id;
    emit(valueChanged());
}




/*!
    \fn BPMModifierDropDown::getStringModifier()
 */
QString BPMModifierDropDown::getStringModifier()
{
    return currentText();
}


/*!
    \fn BPMModifierDropDown::setStringModifier(QString mod)
 */
void BPMModifierDropDown::setStringModifier(QString mod)
{
    setCurrentText(mod);
    for (int i=0;i<count();i++){
        if(text(i)==mod){
            value=i;
            emit(valueChanged());
            return;
        }
    }
}
