<?xml version='1.0' encoding='ISO-8859-1' standalone='yes'?>
<tagfile>
  <compound kind="class">
    <name>AKPManager</name>
    <filename>classAKPManager.html</filename>
    <member kind="function">
      <type></type>
      <name>AKPManager</name>
      <anchor>a0</anchor>
      <arglist>(QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>QByteArray</type>
      <name>getPaddedSampleName</name>
      <anchor>a2</anchor>
      <arglist>(QString filename)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeAKPFile</name>
      <anchor>a3</anchor>
      <arglist>(QString, QStringList *, QValueList&lt; beatline_data &gt; bld)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeZone</name>
      <anchor>a4</anchor>
      <arglist>(QFile *file, QString filename)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeKeygroup</name>
      <anchor>a5</anchor>
      <arglist>(QFile *file, QString filename, int i)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>write4Bytes</name>
      <anchor>a6</anchor>
      <arglist>(QFile *file, char fst=0x00, char snd=0x00, char trd=0x00, char fth=0x00)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeByte</name>
      <anchor>a7</anchor>
      <arglist>(QFile *file, char fst)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>BeatLine</name>
    <filename>classBeatLine.html</filename>
    <member kind="function">
      <type></type>
      <name>BeatLine</name>
      <anchor>a0</anchor>
      <arglist>(QCanvas *, long)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>getBeatPos</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>lock</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unlock</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>locked</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBpmLine</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isBpmLine</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>rtti</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>drawShape</name>
      <anchor>a9</anchor>
      <arglist>(QPainter &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QPointArray</type>
      <name>areaPoints</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMoving</name>
      <anchor>a11</anchor>
      <arglist>(bool tf)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isMoving</name>
      <anchor>a12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QRect *</type>
      <name>getHandle</name>
      <anchor>a13</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSamplePos</name>
      <anchor>a14</anchor>
      <arglist>(long pos)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSampleValueView</name>
      <anchor>a15</anchor>
      <arglist>(SampleValueView *svv)</arglist>
    </member>
    <member kind="function">
      <type>QRect *</type>
      <name>getRemoveHandle</name>
      <anchor>a16</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QRect *</type>
      <name>getLockUnlockHandle</name>
      <anchor>a17</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDrawHandles</name>
      <anchor>a18</anchor>
      <arglist>(int tf)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchor>a19</anchor>
      <arglist>(const BeatLine bl)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchor>a20</anchor>
      <arglist>(const BeatLine bl)</arglist>
    </member>
    <member kind="function">
      <type>QRect *</type>
      <name>getMidiNoteHandle</name>
      <anchor>a21</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMidiNote</name>
      <anchor>a22</anchor>
      <arglist>(int mn)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setEditingMidi</name>
      <anchor>a23</anchor>
      <arglist>(const int &amp;theValue)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getEditingMidi</name>
      <anchor>a24</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getMidiNote</name>
      <anchor>a25</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QRect</type>
      <name>boundingRect</name>
      <anchor>a26</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>beatline_data</type>
      <name>getData</name>
      <anchor>a27</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>long</type>
      <name>beatPos</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>locked_var</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>bpmLine</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>moving</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QRect *</type>
      <name>handle</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QRect *</type>
      <name>removeHandle</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QRect *</type>
      <name>lockunlockHandle</name>
      <anchor>p6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QRect *</type>
      <name>midiNoteHandle</name>
      <anchor>p7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SampleValueView *</type>
      <name>sampleValueView</name>
      <anchor>p8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>drawHandles</name>
      <anchor>p9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>midiNote</name>
      <anchor>p10</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>editingMidi</name>
      <anchor>p11</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>BeatLineList</name>
    <filename>classBeatLineList.html</filename>
    <member kind="function">
      <type>int</type>
      <name>compareItems</name>
      <anchor>a2</anchor>
      <arglist>(QPtrCollection::Item item1, QPtrCollection::Item item2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>BitsPerSampleDropdown</name>
    <filename>classBitsPerSampleDropdown.html</filename>
    <member kind="signal">
      <type>void</type>
      <name>valueChanged</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BitsPerSampleDropdown</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getModifier</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBps</name>
      <anchor>a3</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>value</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>QPopupMenu *</type>
      <name>dropDownMenu</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Blinkable</name>
    <filename>classBlinkable.html</filename>
    <member kind="slot">
      <type>void</type>
      <name>blink</name>
      <anchor>i0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Blinkable</name>
      <anchor>a0</anchor>
      <arglist>(QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>nextStep</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>executeBlink</name>
      <anchor>a4</anchor>
      <arglist>(int step)=0</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>startBlink</name>
      <anchor>a5</anchor>
      <arglist>(Blinkable *blinkable, int nbSteps, int stepInterval, int totalDuration)</arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>nbSteps</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>stepInterval</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>totalDuration</name>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>currentStep</name>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>currentDuration</name>
      <anchor>o4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>QTimer *</type>
      <name>timer</name>
      <anchor>o5</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>BPMModifierDropDown</name>
    <filename>classBPMModifierDropDown.html</filename>
    <member kind="signal">
      <type>void</type>
      <name>valueChanged</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BPMModifierDropDown</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getModifier</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>getStringModifier</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>value</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>QPopupMenu *</type>
      <name>dropDownMenu</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>BPMModifierSpinBox</name>
    <filename>classBPMModifierSpinBox.html</filename>
    <member kind="function">
      <type></type>
      <name>BPMModifierSpinBox</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>mapValueToText</name>
      <anchor>a2</anchor>
      <arglist>(int value)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>mapTextToValue</name>
      <anchor>a3</anchor>
      <arglist>(bool *ok)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getModifier</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ControllerCanvas</name>
    <filename>classControllerCanvas.html</filename>
    <member kind="function">
      <type></type>
      <name>ControllerCanvas</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setVisibleWidth</name>
      <anchor>a2</anchor>
      <arglist>(int w)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setStartX</name>
      <anchor>a3</anchor>
      <arglist>(int x)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMaxValue</name>
      <anchor>a4</anchor>
      <arglist>(float v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMinValue</name>
      <anchor>a5</anchor>
      <arglist>(float v)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getStartX</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getVisibleWidth</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>drawBackground</name>
      <anchor>b0</anchor>
      <arglist>(QPainter &amp;painter, const QRect &amp;clip)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>drawCoords</name>
      <anchor>b1</anchor>
      <arglist>(QPainter &amp;p, const QRect &amp;clip)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>visibleWidth</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>startX</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float</type>
      <name>minValue</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float</type>
      <name>maxValue</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>CustomEffect</name>
    <filename>classCustomEffect.html</filename>
    <member kind="function">
      <type></type>
      <name>CustomEffect</name>
      <anchor>a0</anchor>
      <arglist>(QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>process</name>
      <anchor>a2</anchor>
      <arglist>(long length)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>init</name>
      <anchor>a3</anchor>
      <arglist>(long length)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>advancePosition</name>
      <anchor>a4</anchor>
      <arglist>(long length)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setPosition</name>
      <anchor>a5</anchor>
      <arglist>(long position)=0</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>preOrPost</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPre</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPost</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QString</type>
      <name>getName</name>
      <anchor>a9</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>long</type>
      <name>bufferLength</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>preOrPostVal</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>CustomEffects</name>
    <filename>classCustomEffects.html</filename>
    <member kind="function">
      <type></type>
      <name>CustomEffects</name>
      <anchor>a0</anchor>
      <arglist>(QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>processEffects</name>
      <anchor>a2</anchor>
      <arglist>(long length, int preOrPost)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>initEffects</name>
      <anchor>a3</anchor>
      <arglist>(long length)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add</name>
      <anchor>a4</anchor>
      <arglist>(CustomEffect *)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>advancePositions</name>
      <anchor>a5</anchor>
      <arglist>(long length)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPositions</name>
      <anchor>a7</anchor>
      <arglist>(long position)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DisplayEnvelopeWidget</name>
    <filename>classDisplayEnvelopeWidget.html</filename>
    <member kind="slot">
      <type>void</type>
      <name>setEnvData</name>
      <anchor>i0</anchor>
      <arglist>(EnvelopeData *ed)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>envelopeChanged</name>
      <anchor>l0</anchor>
      <arglist>(EnvelopeData *envData)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DisplayEnvelopeWidget</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>drawBezierSegment</name>
      <anchor>a2</anchor>
      <arglist>(QPainter *p, QPoint start, QPoint end, QPoint control)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>drawThickPoint</name>
      <anchor>a3</anchor>
      <arglist>(QPainter *p, QPoint point)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>resizeEvent</name>
      <anchor>b0</anchor>
      <arglist>(QResizeEvent *)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>drawContents</name>
      <anchor>b1</anchor>
      <arglist>(QPainter *)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>mousePressEvent</name>
      <anchor>b2</anchor>
      <arglist>(QMouseEvent *)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>mouseMoveEvent</name>
      <anchor>b3</anchor>
      <arglist>(QMouseEvent *)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>mouseReleaseEvent</name>
      <anchor>b4</anchor>
      <arglist>(QMouseEvent *)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>EnvelopeData *</type>
      <name>envData</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QRect</type>
      <name>attackRect</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QRect</type>
      <name>holdRect</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QRect</type>
      <name>decayRect</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QRect</type>
      <name>sustainRect</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QRect</type>
      <name>releaseRect</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QRect</type>
      <name>attackPRect</name>
      <anchor>p6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QRect</type>
      <name>holdPRect</name>
      <anchor>p7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QRect</type>
      <name>decayPRect</name>
      <anchor>p8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QRect</type>
      <name>sustainPRect</name>
      <anchor>p9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QRect</type>
      <name>releasePRect</name>
      <anchor>p10</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QRect</type>
      <name>attackCRect</name>
      <anchor>p11</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QRect</type>
      <name>holdCRect</name>
      <anchor>p12</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QRect</type>
      <name>decayCRect</name>
      <anchor>p13</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QRect</type>
      <name>sustainCRect</name>
      <anchor>p14</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QRect</type>
      <name>releaseCRect</name>
      <anchor>p15</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DLSManager</name>
    <filename>classDLSManager.html</filename>
    <member kind="function">
      <type></type>
      <name>DLSManager</name>
      <anchor>a0</anchor>
      <arglist>(QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeDLS2File</name>
      <anchor>a2</anchor>
      <arglist>(QString, QStringList *, QValueList&lt; beatline_data &gt; bld)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DrawAllSoundWidget</name>
    <filename>classDrawAllSoundWidget.html</filename>
    <base>DrawSoundWidgetAbstract</base>
    <member kind="slot">
      <type>void</type>
      <name>visibleAreaChanged</name>
      <anchor>i0</anchor>
      <arglist>(long, long)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>fileLoaded</name>
      <anchor>i1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>contentsMouseMoveEvent</name>
      <anchor>i2</anchor>
      <arglist>(QMouseEvent *mouseEvent)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>contentsMousePressEvent</name>
      <anchor>i3</anchor>
      <arglist>(QMouseEvent *mouseEvent)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>contentsMouseReleaseEvent</name>
      <anchor>i4</anchor>
      <arglist>(QMouseEvent *mouseEvent)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>cropped</name>
      <anchor>i5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>visibleAreaChangedS</name>
      <anchor>l0</anchor>
      <arglist>(long, long)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DrawAllSoundWidget</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent, const char *name, SoundManager *)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>zoomChanged</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>resized</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SelectionRectangle *</type>
      <name>getViewWindow</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>zoomAll</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>minimumWidth</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QSize</type>
      <name>sizeHint</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>savedRelativeSamplePos</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DrawingLine</name>
    <filename>classDrawingLine.html</filename>
    <member kind="function">
      <type></type>
      <name>DrawingLine</name>
      <anchor>a0</anchor>
      <arglist>(QCanvas *)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setStartPoint</name>
      <anchor>a2</anchor>
      <arglist>(int, int)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setEndPoint</name>
      <anchor>a3</anchor>
      <arglist>(int, int)</arglist>
    </member>
    <member kind="function">
      <type>QPoint</type>
      <name>getStartPoint</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QPoint</type>
      <name>getEndPoint</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QPointArray</type>
      <name>areaPoints</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QRect</type>
      <name>boundingRect</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>rtti</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getYAtX</name>
      <anchor>a9</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setEndSample</name>
      <anchor>a10</anchor>
      <arglist>(long e)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setStartSample</name>
      <anchor>a11</anchor>
      <arglist>(long s)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getValueAtSample</name>
      <anchor>a12</anchor>
      <arglist>(long sample)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setEndValue</name>
      <anchor>a13</anchor>
      <arglist>(float ev)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setStartValue</name>
      <anchor>a14</anchor>
      <arglist>(float sv)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>drawShape</name>
      <anchor>b0</anchor>
      <arglist>(QPainter &amp;p)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>long</type>
      <name>end_sample</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>long</type>
      <name>start_sample</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float</type>
      <name>startValue</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float</type>
      <name>endValue</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DrawSoundWidget</name>
    <filename>classDrawSoundWidget.html</filename>
    <base>DrawSoundWidgetAbstract</base>
    <member kind="slot">
      <type>void</type>
      <name>computeNewBPMLines</name>
      <anchor>i0</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>resample</name>
      <anchor>i1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>unlockBeatLines</name>
      <anchor>i2</anchor>
      <arglist>(bool force=FALSE)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>lockBeatLines</name>
      <anchor>i3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setBPMLines</name>
      <anchor>i4</anchor>
      <arglist>(bool on)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>removeBPMLines</name>
      <anchor>i5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>removeSelectionRectangles</name>
      <anchor>i6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>removeBeatLines</name>
      <anchor>i7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>contentsMoved</name>
      <anchor>i8</anchor>
      <arglist>(int, int)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>reinitCanvas</name>
      <anchor>i9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setBeatLines</name>
      <anchor>i10</anchor>
      <arglist>(QMemArray&lt; long &gt;)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>analysisFinished</name>
      <anchor>i11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setPositionPointer</name>
      <anchor>i12</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>addBeatLine</name>
      <anchor>i13</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>addLockedBeatLine</name>
      <anchor>i14</anchor>
      <arglist>(long beat, int midiNote=-1)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>cropped</name>
      <anchor>i15</anchor>
      <arglist>(long, long)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>showBeatLines</name>
      <anchor>i16</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>scroll</name>
      <anchor>i17</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>updateLockedBeatRects</name>
      <anchor>i18</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>initLockedBeatLines</name>
      <anchor>i19</anchor>
      <arglist>(QValueList&lt; beatline_data &gt; lbl)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>assignToScene</name>
      <anchor>i20</anchor>
      <arglist>(int sc)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>bpmChange</name>
      <anchor>l0</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>visibleAreaChanged</name>
      <anchor>l1</anchor>
      <arglist>(long, long)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>zoomChangedS</name>
      <anchor>l2</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>playFromPoint</name>
      <anchor>l3</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>playFromTo</name>
      <anchor>l4</anchor>
      <arglist>(long, long)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>stopPlay</name>
      <anchor>l5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>loopChange</name>
      <anchor>l6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>hasLockedBeatLines</name>
      <anchor>l7</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>receivedWave</name>
      <anchor>l8</anchor>
      <arglist>(QPoint, QString)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>beatLinesChanged</name>
      <anchor>l9</anchor>
      <arglist>(QValueList&lt; beatline_data &gt; beatLines)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>lockedBeatLinesChanged</name>
      <anchor>l10</anchor>
      <arglist>(QValueList&lt; beatline_data &gt; beatLines)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>midiAssChanged</name>
      <anchor>l11</anchor>
      <arglist>(QValueList&lt; beatline_data &gt; bld)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DrawSoundWidget</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent, const char *name, SoundManager *sm)</arglist>
    </member>
    <member kind="function">
      <type>PlayLine *</type>
      <name>getPositionPointerCI</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fileLoaded</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>updateBeatLines</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>updateNewBeatLines</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTreshold</name>
      <anchor>a6</anchor>
      <arglist>(int, bool)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setWindowDivider</name>
      <anchor>a7</anchor>
      <arglist>(int, bool)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>computeBPM</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>computeBPM2</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>updateSelectionRectangles</name>
      <anchor>a10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>updateVerticalSelectionRectangles</name>
      <anchor>a11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>updateLoopMarkers</name>
      <anchor>a12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>zoomToSel</name>
      <anchor>a13</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>zoomAll</name>
      <anchor>a14</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>resized</name>
      <anchor>a15</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getNearestLinePos</name>
      <anchor>a16</anchor>
      <arglist>(QPoint, long &amp;sample_pos, int &amp;x)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>getSelectionStartSample</name>
      <anchor>a17</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>getSelectionEndSample</name>
      <anchor>a18</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getNbLockedBeats</name>
      <anchor>a19</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getBeats</name>
      <anchor>a20</anchor>
      <arglist>(long[])</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getLockedBeats</name>
      <anchor>a21</anchor>
      <arglist>(long[])</arglist>
    </member>
    <member kind="function">
      <type>QValueList&lt; int &gt;</type>
      <name>getLockedMidiNotes</name>
      <anchor>a22</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getNbBeats</name>
      <anchor>a23</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>customEvent</name>
      <anchor>a24</anchor>
      <arglist>(QCustomEvent *)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>getComputedBPM</name>
      <anchor>a25</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>getUsedBPM</name>
      <anchor>a26</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasLoopSet</name>
      <anchor>a27</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>getLeftLoopMarkerSample</name>
      <anchor>a28</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>getRightLoopMarkerSample</name>
      <anchor>a29</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swapMarkers</name>
      <anchor>a30</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>findLeftBeatlinePos</name>
      <anchor>a31</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>findRightBeatlinePos</name>
      <anchor>a32</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>findNearestBeatlinePos</name>
      <anchor>a33</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLoopMarkersOnMeasure</name>
      <anchor>a34</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getBeatDistance</name>
      <anchor>a35</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setComputedBPMModifier</name>
      <anchor>a36</anchor>
      <arglist>(double)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>handleMouseMoveSelectionRectangles</name>
      <anchor>a37</anchor>
      <arglist>(QMouseEvent *me)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>computePosFromMouse</name>
      <anchor>a38</anchor>
      <arglist>(QMouseEvent *me, int &amp;pos_x, long &amp;sample_pos)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>handleMouseMoveVerticalSelectionRectangles</name>
      <anchor>a39</anchor>
      <arglist>(QMouseEvent *mouseEvent)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>handleMouseMoveLoopMarkers</name>
      <anchor>a40</anchor>
      <arglist>(QMouseEvent *mouseEvent)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>handleMouseMoveBeatRect</name>
      <anchor>a41</anchor>
      <arglist>(QMouseEvent *mouseEvent)</arglist>
    </member>
    <member kind="function">
      <type>BeatLine *</type>
      <name>getMovableBeatLine</name>
      <anchor>a42</anchor>
      <arglist>(QPoint pos)</arglist>
    </member>
    <member kind="function">
      <type>BeatLine *</type>
      <name>getLockableBeatLine</name>
      <anchor>a43</anchor>
      <arglist>(QPoint pos)</arglist>
    </member>
    <member kind="function">
      <type>BeatLine *</type>
      <name>getRemovableBeatLine</name>
      <anchor>a44</anchor>
      <arglist>(QPoint pos)</arglist>
    </member>
    <member kind="function">
      <type>BeatLine *</type>
      <name>getMovingBeatLine</name>
      <anchor>a45</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>BeatLine *</type>
      <name>getAssignableBeatLine</name>
      <anchor>a46</anchor>
      <arglist>(QPoint pos)</arglist>
    </member>
    <member kind="function">
      <type>LockedBeatRect *</type>
      <name>getMovableBeatRect</name>
      <anchor>a47</anchor>
      <arglist>(QPoint pos)</arglist>
    </member>
    <member kind="function">
      <type>LockedBeatRect *</type>
      <name>getMovingBeatRect</name>
      <anchor>a48</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>handleMouseMoveBeatLine</name>
      <anchor>a49</anchor>
      <arglist>(QMouseEvent *mouseEvent)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>checkAndScroll</name>
      <anchor>a50</anchor>
      <arglist>(QMouseEvent *ev)</arglist>
    </member>
    <member kind="function">
      <type>QValueList&lt; long &gt;</type>
      <name>toArray</name>
      <anchor>a51</anchor>
      <arglist>(QPtrList&lt; BeatLine &gt; beatlines)</arglist>
    </member>
    <member kind="function">
      <type>BeatLine *</type>
      <name>findNextLockedBeatLine</name>
      <anchor>a52</anchor>
      <arglist>(BeatLine *bl)</arglist>
    </member>
    <member kind="function">
      <type>QValueList&lt; beatline_data &gt;</type>
      <name>getLockedBeatList</name>
      <anchor>a53</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>LoopMarker *</type>
      <name>getLeftLoopMarker</name>
      <anchor>a54</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>LoopMarker *</type>
      <name>getRightLoopMarker</name>
      <anchor>a55</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QValueList&lt; long &gt;</type>
      <name>getBeatList</name>
      <anchor>a56</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QValueList&lt; beatline_data &gt;</type>
      <name>toData</name>
      <anchor>a57</anchor>
      <arglist>(QPtrList&lt; BeatLine &gt;)</arglist>
    </member>
    <member kind="function">
      <type>QValueList&lt; beatline_data &gt;</type>
      <name>selectLockedBeatlinesList</name>
      <anchor>a58</anchor>
      <arglist>(long start, long end)</arglist>
    </member>
    <member kind="function">
      <type>QValueList&lt; beatline_data &gt;</type>
      <name>assignMissingMidi</name>
      <anchor>a59</anchor>
      <arglist>(QValueList&lt; beatline_data &gt;)</arglist>
    </member>
    <member kind="function">
      <type>BeatLine *</type>
      <name>findLeftLockedBeatLine</name>
      <anchor>a60</anchor>
      <arglist>(long pos)</arglist>
    </member>
    <member kind="function">
      <type>BeatLine *</type>
      <name>findRightLockedBeatLine</name>
      <anchor>a61</anchor>
      <arglist>(long pos)</arglist>
    </member>
    <member kind="function">
      <type>LockedBeatRectList</type>
      <name>getLockedBeatRects</name>
      <anchor>a62</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>LockedBeatRect *</type>
      <name>getLockedBeatRectFromTo</name>
      <anchor>a63</anchor>
      <arglist>(long start, long end)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>canUnlock</name>
      <anchor>a64</anchor>
      <arglist>(BeatLine *bl)</arglist>
    </member>
    <member kind="function">
      <type>LockedBeatRect *</type>
      <name>getLockedBeatRectFrom</name>
      <anchor>a65</anchor>
      <arglist>(long left)</arglist>
    </member>
    <member kind="function">
      <type>LockedBeatRect *</type>
      <name>getLockedBeatRectTo</name>
      <anchor>a66</anchor>
      <arglist>(long right)</arglist>
    </member>
    <member kind="variable">
      <type>KeyboardView *</type>
      <name>keyboardView</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="slot" protection="protected">
      <type>void</type>
      <name>sceneSwitched</name>
      <anchor>j0</anchor>
      <arglist>(int sc)</arglist>
    </member>
    <member kind="slot" protection="protected">
      <type>void</type>
      <name>addStackElement</name>
      <anchor>j1</anchor>
      <arglist>(long start, long end, QString filename, long index, int scene, bool current)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>contentsMousePressEvent</name>
      <anchor>b0</anchor>
      <arglist>(QMouseEvent *)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>contentsMouseReleaseEvent</name>
      <anchor>b1</anchor>
      <arglist>(QMouseEvent *)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>contentsMouseMoveEvent</name>
      <anchor>b2</anchor>
      <arglist>(QMouseEvent *)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>contentsDragEnterEvent</name>
      <anchor>b3</anchor>
      <arglist>(QDragEnterEvent *event)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>contentsDragMoveEvent</name>
      <anchor>b4</anchor>
      <arglist>(QDragMoveEvent *event)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>contentsDragLeaveEvent</name>
      <anchor>b5</anchor>
      <arglist>(QDragLeaveEvent *)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>contentsDropEvent</name>
      <anchor>b6</anchor>
      <arglist>(QDropEvent *event)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>midiNoteReceived</name>
      <anchor>b7</anchor>
      <arglist>(int onnoff, int key, int velocity)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>acceptDrop</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>PlayLine *</type>
      <name>playline</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>long</type>
      <name>playPosition</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QMutex</type>
      <name>mutex</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>BeatLineList</type>
      <name>beatLines</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>BeatLineList</type>
      <name>lockedBeatLines</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>BeatLineList</type>
      <name>newBeatLines</name>
      <anchor>p6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>LockedBeatRectList</type>
      <name>lockedBeatRects</name>
      <anchor>p7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SelectionRectangle *</type>
      <name>selection</name>
      <anchor>p8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QPtrList&lt; VerticalSelectionRectangle &gt;</type>
      <name>verticalSelections</name>
      <anchor>p9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>LoopMarker *</type>
      <name>loopMarkerL</name>
      <anchor>p10</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>LoopMarker *</type>
      <name>loopMarkerR</name>
      <anchor>p11</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>MeasureMarker *</type>
      <name>measureMarker</name>
      <anchor>p12</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>double</type>
      <name>computed_bpm</name>
      <anchor>p13</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>double</type>
      <name>new_to_oldBPM_ratio</name>
      <anchor>p14</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>windowDivider</name>
      <anchor>p15</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>double</type>
      <name>treshold</name>
      <anchor>p16</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QPtrList&lt; BeatLine &gt;</type>
      <name>bpmLines</name>
      <anchor>p17</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>showBeatLinesVal</name>
      <anchor>p18</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float</type>
      <name>computedBPMModifier</name>
      <anchor>p19</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SampleValueView *</type>
      <name>sampleValueView</name>
      <anchor>p20</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QTimer *</type>
      <name>scrollTimer</name>
      <anchor>p21</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>ShowInsertAtRect *</type>
      <name>showInsertAtRect</name>
      <anchor>p22</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DrawSoundWidgetAbstract</name>
    <filename>classDrawSoundWidgetAbstract.html</filename>
    <member kind="slot">
      <type>void</type>
      <name>forceRepaint</name>
      <anchor>i0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>forceRepaint</name>
      <anchor>i1</anchor>
      <arglist>(long, long)</arglist>
    </member>
    <member kind="slot">
      <type>long</type>
      <name>zoomToSamplePos</name>
      <anchor>i2</anchor>
      <arglist>(long, long)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>zapWaveCanvasBuffers</name>
      <anchor>i3</anchor>
      <arglist>(bool repaint=TRUE)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>zapWaveCanvasBuffers</name>
      <anchor>i4</anchor>
      <arglist>(long start, long end)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DrawSoundWidgetAbstract</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent, const char *name, SoundManager *)</arglist>
    </member>
    <member kind="function">
      <type>WaveCanvas *</type>
      <name>getCanvas</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>getZoomRatio</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setZoomRatio</name>
      <anchor>a4</anchor>
      <arglist>(long zr, bool repaint=TRUE)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>getFirstVisibleSample</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>getLastVisibleSample</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>checkSamplePosition</name>
      <anchor>a7</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>getCenterViewSample</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>getFirstVisibleSampleAfterZoom</name>
      <anchor>a9</anchor>
      <arglist>(long zoomRatio)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>getLastVisibleSampleAfterZoom</name>
      <anchor>a10</anchor>
      <arglist>(long zoomRatio)</arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>updateCanvas</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" protection="protected" virtualness="pure">
      <type>virtual void</type>
      <name>zoomChanged</name>
      <anchor>b0</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="pure">
      <type>virtual void</type>
      <name>resized</name>
      <anchor>b1</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>resizeEvent</name>
      <anchor>b2</anchor>
      <arglist>(QResizeEvent *)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>WaveCanvas *</type>
      <name>canvas</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SoundManager *</type>
      <name>soundManager</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QSize</type>
      <name>contentsSize</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>long</type>
      <name>oldVisibleSize</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>EffectFrame</name>
    <filename>classEffectFrame.html</filename>
    <member kind="slot">
      <type>void</type>
      <name>apply</name>
      <anchor>i0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>apply</name>
      <anchor>i1</anchor>
      <arglist>(long, long)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>show</name>
      <anchor>i2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setZoomRatio</name>
      <anchor>i3</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>visibleAreaChanged</name>
      <anchor>i4</anchor>
      <arglist>(long, long)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setContentsPos</name>
      <anchor>i5</anchor>
      <arglist>(int, int)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>switchOnReleaseApplyPolicy</name>
      <anchor>i6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>switchOnChangeApplyPolicy</name>
      <anchor>i7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>changeDrawMode</name>
      <anchor>i8</anchor>
      <arglist>(EffectPortFrame::DrawMode dm)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>lockedBeatLinesChanged</name>
      <anchor>i9</anchor>
      <arglist>(QValueList&lt; beatline_data &gt;)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>beatLinesChanged</name>
      <anchor>i10</anchor>
      <arglist>(QValueList&lt; beatline_data &gt;)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setSplineData</name>
      <anchor>i11</anchor>
      <arglist>(int port_no, QValueList&lt; SplinePoint &gt;)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setPolylineData</name>
      <anchor>i12</anchor>
      <arglist>(int port_no, QValueList&lt; SortablePoint &gt;)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>reinitLADSPAValues</name>
      <anchor>i13</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>applyMe</name>
      <anchor>l0</anchor>
      <arglist>(LADSPAEffect *)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>applyMe</name>
      <anchor>l1</anchor>
      <arglist>(LADSPAEffect *, long, long)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>lockedBeatLinesChangedS</name>
      <anchor>l2</anchor>
      <arglist>(QValueList&lt; beatline_data &gt;)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>beatLinesChangedS</name>
      <anchor>l3</anchor>
      <arglist>(QValueList&lt; beatline_data &gt;)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>zoomRatioChangedS</name>
      <anchor>l4</anchor>
      <arglist>(long _zr)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>applyPolicyChanged</name>
      <anchor>l5</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>cropS</name>
      <anchor>l6</anchor>
      <arglist>(long, long)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>EffectFrame</name>
      <anchor>a0</anchor>
      <arglist>(LADSPAEffect *, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setApplyPolicy</name>
      <anchor>a2</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reinit</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QSize</type>
      <name>sizeHint</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>LADSPAEffect *</type>
      <name>getLadspa</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>EffectPortFrame *</type>
      <name>getPortFrame</name>
      <anchor>a6</anchor>
      <arglist>(int portNo)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>updateDrawModeButton</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>closeEvent</name>
      <anchor>b0</anchor>
      <arglist>(QCloseEvent *)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>EffectPortFrame</name>
    <filename>classEffectPortFrame.html</filename>
    <member kind="slot">
      <type>void</type>
      <name>setZoomRatio</name>
      <anchor>i0</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>raiseMe</name>
      <anchor>i1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setApplyPolicy</name>
      <anchor>i2</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>pointsToggled</name>
      <anchor>i3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>linesToggled</name>
      <anchor>i4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>polylinesToggled</name>
      <anchor>i5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>splinesToggled</name>
      <anchor>i6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>beatLinesChanged</name>
      <anchor>i7</anchor>
      <arglist>(QValueList&lt; beatline_data &gt; beatlines)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>lockedBeatLinesChanged</name>
      <anchor>i8</anchor>
      <arglist>(QValueList&lt; beatline_data &gt; beatlines)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>reinitLADSPAValues</name>
      <anchor>i9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>contentsMoved</name>
      <anchor>i10</anchor>
      <arglist>(int x, int y)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>crop</name>
      <anchor>i11</anchor>
      <arglist>(long start, long end)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>valueChanged</name>
      <anchor>l0</anchor>
      <arglist>(long, long)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>drawModeChanged</name>
      <anchor>l1</anchor>
      <arglist>(EffectPortFrame::DrawMode dm)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>EffectPortFrame</name>
      <anchor>a0</anchor>
      <arglist>(QString, LADSPAPort *, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>getZoomRatio</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ControllerCanvas *</type>
      <name>getCanvas</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QSize</type>
      <name>minimumSizeHint</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DrawMode</type>
      <name>getDrawMode</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>drawBeatlines</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeBeatlines</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getPortNumber</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasPolyline</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasSpline</name>
      <anchor>a10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>PolyLine *</type>
      <name>getPolyline</name>
      <anchor>a11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SplineLine *</type>
      <name>getSpline</name>
      <anchor>a12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPolylineData</name>
      <anchor>a13</anchor>
      <arglist>(QValueList&lt; SortablePoint &gt;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSplineData</name>
      <anchor>a14</anchor>
      <arglist>(QValueList&lt; SplinePoint &gt;)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>valToYPos</name>
      <anchor>a15</anchor>
      <arglist>(float val)</arglist>
    </member>
    <member kind="variable">
      <type>DrawMode</type>
      <name>drawMode</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>contentsMousePressEvent</name>
      <anchor>b0</anchor>
      <arglist>(QMouseEvent *)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>contentsMouseMoveEvent</name>
      <anchor>b1</anchor>
      <arglist>(QMouseEvent *)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>contentsMouseReleaseEvent</name>
      <anchor>b2</anchor>
      <arglist>(QMouseEvent *)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>contentsWheelEvent</name>
      <anchor>b3</anchor>
      <arglist>(QWheelEvent *)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>interval</type>
      <name>updateValueAtPos</name>
      <anchor>b4</anchor>
      <arglist>(QPoint, bool, bool)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>getNearestLinePos</name>
      <anchor>b5</anchor>
      <arglist>(QPoint pos, long &amp;sample_pos, int &amp;x)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>resizeEvent</name>
      <anchor>b6</anchor>
      <arglist>(QResizeEvent *)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>closeEvent</name>
      <anchor>b7</anchor>
      <arglist>(QCloseEvent *)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>float</type>
      <name>yPosToVal</name>
      <anchor>b8</anchor>
      <arglist>(int y)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>ControllerCanvas *</type>
      <name>canvas</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>c_height</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>long</type>
      <name>zoomRatio</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>linesCreated</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>DrawingLine *</type>
      <name>drawingLine</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>PolyLine *</type>
      <name>polyLine</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SplineLine *</type>
      <name>spline</name>
      <anchor>p6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QValueList&lt; beatline_data &gt;</type>
      <name>beatlines</name>
      <anchor>p7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QValueList&lt; beatline_data &gt;</type>
      <name>lockedBeatlines</name>
      <anchor>p8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>LADSPAValueView *</type>
      <name>ladspaValueView</name>
      <anchor>p9</anchor>
      <arglist></arglist>
    </member>
    <class kind="struct">EffectPortFrame::interval</class>
  </compound>
  <compound kind="class">
    <name>Envelope</name>
    <filename>classEnvelope.html</filename>
    <base>CustomEffect</base>
    <member kind="function">
      <type></type>
      <name>Envelope</name>
      <anchor>a0</anchor>
      <arglist>(QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>advancePosition</name>
      <anchor>a2</anchor>
      <arglist>(long length)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchor>a3</anchor>
      <arglist>(long length)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>process</name>
      <anchor>a4</anchor>
      <arglist>(long length)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPosition</name>
      <anchor>a5</anchor>
      <arglist>(long position)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setInputP</name>
      <anchor>a6</anchor>
      <arglist>(float *)</arglist>
    </member>
    <member kind="function">
      <type>float *</type>
      <name>getOutputP</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setEnvDurationAndSamplerate</name>
      <anchor>a8</anchor>
      <arglist>(long _duration, int _samplerate=44100)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>getName</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getEnvelopeValueAt</name>
      <anchor>a10</anchor>
      <arglist>(long i)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>long</type>
      <name>length</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>duration</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float *</type>
      <name>inputP</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float *</type>
      <name>outputP</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>samplerate</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>EnvelopeControllerWidget</name>
    <filename>classEnvelopeControllerWidget.html</filename>
    <member kind="slot">
      <type>void</type>
      <name>setData</name>
      <anchor>i0</anchor>
      <arglist>(QString envData)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setEndFrame</name>
      <anchor>i1</anchor>
      <arglist>(long ef)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setStartFrame</name>
      <anchor>i2</anchor>
      <arglist>(long sf)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>durationChanged</name>
      <anchor>i3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>resolutionChanged</name>
      <anchor>i4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>endModeChanged</name>
      <anchor>i5</anchor>
      <arglist>(int btn)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>onoffChanged</name>
      <anchor>i6</anchor>
      <arglist>(bool on)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>envDataChanged</name>
      <anchor>i7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>envelopeChanged</name>
      <anchor>l0</anchor>
      <arglist>(EnvelopeData *envData)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>EnvelopeControllerWidget</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setInHolder</name>
      <anchor>a2</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>getEndFrame</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>getStartFrame</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>EnvelopeData *</type>
      <name>getEnvData</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>DisplayEnvelopeWidget *</type>
      <name>displayEnvelope</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>PotentiometerWidget *</type>
      <name>envDurationWidget</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>PotentiometerWidget *</type>
      <name>envResolutionWidget</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>EnvelopeData *</type>
      <name>envData</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QPushButton *</type>
      <name>onoff</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QButtonGroup *</type>
      <name>optionsBG</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>inHolder</name>
      <anchor>p6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>long</type>
      <name>start_frame</name>
      <anchor>p7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>long</type>
      <name>end_frame</name>
      <anchor>p8</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>EnvelopeData</name>
    <filename>classEnvelopeData.html</filename>
    <member kind="function">
      <type></type>
      <name>EnvelopeData</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;text, QWidget *dragSource=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>EnvelopeData</name>
      <anchor>a1</anchor>
      <arglist>(QWidget *dragSource=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>toString</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getEnvAt</name>
      <anchor>a4</anchor>
      <arglist>(float x, float dt)</arglist>
    </member>
    <member kind="function">
      <type>mode</type>
      <name>getMode</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getDuration</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setData</name>
      <anchor>a7</anchor>
      <arglist>(QString envDataS)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setReleaseCy</name>
      <anchor>a8</anchor>
      <arglist>(float ry)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAttack</name>
      <anchor>a9</anchor>
      <arglist>(float a)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAttackCx</name>
      <anchor>a10</anchor>
      <arglist>(float ax)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAttackCy</name>
      <anchor>a11</anchor>
      <arglist>(float ay)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDecay</name>
      <anchor>a12</anchor>
      <arglist>(float a)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDecayCx</name>
      <anchor>a13</anchor>
      <arglist>(float dx)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDecayCy</name>
      <anchor>a14</anchor>
      <arglist>(float dy)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHold</name>
      <anchor>a15</anchor>
      <arglist>(float a)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRelease</name>
      <anchor>a16</anchor>
      <arglist>(float a)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setReleaseCx</name>
      <anchor>a17</anchor>
      <arglist>(float rx)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSustain</name>
      <anchor>a18</anchor>
      <arglist>(float a)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>isEnabled</name>
      <anchor>a19</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setEnabled</name>
      <anchor>a20</anchor>
      <arglist>(int e)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>getData</name>
      <anchor>a21</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getResolution</name>
      <anchor>a22</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable">
      <type>float</type>
      <name>attack</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>float</type>
      <name>release</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>float</type>
      <name>decay</name>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>float</type>
      <name>hold</name>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>float</type>
      <name>sustain</name>
      <anchor>o4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>float</type>
      <name>env_duration</name>
      <anchor>o5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>float</type>
      <name>env_resolution</name>
      <anchor>o6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>mode</type>
      <name>env_mode</name>
      <anchor>o7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>MyMath::FPoint2D</type>
      <name>attackC</name>
      <anchor>o8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>MyMath::FPoint2D</type>
      <name>decayC</name>
      <anchor>o9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>MyMath::FPoint2D</type>
      <name>releaseC</name>
      <anchor>o10</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>enabled</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>FFTHolder</name>
    <filename>classFFTHolder.html</filename>
    <member kind="function">
      <type>int</type>
      <name>getHiresFreqNbBands</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getHiresTempNbBands</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getHiresFreqFFTMinima</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getHiresFreqFFTMaxima</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getHiresFreqFFTWidth</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getHiresTempFFTWidth</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getHiresFreqFFTAdvance</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getHiresTempFFTAdvance</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getHiresFreqStartFreq</name>
      <anchor>a10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getHiresFreqEndFreq</name>
      <anchor>a11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float **</type>
      <name>hirestemp_subband_energies</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float **</type>
      <name>hiresfreq_subband_energies</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>hiresfreq_nbbands</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>hiresfreq_fft_width</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>hiresfreq_fft_window_size</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>hiresfreq_fft_advance</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float</type>
      <name>hiresfreq_fftMaxima</name>
      <anchor>p6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float</type>
      <name>hiresfreq_fftMinima</name>
      <anchor>p7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>hiresfreq_padding</name>
      <anchor>p8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>hiresfreq_startfreq</name>
      <anchor>p9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>hiresfreq_endfreq</name>
      <anchor>p10</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>hirestemp_nbbands</name>
      <anchor>p11</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>hirestemp_fft_width</name>
      <anchor>p12</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>hirestemp_fft_window_size</name>
      <anchor>p13</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>hirestemp_fft_advance</name>
      <anchor>p14</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float</type>
      <name>hirestemp_fftMaxima</name>
      <anchor>p15</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float</type>
      <name>hirestemp_fftMinima</name>
      <anchor>p16</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>hirestemp_padding</name>
      <anchor>p17</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>hirestemp_startfreq</name>
      <anchor>p18</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>hirestemp_endfreq</name>
      <anchor>p19</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>FileManager</name>
    <filename>classFileManager.html</filename>
    <member kind="function">
      <type></type>
      <name>FileManager</name>
      <anchor>a0</anchor>
      <arglist>(QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFilename</name>
      <anchor>a2</anchor>
      <arglist>(QString)</arglist>
    </member>
    <member kind="function">
      <type>const QString</type>
      <name>getFilename</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const QString</type>
      <name>getNextFilename</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const QString</type>
      <name>getPreviousFilename</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const QString</type>
      <name>getOriginalFilename</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasPrevious</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasNext</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>deleteAfterCurrent</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>purgeTempDir</name>
      <anchor>a10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>getTempDir</name>
      <anchor>a11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>getFilenameExtension</name>
      <anchor>a12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>purgeDir</name>
      <anchor>e0</anchor>
      <arglist>(QString dir)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>deleteDir</name>
      <anchor>e1</anchor>
      <arglist>(QString dir)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QString</type>
      <name>filename</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>FloatSpinBox</name>
    <filename>classFloatSpinBox.html</filename>
    <member kind="function">
      <type></type>
      <name>FloatSpinBox</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>mapValueToText</name>
      <anchor>a1</anchor>
      <arglist>(int value)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>mapTextToValue</name>
      <anchor>a2</anchor>
      <arglist>(bool *ok)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GigaManager</name>
    <filename>classGigaManager.html</filename>
    <member kind="function">
      <type></type>
      <name>GigaManager</name>
      <anchor>a0</anchor>
      <arglist>(QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeGigaFile</name>
      <anchor>a2</anchor>
      <arglist>(QString, QStringList *, QValueList&lt; beatline_data &gt; bld)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>HelpManager</name>
    <filename>classHelpManager.html</filename>
    <member kind="slot">
      <type>void</type>
      <name>open</name>
      <anchor>i0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HelpManager</name>
      <anchor>a0</anchor>
      <arglist>(QString root_temp_dir, QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasHelp</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>uncompress</name>
      <anchor>a3</anchor>
      <arglist>(QString help_file)</arglist>
    </member>
    <member kind="variable">
      <type>QString</type>
      <name>rootHelpDir</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>QAssistantClient *</type>
      <name>helpClient</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>InputZero</name>
    <filename>classInputZero.html</filename>
    <base>CustomEffect</base>
    <member kind="function">
      <type></type>
      <name>InputZero</name>
      <anchor>a0</anchor>
      <arglist>(QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>advancePosition</name>
      <anchor>a2</anchor>
      <arglist>(long length)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>init</name>
      <anchor>a3</anchor>
      <arglist>(long length)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>process</name>
      <anchor>a4</anchor>
      <arglist>(long length)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setPosition</name>
      <anchor>a5</anchor>
      <arglist>(long position)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>getName</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>float *</type>
      <name>getOutput_P</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float *</type>
      <name>output</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KeyboardView</name>
    <filename>classKeyboardView.html</filename>
    <member kind="typedef">
      <type>QValueList&lt; Key &gt;</type>
      <name>KeyList</name>
      <anchor>w0</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KeyboardView</name>
      <anchor>a0</anchor>
      <arglist>(QCanvas *canvas)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setY</name>
      <anchor>a2</anchor>
      <arglist>(double y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setX</name>
      <anchor>a3</anchor>
      <arglist>(double x)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>rtti</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>initKeys</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mouseReleaseEvent</name>
      <anchor>a6</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mousePressEvent</name>
      <anchor>a7</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>bake</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setVisible</name>
      <anchor>a9</anchor>
      <arglist>(bool yes)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBeatlinePos</name>
      <anchor>a10</anchor>
      <arglist>(const long &amp;theValue)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>getBeatlinePos</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getMidiNoteFor</name>
      <anchor>a12</anchor>
      <arglist>(long samplepos)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setKeys</name>
      <anchor>a13</anchor>
      <arglist>(KeyList theValue)</arglist>
    </member>
    <member kind="function">
      <type>KeyList</type>
      <name>getKeys</name>
      <anchor>a14</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>showMidiKey</name>
      <anchor>a15</anchor>
      <arglist>(int onoff, int key, int velocity)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>getSamplePosFor</name>
      <anchor>a16</anchor>
      <arglist>(int midiNote)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>initKeys</name>
      <anchor>a17</anchor>
      <arglist>(QValueList&lt; beatline_data &gt;)</arglist>
    </member>
    <member kind="function">
      <type>Key *</type>
      <name>getKey</name>
      <anchor>a18</anchor>
      <arglist>(int midiNote)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>transposeAll</name>
      <anchor>a19</anchor>
      <arglist>(int amountNotes)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>assignMissingMidiAll</name>
      <anchor>a20</anchor>
      <arglist>(int start_note)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>assignMissingMidiLoop</name>
      <anchor>a21</anchor>
      <arglist>(int start_note)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getCurrentKey</name>
      <anchor>a22</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLoop</name>
      <anchor>a23</anchor>
      <arglist>(long l, long r)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBeatlineData</name>
      <anchor>a24</anchor>
      <arglist>(QValueList&lt; beatline_data &gt; bld)</arglist>
    </member>
    <member kind="function">
      <type>Key *</type>
      <name>getNextFreeKey</name>
      <anchor>a25</anchor>
      <arglist>(int note)</arglist>
    </member>
    <member kind="variable">
      <type>arrow_pressed_t</type>
      <name>arrowPressed</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>invisibleMidi</type>
      <name>invMidi</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>drawShape</name>
      <anchor>b0</anchor>
      <arglist>(QPainter &amp;p)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>octaveheight</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>octavewidth</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>visibleNbOctaves</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>blackWidth</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>whiteWidth</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>blackHeight</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>KeyList</type>
      <name>keys</name>
      <anchor>p6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>long</type>
      <name>beatlinePos</name>
      <anchor>p7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>arrowWidth</name>
      <anchor>p8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>currentOctave</name>
      <anchor>p9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>maxNbOctaves</name>
      <anchor>p10</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>headerHeight</name>
      <anchor>p11</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QRect</type>
      <name>noteDownR</name>
      <anchor>p12</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QRect</type>
      <name>noteUpR</name>
      <anchor>p13</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QRect</type>
      <name>octaveDownR</name>
      <anchor>p14</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QRect</type>
      <name>octaveUpR</name>
      <anchor>p15</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>transposeKeyClicked_t</type>
      <name>transposeKeyClicked</name>
      <anchor>p16</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>aaKeyClicked_t</type>
      <name>aaKeyClicked</name>
      <anchor>p17</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QRect</type>
      <name>aaMidiAllR</name>
      <anchor>p18</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QRect</type>
      <name>aaMidiLoopR</name>
      <anchor>p19</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QRect</type>
      <name>clearMidiR</name>
      <anchor>p20</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>long</type>
      <name>rightLoop</name>
      <anchor>p21</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>long</type>
      <name>leftLoop</name>
      <anchor>p22</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QValueList&lt; beatline_data &gt;</type>
      <name>beatlineData</name>
      <anchor>p23</anchor>
      <arglist></arglist>
    </member>
    <class kind="struct">KeyboardView::Key</class>
  </compound>
  <compound kind="class">
    <name>KeyPressGlobalEventFilter</name>
    <filename>classKeyPressGlobalEventFilter.html</filename>
    <member kind="function">
      <type></type>
      <name>KeyPressGlobalEventFilter</name>
      <anchor>a0</anchor>
      <arglist>(QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>eventFilter</name>
      <anchor>a2</anchor>
      <arglist>(QObject *o, QEvent *e)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>LADSPADialog</name>
    <filename>classLADSPADialog.html</filename>
    <member kind="slot">
      <type>void</type>
      <name>accept</name>
      <anchor>i0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>currentChanged_</name>
      <anchor>i1</anchor>
      <arglist>(int, int)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>headerClicked</name>
      <anchor>i2</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>stateChanged</name>
      <anchor>i3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>addEffect</name>
      <anchor>l0</anchor>
      <arglist>(int id)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LADSPADialog</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setEffectsList</name>
      <anchor>a2</anchor>
      <arglist>(LADSPAEffects *)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>checkPortAssignments</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>exec</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>initAudioBox</name>
      <anchor>a5</anchor>
      <arglist>(QVBox *parent, LADSPAPort *port, int count, bool connectToDouble)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clearScrollViews</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>uidToRow</name>
      <anchor>a7</anchor>
      <arglist>(int uid)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>currentRow</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>sortingColumn</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>LADSPAEffect</name>
    <filename>classLADSPAEffect.html</filename>
    <member kind="slot">
      <type>void</type>
      <name>setDoublePlugin</name>
      <anchor>i0</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LADSPAEffect</name>
      <anchor>a0</anchor>
      <arglist>(const LADSPA_Descriptor *, QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>unsigned long</type>
      <name>getUniqueID</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>getLabel</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>getName</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>getMaker</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>getCopyright</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>unsigned long</type>
      <name>getPortCount</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isRealtime</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isInplaceBroken</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isHardRTCapable</name>
      <anchor>a10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchor>a11</anchor>
      <arglist>(int, float *, float *, float *, float *)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isEffectSuitable</name>
      <anchor>a12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>deactivate</name>
      <anchor>a13</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>activate</name>
      <anchor>a14</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cleanup</name>
      <anchor>a15</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>process</name>
      <anchor>a16</anchor>
      <arglist>(long size)</arglist>
    </member>
    <member kind="function">
      <type>QPtrList&lt; LADSPAPort &gt; *</type>
      <name>getControlInputPorts</name>
      <anchor>a17</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QPtrList&lt; LADSPAPort &gt; *</type>
      <name>getControlOutputPorts</name>
      <anchor>a18</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QPtrList&lt; LADSPAPort &gt; *</type>
      <name>getAudioInputPorts</name>
      <anchor>a19</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QPtrList&lt; LADSPAPort &gt; *</type>
      <name>getAudioOutputPorts</name>
      <anchor>a20</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>advancePortValues</name>
      <anchor>a21</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>startPortValues</name>
      <anchor>a22</anchor>
      <arglist>(long=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>startControlPortValues</name>
      <anchor>a23</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNbFrames</name>
      <anchor>a24</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setInUse</name>
      <anchor>a25</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getIsInUse</name>
      <anchor>a26</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>initControlPortsValues</name>
      <anchor>a27</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasMonoInput</name>
      <anchor>a28</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasMonoOutput</name>
      <anchor>a29</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasAudioInput</name>
      <anchor>a30</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getNonAssignedOutput</name>
      <anchor>a31</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>usesDoublePlugin</name>
      <anchor>a32</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>connectAudioPorts</name>
      <anchor>a33</anchor>
      <arglist>(long start)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>getFrames</name>
      <anchor>a34</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>LADSPAPort *</type>
      <name>getPort</name>
      <anchor>a35</anchor>
      <arglist>(int port_no)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>wasPortInitDone</name>
      <anchor>a36</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPortInitDone</name>
      <anchor>a37</anchor>
      <arglist>(bool tf)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float *</type>
      <name>inputAudioBufferLeft</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float *</type>
      <name>outputAudioBufferLeft</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float *</type>
      <name>inputAudioBufferRight</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float *</type>
      <name>outputAudioBufferRight</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>currentAudioBufferPosition</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>isInUse</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>usesDoublePluginVal</name>
      <anchor>p6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>long</type>
      <name>nbFrames</name>
      <anchor>p7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>portInitDone</name>
      <anchor>p8</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>LADSPAEffects</name>
    <filename>classLADSPAEffects.html</filename>
    <member kind="slot">
      <type>void</type>
      <name>setNbFrames</name>
      <anchor>i0</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LADSPAEffects</name>
      <anchor>a0</anchor>
      <arglist>(QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>loadEffects</name>
      <anchor>a2</anchor>
      <arglist>(QString)</arglist>
    </member>
    <member kind="function">
      <type>QPtrList&lt; LADSPAEffect &gt; *</type>
      <name>getEffects</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>LADSPAEffect *</type>
      <name>getEffect</name>
      <anchor>a4</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>LADSPAEffect *</type>
      <name>getCurrent</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCurrent</name>
      <anchor>a6</anchor>
      <arglist>(LADSPAEffect *eff)</arglist>
    </member>
    <member kind="variable">
      <type>LADSPAEffect *</type>
      <name>currentEffect</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>LADSPAPort</name>
    <filename>classLADSPAPort.html</filename>
    <member kind="slot">
      <type>void</type>
      <name>setConnectionMethod</name>
      <anchor>i0</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setConnectionMethodDouble</name>
      <anchor>i1</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>crop</name>
      <anchor>i2</anchor>
      <arglist>(long start, long end)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>insert</name>
      <anchor>i3</anchor>
      <arglist>(long start, long amount)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LADSPAPort</name>
      <anchor>a0</anchor>
      <arglist>(int, QString, LADSPA_PortDescriptor, LADSPA_PortRangeHint, QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isAudioInput</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isAudioOutput</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isControlInput</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isControlOutput</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>initInputControlPort</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getLowerBound</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getUpperBound</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setControlInputValue</name>
      <anchor>a9</anchor>
      <arglist>(float)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getPortNumber</name>
      <anchor>a10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>float *</type>
      <name>getCPortValuePointer</name>
      <anchor>a11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>getPortName</name>
      <anchor>a12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValuesOverTime</name>
      <anchor>a13</anchor>
      <arglist>(float *)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>advanceValue</name>
      <anchor>a14</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>startValue</name>
      <anchor>a15</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>startValue</name>
      <anchor>a16</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNbFrames</name>
      <anchor>a17</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>getNbFrames</name>
      <anchor>a18</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>float *</type>
      <name>getVOTPointer</name>
      <anchor>a19</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>initControlValues</name>
      <anchor>a20</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>areBoundsOk</name>
      <anchor>a21</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getConnectionMethod</name>
      <anchor>a22</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getConnectionMethodDouble</name>
      <anchor>a23</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setConnectionMethodDouble</name>
      <anchor>a24</anchor>
      <arglist>(ConnectionMethod m)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setConnectionMethod</name>
      <anchor>a25</anchor>
      <arglist>(ConnectionMethod m)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>initControlValues</name>
      <anchor>a26</anchor>
      <arglist>(QValueList&lt; float &gt; vals)</arglist>
    </member>
    <member kind="function">
      <type>QValueList&lt; float &gt;</type>
      <name>getPortControlValues</name>
      <anchor>a27</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float</type>
      <name>val</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float *</type>
      <name>valuesOverTime</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>long</type>
      <name>nbFrames</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>connectionMethod</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>connectionMethodDouble</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>nbValues</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>LADSPAValueView</name>
    <filename>classLADSPAValueView.html</filename>
    <member kind="function">
      <type></type>
      <name>LADSPAValueView</name>
      <anchor>a0</anchor>
      <arglist>(QCanvas *canvas)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchor>a2</anchor>
      <arglist>(float val)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setY</name>
      <anchor>a3</anchor>
      <arglist>(double y)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setX</name>
      <anchor>a4</anchor>
      <arglist>(double x)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>rtti</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>drawShape</name>
      <anchor>b0</anchor>
      <arglist>(QPainter &amp;p)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float</type>
      <name>value</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>rectheight</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>rectwidth</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QFont *</type>
      <name>localFont</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>LockedBeatRect</name>
    <filename>classLockedBeatRect.html</filename>
    <base>Blinkable</base>
    <member kind="function">
      <type></type>
      <name>LockedBeatRect</name>
      <anchor>a0</anchor>
      <arglist>(QCanvas *canvas, BeatLine *start, BeatLine *end, SoundManager *sm)</arglist>
    </member>
    <member kind="function">
      <type>QPointArray</type>
      <name>areaPoints</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>rtti</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setColor</name>
      <anchor>a4</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function">
      <type>QRect *</type>
      <name>getHandle</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSelected</name>
      <anchor>a6</anchor>
      <arglist>(bool tf)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isSelected</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>getStartSample</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>getEndSample</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getNb</name>
      <anchor>a10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNb</name>
      <anchor>a11</anchor>
      <arglist>(int n)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchor>a12</anchor>
      <arglist>(LockedBeatRect brect)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchor>a13</anchor>
      <arglist>(LockedBeatRect brect)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>updateGeom</name>
      <anchor>a14</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeSampleNumberDisplay</name>
      <anchor>a15</anchor>
      <arglist>(SampleNumberDisplay *snd)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addSampleNumberDisplay</name>
      <anchor>a16</anchor>
      <arglist>(SampleNumberDisplay *snd)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>updateSampleDisplays</name>
      <anchor>a17</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mousePressEvent</name>
      <anchor>a18</anchor>
      <arglist>(QMouseEvent *ev)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCurrentSND</name>
      <anchor>a19</anchor>
      <arglist>(SampleNumberDisplay *snd)</arglist>
    </member>
    <member kind="function">
      <type>QRect</type>
      <name>getSampleNumberDisplaysRect</name>
      <anchor>a20</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getSNDCount</name>
      <anchor>a21</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>renumberSampleNumberDisplays</name>
      <anchor>a22</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copySceneStatus</name>
      <anchor>a23</anchor>
      <arglist>(SampleNumberDisplay *snd)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>assignSceneToCurrent</name>
      <anchor>a24</anchor>
      <arglist>(int sc)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSceneStatus</name>
      <anchor>a25</anchor>
      <arglist>(int sn, bool status)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>switchScene</name>
      <anchor>a26</anchor>
      <arglist>(int sc)</arglist>
    </member>
    <member kind="function">
      <type>QPtrList&lt; SampleNumberDisplay &gt;</type>
      <name>getSampleNumberDisplays</name>
      <anchor>a27</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>updateSceneStatus</name>
      <anchor>a28</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>canRemove</name>
      <anchor>a29</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>executeBlink</name>
      <anchor>a30</anchor>
      <arglist>(int step)</arglist>
    </member>
    <member kind="function">
      <type>BeatLine *</type>
      <name>getEndBL</name>
      <anchor>a31</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>BeatLine *</type>
      <name>getStartBL</name>
      <anchor>a32</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>drawShape</name>
      <anchor>b0</anchor>
      <arglist>(QPainter &amp;p)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>BeatLine *</type>
      <name>endBL</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>BeatLine *</type>
      <name>startBL</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QColor</type>
      <name>bgColor</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QRect *</type>
      <name>handle</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>selected</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>number</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QPtrList&lt; SampleNumberDisplay &gt;</type>
      <name>sampleNumberDisplays</name>
      <anchor>p6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SoundManager *</type>
      <name>soundManager</name>
      <anchor>p7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>drawRedRect</name>
      <anchor>p8</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>LockedBeatRectList</name>
    <filename>classLockedBeatRectList.html</filename>
    <member kind="function">
      <type>int</type>
      <name>compareItems</name>
      <anchor>a2</anchor>
      <arglist>(QPtrCollection::Item item1, QPtrCollection::Item item2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>LoopMarker</name>
    <filename>classLoopMarker.html</filename>
    <member kind="function">
      <type></type>
      <name>LoopMarker</name>
      <anchor>a0</anchor>
      <arglist>(QCanvas *, int)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>drawShape</name>
      <anchor>a2</anchor>
      <arglist>(QPainter &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>QPointArray</type>
      <name>areaPoints</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSamplePosition</name>
      <anchor>a4</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>getSamplePosition</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>rtti</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMoving</name>
      <anchor>a7</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getMoving</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSide</name>
      <anchor>a9</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchor>a10</anchor>
      <arglist>(LoopMarker *)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchor>a11</anchor>
      <arglist>(LoopMarker *)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchor>a12</anchor>
      <arglist>(LoopMarker *)</arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>side</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>moving</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>MeasureMarker</name>
    <filename>classMeasureMarker.html</filename>
    <member kind="function">
      <type></type>
      <name>MeasureMarker</name>
      <anchor>a0</anchor>
      <arglist>(QCanvas *, LoopMarker *, LoopMarker *)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>drawShape</name>
      <anchor>a2</anchor>
      <arglist>(QPainter &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swapMarkers</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBeatWidth</name>
      <anchor>a4</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>rtti</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>LoopMarker *</type>
      <name>leftLoopMarker</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>LoopMarker *</type>
      <name>rightLoopMarker</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>beatWidth</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>MidiInput</name>
    <filename>classMidiInput.html</filename>
    <member kind="slot">
      <type>void</type>
      <name>setBeatlineData</name>
      <anchor>i0</anchor>
      <arglist>(QValueList&lt; beatline_data &gt; bld)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>MidiInput</name>
      <anchor>a0</anchor>
      <arglist>(QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>process</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>printMessage</name>
      <anchor>a3</anchor>
      <arglist>(int msg)</arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>getDevices</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>openDevice</name>
      <anchor>a5</anchor>
      <arglist>(int id)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getDefaultDevice</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getSelectedDevice</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>getSelectedDeviceString</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>getDefaultDeviceString</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>openDevice</name>
      <anchor>a10</anchor>
      <arglist>(QString device)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMidiChannel</name>
      <anchor>a11</anchor>
      <arglist>(int c)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSoundPlayer</name>
      <anchor>a12</anchor>
      <arglist>(SoundPlayer *sp)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addMidiMonitor</name>
      <anchor>a13</anchor>
      <arglist>(QObject *mm)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeMidiMonitor</name>
      <anchor>a14</anchor>
      <arglist>(QObject *mm)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>emitMidiNote</name>
      <anchor>b0</anchor>
      <arglist>(int onoff, int note, int velocity)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>playNote</name>
      <anchor>b1</anchor>
      <arglist>(int note)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>PortMidiStream *</type>
      <name>stream</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>deviceOpened</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>serviceInitDone</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>selectedDevice</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>long</type>
      <name>midiFilter</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SoundPlayer *</type>
      <name>soundPlayer</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>noteAssignements_t *</type>
      <name>noteAssignements</name>
      <anchor>p6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>PmEvent *</type>
      <name>midiEventBuffer</name>
      <anchor>p7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QPtrList&lt; QObject &gt;</type>
      <name>midiMonitors</name>
      <anchor>p8</anchor>
      <arglist></arglist>
    </member>
    <class kind="struct">MidiInput::noteAssignements_t</class>
  </compound>
  <compound kind="class">
    <name>MidiInputEvent</name>
    <filename>classMidiInputEvent.html</filename>
    <member kind="function">
      <type></type>
      <name>MidiInputEvent</name>
      <anchor>a0</anchor>
      <arglist>(int onoff, int note, int velocity)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getNote</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getVelocity</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getOnOff</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>velocity</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>note</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>onoff</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>MidiInputThread</name>
    <filename>classMidiInputThread.html</filename>
    <member kind="function">
      <type></type>
      <name>MidiInputThread</name>
      <anchor>a0</anchor>
      <arglist>(MidiInput *mi)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>run</name>
      <anchor>b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>MidiInput *</type>
      <name>midiInput</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>MidiManager</name>
    <filename>classMidiManager.html</filename>
    <member kind="function">
      <type></type>
      <name>MidiManager</name>
      <anchor>a0</anchor>
      <arglist>(QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeMidiFile</name>
      <anchor>a2</anchor>
      <arglist>(QString filename, QValueList&lt; beatline_data &gt; bld, double bpm)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>MidiOutput</name>
    <filename>classMidiOutput.html</filename>
    <member kind="slot">
      <type>void</type>
      <name>startQueue</name>
      <anchor>i0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>stopQueue</name>
      <anchor>i1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>continueQueue</name>
      <anchor>i2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setTempo</name>
      <anchor>i3</anchor>
      <arglist>(float tempo)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>MidiOutput</name>
      <anchor>a0</anchor>
      <arglist>(QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>doLoop</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable">
      <type>float</type>
      <name>bpm</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>MidiOutputThread</name>
    <filename>classMidiOutputThread.html</filename>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>MidiOutput *</type>
      <name>getMidiOutput</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stopQueue</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>continueQueue</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>play</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>MidiOutput *</type>
      <name>midiOutput</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>MonoToStereoSplitter</name>
    <filename>classMonoToStereoSplitter.html</filename>
    <base>CustomEffect</base>
    <member kind="function">
      <type></type>
      <name>MonoToStereoSplitter</name>
      <anchor>a0</anchor>
      <arglist>(QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>process</name>
      <anchor>a2</anchor>
      <arglist>(long _length)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchor>a3</anchor>
      <arglist>(long _bufferLength)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setOutputL_P</name>
      <anchor>a4</anchor>
      <arglist>(float *_outL)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setOutputR_P</name>
      <anchor>a5</anchor>
      <arglist>(float *_outR)</arglist>
    </member>
    <member kind="function">
      <type>float *</type>
      <name>getInput_P</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>advancePosition</name>
      <anchor>a7</anchor>
      <arglist>(long length)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPosition</name>
      <anchor>a8</anchor>
      <arglist>(long position)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setInput_P</name>
      <anchor>a9</anchor>
      <arglist>(float *)</arglist>
    </member>
    <member kind="function">
      <type>float *</type>
      <name>getOutputL_P</name>
      <anchor>a10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>float *</type>
      <name>getOutputR_P</name>
      <anchor>a11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>getName</name>
      <anchor>a12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float *</type>
      <name>input</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float *</type>
      <name>beginInput</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float *</type>
      <name>outL</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float *</type>
      <name>outR</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float *</type>
      <name>beginOutL</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float *</type>
      <name>beginOutR</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>MyLoadProjectDialog</name>
    <filename>classMyLoadProjectDialog.html</filename>
    <member kind="function">
      <type></type>
      <name>MyLoadProjectDialog</name>
      <anchor>a0</anchor>
      <arglist>(ProjectManager *pm, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>exec</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>ProjectManager *</type>
      <name>projectManager</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>MyMath</name>
    <filename>classMyMath.html</filename>
    <member kind="function">
      <type></type>
      <name>MyMath</name>
      <anchor>a0</anchor>
      <arglist>(QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static float</type>
      <name>standard_deviation</name>
      <anchor>e0</anchor>
      <arglist>(const float *data, int length)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>gaussian_window</name>
      <anchor>e1</anchor>
      <arglist>(float *data, int length, float alpha=2.5)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static double</type>
      <name>linear_regression</name>
      <anchor>e2</anchor>
      <arglist>(double x1, double x2, double y1, double y2, double val)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static T</type>
      <name>PointOnCubicBezier</name>
      <anchor>e3</anchor>
      <arglist>(T a, T b, T c, T d, float t)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static float</type>
      <name>PointOnCubicBezierAt</name>
      <anchor>e4</anchor>
      <arglist>(T a, T b, T c, T d, float dt, P x)</arglist>
    </member>
    <class kind="struct">MyMath::FPoint2D</class>
    <class kind="struct">MyMath::GenericPoint2D</class>
    <class kind="struct">MyMath::smartRoundSum</class>
    <class kind="struct">MyMath::SPoint2D</class>
  </compound>
  <compound kind="class">
    <name>MyOpenFileDialog</name>
    <filename>classMyOpenFileDialog.html</filename>
    <member kind="slot">
      <type>int</type>
      <name>exec</name>
      <anchor>i0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>MyOpenFileDialog</name>
      <anchor>a0</anchor>
      <arglist>(SoundManager *sm, SoundPlayer *sp, FileManager *fm, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>bool</type>
      <name>eventFilter</name>
      <anchor>b0</anchor>
      <arglist>(QObject *watched_object, QEvent *e)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>done</name>
      <anchor>b1</anchor>
      <arglist>(int r)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>MySaveFileDialog</name>
    <filename>classMySaveFileDialog.html</filename>
    <member kind="slot">
      <type>int</type>
      <name>exec</name>
      <anchor>i0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>exportToSoftSamplerClicked</name>
      <anchor>i1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>checkIfMidiAutoAssignementNeeded</name>
      <anchor>i2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>MySaveFileDialog</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>exportMidifile</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>exportAKP</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>exportMode</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getAttackTime</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getExportBitsPerSample</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBps</name>
      <anchor>a7</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>assignMissingMIDINotes</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>exportSF2</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>exportGiga</name>
      <anchor>a10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>exportDLS</name>
      <anchor>a11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>removeChunks</name>
      <anchor>a12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const int</type>
      <name>EXPORT_ALL</name>
      <anchor>s0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const int</type>
      <name>EXPORT_LOOP</name>
      <anchor>s1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>MySaveProjectDialog</name>
    <filename>classMySaveProjectDialog.html</filename>
    <member kind="function">
      <type></type>
      <name>MySaveProjectDialog</name>
      <anchor>a0</anchor>
      <arglist>(ProjectManager *pm, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>exec</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>ProjectManager *</type>
      <name>projectManager</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>MySplitter</name>
    <filename>classMySplitter.html</filename>
    <member kind="function">
      <type></type>
      <name>MySplitter</name>
      <anchor>a0</anchor>
      <arglist>(Orientation o, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>resizeEvent</name>
      <anchor>a2</anchor>
      <arglist>(QResizeEvent *)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>NtoMonoMixer</name>
    <filename>classNtoMonoMixer.html</filename>
    <base>CustomEffect</base>
    <member kind="function">
      <type></type>
      <name>NtoMonoMixer</name>
      <anchor>a0</anchor>
      <arglist>(int n, QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getNbInputs</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>process</name>
      <anchor>a3</anchor>
      <arglist>(long length)</arglist>
    </member>
    <member kind="function">
      <type>float *</type>
      <name>getInput_P</name>
      <anchor>a4</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setOutput_P</name>
      <anchor>a5</anchor>
      <arglist>(float *)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setInput_P</name>
      <anchor>a6</anchor>
      <arglist>(int, float *)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchor>a7</anchor>
      <arglist>(long length)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>advancePosition</name>
      <anchor>a8</anchor>
      <arglist>(long length)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPosition</name>
      <anchor>a9</anchor>
      <arglist>(long position)</arglist>
    </member>
    <member kind="function">
      <type>float *</type>
      <name>getOutput_P</name>
      <anchor>a10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>float *</type>
      <name>addInput</name>
      <anchor>a11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>getName</name>
      <anchor>a12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable">
      <type>float *</type>
      <name>output</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>float **</type>
      <name>inputs</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>float **</type>
      <name>beginInputs</name>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>nbInputs</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float *</type>
      <name>beginOutput</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>OutputToZero</name>
    <filename>classOutputToZero.html</filename>
    <base>CustomEffect</base>
    <member kind="function">
      <type></type>
      <name>OutputToZero</name>
      <anchor>a0</anchor>
      <arglist>(QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>process</name>
      <anchor>a2</anchor>
      <arglist>(long length)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchor>a3</anchor>
      <arglist>(long length)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>advancePosition</name>
      <anchor>a4</anchor>
      <arglist>(long length)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPosition</name>
      <anchor>a5</anchor>
      <arglist>(long position)</arglist>
    </member>
    <member kind="function">
      <type>float *</type>
      <name>getInput_P</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>getName</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float *</type>
      <name>input</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>PassThrough</name>
    <filename>classPassThrough.html</filename>
    <base>CustomEffect</base>
    <member kind="function">
      <type></type>
      <name>PassThrough</name>
      <anchor>a0</anchor>
      <arglist>(int n, QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>advancePosition</name>
      <anchor>a2</anchor>
      <arglist>(long length)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>init</name>
      <anchor>a3</anchor>
      <arglist>(long length)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>process</name>
      <anchor>a4</anchor>
      <arglist>(long length)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setPosition</name>
      <anchor>a5</anchor>
      <arglist>(long position)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>getName</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setOutput_P</name>
      <anchor>a7</anchor>
      <arglist>(int n, float *p)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setInput_P</name>
      <anchor>a8</anchor>
      <arglist>(int n, float *p)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>nbPorts</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float **</type>
      <name>inputs</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float **</type>
      <name>outputs</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float **</type>
      <name>beginOutputs</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float **</type>
      <name>beginInputs</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>PlayLine</name>
    <filename>classPlayLine.html</filename>
    <member kind="function">
      <type></type>
      <name>PlayLine</name>
      <anchor>a0</anchor>
      <arglist>(QCanvas *canvas, long _pos)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>drawShape</name>
      <anchor>a2</anchor>
      <arglist>(QPainter &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPosition</name>
      <anchor>a3</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>getPosition</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QPointArray</type>
      <name>areaPoints</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setState</name>
      <anchor>a6</anchor>
      <arglist>(State _state)</arglist>
    </member>
    <member kind="variable">
      <type>State</type>
      <name>state</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>long</type>
      <name>position</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>PlayPositionChanged</name>
    <filename>classPlayPositionChanged.html</filename>
    <member kind="function">
      <type>void</type>
      <name>setPosition</name>
      <anchor>a2</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>getPosition</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPlaying</name>
      <anchor>a4</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getPlaying</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>long</type>
      <name>position</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>playing</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>PolyLine</name>
    <filename>classPolyLine.html</filename>
    <member kind="slot">
      <type>void</type>
      <name>crop</name>
      <anchor>i0</anchor>
      <arglist>(long start, long end)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>PolyLine</name>
      <anchor>a0</anchor>
      <arglist>(QCanvas *canvas)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>rtti</name>
      <anchor>a1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>addPoint</name>
      <anchor>a3</anchor>
      <arglist>(QPoint p, long sample_pos, float value)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>removePoint</name>
      <anchor>a4</anchor>
      <arglist>(QPoint p)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>moveSelectedPoint</name>
      <anchor>a5</anchor>
      <arglist>(QPoint to, long sample_pos, float value)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QPointArray</type>
      <name>areaPoints</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>deselectAll</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>getYAtX</name>
      <anchor>a8</anchor>
      <arglist>(int x)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual float</type>
      <name>getValueAtSample</name>
      <anchor>a9</anchor>
      <arglist>(long sample)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QRect</type>
      <name>boundingRect</name>
      <anchor>a10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>count</name>
      <anchor>a11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>clear</name>
      <anchor>a12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>updateSize</name>
      <anchor>a13</anchor>
      <arglist>(QSize size)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>containsSameX</name>
      <anchor>a14</anchor>
      <arglist>(QPoint p)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QPointArray</type>
      <name>toPointArray</name>
      <anchor>a15</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QValueList&lt; SortablePoint &gt;</type>
      <name>getSortablePoints</name>
      <anchor>a16</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSortablePoints</name>
      <anchor>a17</anchor>
      <arglist>(QValueList&lt; SortablePoint &gt;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMinValue</name>
      <anchor>a18</anchor>
      <arglist>(float m)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMaxValue</name>
      <anchor>a19</anchor>
      <arglist>(float m)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>valToYPos</name>
      <anchor>a20</anchor>
      <arglist>(float val)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setZoomRatio</name>
      <anchor>a21</anchor>
      <arglist>(long zr)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>drawShape</name>
      <anchor>b0</anchor>
      <arglist>(QPainter &amp;p)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QValueList&lt; SortablePoint &gt;</type>
      <name>sortablePoints</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float</type>
      <name>maxValue</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float</type>
      <name>minValue</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>long</type>
      <name>zoomRatio</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>PotentiometerWidget</name>
    <filename>classPotentiometerWidget.html</filename>
    <member kind="slot">
      <type>void</type>
      <name>setValue</name>
      <anchor>i0</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>PotentiometerWidget</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>repaintScreen</name>
      <anchor>b0</anchor>
      <arglist>(const QRect *cr=0)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>QImage</type>
      <name>getKnobImage</name>
      <anchor>b1</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>init</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Power2Label</name>
    <filename>classPower2Label.html</filename>
    <member kind="slot">
      <type>void</type>
      <name>setNum</name>
      <anchor>i0</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Power2Label</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>PreviewWaveDisplay</name>
    <filename>classPreviewWaveDisplay.html</filename>
    <member kind="slot">
      <type>void</type>
      <name>setDisplayedLength</name>
      <anchor>i0</anchor>
      <arglist>(int mdl)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setStartDisplayPosition</name>
      <anchor>i1</anchor>
      <arglist>(int sdp)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>maxStartPositionChangedSig</name>
      <anchor>l0</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>startPositionChangedSig</name>
      <anchor>l1</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>playPositionChangedSig</name>
      <anchor>l2</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>stopSig</name>
      <anchor>l3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>pauseSig</name>
      <anchor>l4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>playSig</name>
      <anchor>l5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>PreviewWaveDisplay</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>drawContents</name>
      <anchor>a2</anchor>
      <arglist>(QPainter *)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSoundFile</name>
      <anchor>a3</anchor>
      <arglist>(QString *)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getDisplayedLength</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>loadWave</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getWaveLength</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getJump</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>customEvent</name>
      <anchor>a8</anchor>
      <arglist>(QCustomEvent *)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>paintEvent</name>
      <anchor>a9</anchor>
      <arglist>(QPaintEvent *event)</arglist>
    </member>
    <member kind="function">
      <type>QSize</type>
      <name>minimumSizeHint</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>resizeEvent</name>
      <anchor>b0</anchor>
      <arglist>(QResizeEvent *)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>mousePressEvent</name>
      <anchor>b1</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>mouseMoveEvent</name>
      <anchor>b2</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>mouseReleaseEvent</name>
      <anchor>b3</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QString *</type>
      <name>soundfile</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>long</type>
      <name>maxLengthDisplayedC</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>long</type>
      <name>displayedLength</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>long</type>
      <name>waveLength</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float *</type>
      <name>buff</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>startDisplayPosition</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>jump</name>
      <anchor>p6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>long</type>
      <name>playingPosition</name>
      <anchor>p7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QPixmap *</type>
      <name>pixmap</name>
      <anchor>p8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>redraw</name>
      <anchor>p9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>oldPositionLineX</name>
      <anchor>p10</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>moving</name>
      <anchor>p11</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>fileScrewed</name>
      <anchor>p12</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ProjectManager</name>
    <filename>classProjectManager.html</filename>
    <member kind="typedef">
      <type>QMap&lt; long, QValueList&lt; SortablePoint &gt; &gt;</type>
      <name>polylinesMapT</name>
      <anchor>w0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>QMap&lt; long, QValueList&lt; SplinePoint &gt; &gt;</type>
      <name>splinesMapT</name>
      <anchor>w1</anchor>
      <arglist></arglist>
    </member>
    <member kind="slot">
      <type>QStringList</type>
      <name>saveWaveBuffers</name>
      <anchor>i0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setBpmModifier</name>
      <anchor>i1</anchor>
      <arglist>(const QString &amp;theValue)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>loadFile</name>
      <anchor>l0</anchor>
      <arglist>(const QString &amp;fname)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>envelopeDataChanged</name>
      <anchor>l1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>addLadspa</name>
      <anchor>l2</anchor>
      <arglist>(int uid)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>addLockedBeatlines</name>
      <anchor>l3</anchor>
      <arglist>(QValueList&lt; beatline_data &gt;)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>setPolylineData</name>
      <anchor>l4</anchor>
      <arglist>(int, QValueList&lt; SortablePoint &gt;)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>addStackElementS</name>
      <anchor>l5</anchor>
      <arglist>(long start, long end, QString filename, long index, int scene, bool current)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>bpmModifierChangeS</name>
      <anchor>l6</anchor>
      <arglist>(QString val)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ProjectManager</name>
      <anchor>a0</anchor>
      <arglist>(SoundManager *sm, EnvelopeData *ed, QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>saveProject</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFilename</name>
      <anchor>a3</anchor>
      <arglist>(QString fn)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLockedBeatLines</name>
      <anchor>a4</anchor>
      <arglist>(QValueList&lt; beatline_data &gt; bld)</arglist>
    </member>
    <member kind="function">
      <type>QDomNode</type>
      <name>ladspaToXML</name>
      <anchor>a5</anchor>
      <arglist>(EffectFrame *ef)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLadspa</name>
      <anchor>a6</anchor>
      <arglist>(EffectFrame *ef)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>loadProject</name>
      <anchor>a7</anchor>
      <arglist>(QString filename)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xmlToLADSPA</name>
      <anchor>a8</anchor>
      <arglist>(QDomNode xml)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xmlToLBL</name>
      <anchor>a9</anchor>
      <arglist>(QDomNode xml)</arglist>
    </member>
    <member kind="function">
      <type>QValueList&lt; SortablePoint &gt;</type>
      <name>xmlToPolylineData</name>
      <anchor>a10</anchor>
      <arglist>(QDomNode xml)</arglist>
    </member>
    <member kind="function">
      <type>QValueList&lt; SplinePoint &gt;</type>
      <name>xmlToSplineData</name>
      <anchor>a11</anchor>
      <arglist>(QDomNode xml)</arglist>
    </member>
    <member kind="function">
      <type>polylinesMapT</type>
      <name>getPolylines</name>
      <anchor>a12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>splinesMapT</type>
      <name>getSplines</name>
      <anchor>a13</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clearPolylinesSplines</name>
      <anchor>a14</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLoopMarkers</name>
      <anchor>a15</anchor>
      <arglist>(LoopMarker *l, LoopMarker *r)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xmlToLoopMarkers</name>
      <anchor>a16</anchor>
      <arglist>(QDomNode xml, LoopMarker *l, LoopMarker *r)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>getFilename</name>
      <anchor>a17</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLockedBeatRects</name>
      <anchor>a18</anchor>
      <arglist>(LockedBeatRectList lbrl)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>saveStackElementWaves</name>
      <anchor>a19</anchor>
      <arglist>(QString dir, LockedBeatRectList lbrl)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>copyFilesToDir</name>
      <anchor>a20</anchor>
      <arglist>(QStringList files, QString dir)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>copyFileToDir</name>
      <anchor>a21</anchor>
      <arglist>(QString file, QString dir)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xmlToStack</name>
      <anchor>a22</anchor>
      <arglist>(QDomNode xml)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xmlToStacks</name>
      <anchor>a23</anchor>
      <arglist>(QDomNode xml)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>xmlToStackElement</name>
      <anchor>a24</anchor>
      <arglist>(QDomNode xml, long left, long right)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static QDomNode</type>
      <name>envelopeToXML</name>
      <anchor>e0</anchor>
      <arglist>(EnvelopeData *envData)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static QDomNode</type>
      <name>lockedBLToXML</name>
      <anchor>e1</anchor>
      <arglist>(QValueList&lt; beatline_data &gt; lockedBL)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>xmlToEnvelope</name>
      <anchor>e2</anchor>
      <arglist>(QDomNode xml, EnvelopeData *envData)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static QDomNode</type>
      <name>loopMarkersToXML</name>
      <anchor>e3</anchor>
      <arglist>(LoopMarker *l, LoopMarker *r)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static QDomNode</type>
      <name>stacksToXML</name>
      <anchor>e4</anchor>
      <arglist>(LockedBeatRectList lbrl)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static QDomNode</type>
      <name>stackToXML</name>
      <anchor>e5</anchor>
      <arglist>(QPtrList&lt; SampleNumberDisplay &gt; snds, long start, long end)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>EffectFrame *</type>
      <name>effectFrame</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SoundManager *</type>
      <name>soundManager</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QValueList&lt; beatline_data &gt;</type>
      <name>lockedBeatLines</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>EnvelopeData *</type>
      <name>envelopeData</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QString</type>
      <name>filename</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>polylinesMapT</type>
      <name>polylinesMap</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>splinesMapT</type>
      <name>splinesMap</name>
      <anchor>p6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>LoopMarker *</type>
      <name>leftLoopMarker</name>
      <anchor>p7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>LoopMarker *</type>
      <name>rightLoopMarker</name>
      <anchor>p8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>LockedBeatRectList</type>
      <name>lockedBeatRects</name>
      <anchor>p9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QString</type>
      <name>bpmModifier</name>
      <anchor>p10</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>RangeIndicatorWidget</name>
    <filename>classRangeIndicatorWidget.html</filename>
    <member kind="slot">
      <type>void</type>
      <name>setRangeMaxValue</name>
      <anchor>i0</anchor>
      <arglist>(int r_max)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setMaxValue</name>
      <anchor>i1</anchor>
      <arglist>(int max)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setMinValue</name>
      <anchor>i2</anchor>
      <arglist>(int min)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setRangeMinValue</name>
      <anchor>i3</anchor>
      <arglist>(int r_min)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>paintEvent</name>
      <anchor>i4</anchor>
      <arglist>(QPaintEvent *)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setMinimumRange</name>
      <anchor>i5</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>minChanged</name>
      <anchor>l0</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>maxChanged</name>
      <anchor>l1</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>RangeIndicatorWidget</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>minValue</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>maxValue</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>mousePressEvent</name>
      <anchor>b0</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>mouseReleaseEvent</name>
      <anchor>b1</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>mouseMoveEvent</name>
      <anchor>b2</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>movingE</type>
      <name>moving</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ReplacedWaveHolder</name>
    <filename>classReplacedWaveHolder.html</filename>
    <member kind="slot">
      <type>void</type>
      <name>setZoomRatio</name>
      <anchor>i0</anchor>
      <arglist>(long _zr)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setFrames</name>
      <anchor>i1</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setWaveAt</name>
      <anchor>i2</anchor>
      <arglist>(QPoint p, QString filename)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ReplacedWaveHolder</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>dragEnterEvent</name>
      <anchor>a2</anchor>
      <arglist>(QDragEnterEvent *event)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>dropEvent</name>
      <anchor>a3</anchor>
      <arglist>(QDropEvent *event)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SampleNumberDisplay</name>
    <filename>classSampleNumberDisplay.html</filename>
    <member kind="function">
      <type></type>
      <name>SampleNumberDisplay</name>
      <anchor>a0</anchor>
      <arglist>(QCanvas *canvas)</arglist>
    </member>
    <member kind="function">
      <type>QPointArray</type>
      <name>areaPoints</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getCurrent</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCurrent</name>
      <anchor>a4</anchor>
      <arglist>(bool theValue)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAssignedFile</name>
      <anchor>a5</anchor>
      <arglist>(const QString &amp;theValue)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNumber</name>
      <anchor>a6</anchor>
      <arglist>(const int &amp;theValue)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getNumber</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>getAssignedFile</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QRect *</type>
      <name>getEraseHandle</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCanErase</name>
      <anchor>a10</anchor>
      <arglist>(bool theValue)</arglist>
    </member>
    <member kind="function">
      <type>QRect *</type>
      <name>getSceneHandle</name>
      <anchor>a11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>incrementScene</name>
      <anchor>a12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getScene</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setScene</name>
      <anchor>a14</anchor>
      <arglist>(int sc)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSceneStatus</name>
      <anchor>a15</anchor>
      <arglist>(int sc, bool stat)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getSceneCount</name>
      <anchor>a16</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getSceneStatus</name>
      <anchor>a17</anchor>
      <arglist>(int sc)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSceneStatus</name>
      <anchor>a18</anchor>
      <arglist>(bool *scenestatus)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>drawShape</name>
      <anchor>b0</anchor>
      <arglist>(QPainter &amp;p)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>number</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QString</type>
      <name>assignedFile</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>current</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QRect *</type>
      <name>eraseRect</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QRect *</type>
      <name>sceneRect</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>sceneNumber</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QPtrVector&lt; SampleNumberDisplay::scene &gt;</type>
      <name>scenes</name>
      <anchor>p6</anchor>
      <arglist></arglist>
    </member>
    <class kind="struct">SampleNumberDisplay::scene</class>
  </compound>
  <compound kind="class">
    <name>SampleNumberDisplayList</name>
    <filename>classSampleNumberDisplayList.html</filename>
    <member kind="function">
      <type>int</type>
      <name>compareItems</name>
      <anchor>a2</anchor>
      <arglist>(QPtrCollection::Item item1, QPtrCollection::Item item2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SampleValueView</name>
    <filename>classSampleValueView.html</filename>
    <member kind="function">
      <type></type>
      <name>SampleValueView</name>
      <anchor>a0</anchor>
      <arglist>(SoundManager *sm, QCanvas *canvas)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPosition</name>
      <anchor>a2</anchor>
      <arglist>(long pos)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>drawShape</name>
      <anchor>a3</anchor>
      <arglist>(QPainter &amp;)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SoundManager *</type>
      <name>soundManager</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>long</type>
      <name>position</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QFont</type>
      <name>font</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QColor</type>
      <name>colorClear</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QColor</type>
      <name>colorDark</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SceneButton</name>
    <filename>classSceneButton.html</filename>
    <member kind="signal">
      <type>void</type>
      <name>assignToSceneS</name>
      <anchor>l0</anchor>
      <arglist>(int scene)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>sceneSwitchedS</name>
      <anchor>l1</anchor>
      <arglist>(int scene)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SceneButton</name>
      <anchor>a0</anchor>
      <arglist>(int n, QColor c, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setClicked</name>
      <anchor>a2</anchor>
      <arglist>(bool theValue)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSmallClicked</name>
      <anchor>a3</anchor>
      <arglist>(bool theValue)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>drawContents</name>
      <anchor>b0</anchor>
      <arglist>(QPainter *p)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>mousePressEvent</name>
      <anchor>b1</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>mouseReleaseEvent</name>
      <anchor>b2</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>number</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QColor</type>
      <name>color</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>clicked</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>smallClicked</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QRect *</type>
      <name>smallCircle</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SceneFrame</name>
    <filename>classSceneFrame.html</filename>
    <member kind="signal">
      <type>void</type>
      <name>assignToSceneS</name>
      <anchor>l0</anchor>
      <arglist>(int sc)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>sceneSwitchedS</name>
      <anchor>l1</anchor>
      <arglist>(int sc)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SceneFrame</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QPtrVector&lt; SceneButton &gt;</type>
      <name>sceneButtons</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScopeView</name>
    <filename>classScopeView.html</filename>
    <member kind="slot">
      <type>void</type>
      <name>paintEvent</name>
      <anchor>i0</anchor>
      <arglist>(QPaintEvent *)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>showEvent</name>
      <anchor>i1</anchor>
      <arglist>(QShowEvent *)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ScopeView</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>customEvent</name>
      <anchor>a2</anchor>
      <arglist>(QCustomEvent *)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSoundManager</name>
      <anchor>a3</anchor>
      <arglist>(SoundManager *)</arglist>
    </member>
    <member kind="function">
      <type>QSize</type>
      <name>sizeHint</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>resizeEvent</name>
      <anchor>b0</anchor>
      <arglist>(QResizeEvent *ev)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SoundManager *</type>
      <name>soundManager</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>playing</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SelectionRectangle</name>
    <filename>classSelectionRectangle.html</filename>
    <member kind="function">
      <type></type>
      <name>SelectionRectangle</name>
      <anchor>a0</anchor>
      <arglist>(QCanvas *canvas)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SelectionRectangle</name>
      <anchor>a1</anchor>
      <arglist>(long, int, int, int, int, QCanvas *, bool)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setResizing</name>
      <anchor>a3</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getResizing</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLeftSideResizing</name>
      <anchor>a5</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getLeftSideResizing</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setStartSamplePosition</name>
      <anchor>a7</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>getStartSamplePosition</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setEndSamplePosition</name>
      <anchor>a9</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>getEndSamplePosition</name>
      <anchor>a10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDisplayInfo</name>
      <anchor>a11</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMoving</name>
      <anchor>a12</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getMoving</name>
      <anchor>a13</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QRect *</type>
      <name>getCenterRect</name>
      <anchor>a14</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDrawHandles</name>
      <anchor>a15</anchor>
      <arglist>(bool tf)</arglist>
    </member>
    <member kind="function">
      <type>QRect *</type>
      <name>getLeftRect</name>
      <anchor>a16</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QRect *</type>
      <name>getRightRect</name>
      <anchor>a17</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QPointArray</type>
      <name>areaPoints</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>computeText</name>
      <anchor>a19</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchor>a20</anchor>
      <arglist>(long, int, int, int, int)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>drawShape</name>
      <anchor>b0</anchor>
      <arglist>(QPainter &amp;)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>resizing</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>long</type>
      <name>start_sample_position</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>long</type>
      <name>end_sample_position</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>displayInfo</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>leftSideResizing</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>moving</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QColor</type>
      <name>colorClear</name>
      <anchor>p6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QColor</type>
      <name>colorDark</name>
      <anchor>p7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QColor</type>
      <name>handleColor</name>
      <anchor>p8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QRect *</type>
      <name>centerRect</name>
      <anchor>p9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QRect *</type>
      <name>leftRect</name>
      <anchor>p10</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QRect *</type>
      <name>rightRect</name>
      <anchor>p11</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>drawHandles</name>
      <anchor>p12</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>areaPointsWidth</name>
      <anchor>p13</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QString</type>
      <name>text</name>
      <anchor>p14</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QFont</type>
      <name>font</name>
      <anchor>p15</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QPicture</type>
      <name>pict</name>
      <anchor>p16</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SF2Manager</name>
    <filename>classSF2Manager.html</filename>
    <member kind="function">
      <type></type>
      <name>SF2Manager</name>
      <anchor>a0</anchor>
      <arglist>(QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeSF2File</name>
      <anchor>a2</anchor>
      <arglist>(QString, QStringList *, QValueList&lt; beatline_data &gt; bld)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ShowInsertAtRect</name>
    <filename>classShowInsertAtRect.html</filename>
    <member kind="function">
      <type></type>
      <name>ShowInsertAtRect</name>
      <anchor>a0</anchor>
      <arglist>(QCanvas *canvas)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setGeom</name>
      <anchor>a2</anchor>
      <arglist>(int x, int width)</arglist>
    </member>
    <member kind="function">
      <type>QPointArray</type>
      <name>areaPoints</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>drawShape</name>
      <anchor>b0</anchor>
      <arglist>(QPainter &amp;)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>snd_seq_addr</name>
    <filename>structsnd__seq__addr.html</filename>
    <member kind="variable">
      <type>unsigned char</type>
      <name>client</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned char</type>
      <name>port</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>snd_seq_connect</name>
    <filename>structsnd__seq__connect.html</filename>
    <member kind="variable">
      <type>snd_seq_addr_t</type>
      <name>sender</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>snd_seq_addr_t</type>
      <name>dest</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>snd_seq_ev_cluster</name>
    <filename>structsnd__seq__ev__cluster.html</filename>
    <member kind="variable">
      <type>snd_seq_instr_cluster_t</type>
      <name>cluster</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>snd_seq_ev_ctrl</name>
    <filename>structsnd__seq__ev__ctrl.html</filename>
    <member kind="variable">
      <type>unsigned char</type>
      <name>channel</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned char</type>
      <name>unused</name>
      <anchor>o1</anchor>
      <arglist>[3]</arglist>
    </member>
    <member kind="variable">
      <type>unsigned int</type>
      <name>param</name>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>signed int</type>
      <name>value</name>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>snd_seq_ev_ext</name>
    <filename>structsnd__seq__ev__ext.html</filename>
    <member kind="variable">
      <type>unsigned int</type>
      <name>len</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>void *</type>
      <name>ptr</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>snd_seq_ev_instr_begin</name>
    <filename>structsnd__seq__ev__instr__begin.html</filename>
    <member kind="variable">
      <type>int</type>
      <name>timeout</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>snd_seq_ev_loop</name>
    <filename>structsnd__seq__ev__loop.html</filename>
    <member kind="variable">
      <type>unsigned int</type>
      <name>start</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned int</type>
      <name>end</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>snd_seq_ev_note</name>
    <filename>structsnd__seq__ev__note.html</filename>
    <member kind="variable">
      <type>unsigned char</type>
      <name>channel</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned char</type>
      <name>note</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned char</type>
      <name>velocity</name>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned char</type>
      <name>off_velocity</name>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned int</type>
      <name>duration</name>
      <anchor>o4</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>snd_seq_ev_queue_control</name>
    <filename>structsnd__seq__ev__queue__control.html</filename>
    <member kind="variable">
      <type>unsigned char</type>
      <name>queue</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned char</type>
      <name>unused</name>
      <anchor>o1</anchor>
      <arglist>[3]</arglist>
    </member>
    <member kind="variable">
      <type>snd_seq_ev_queue_control::@1</type>
      <name>param</name>
      <anchor>o8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>signed int</type>
      <name>value</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>snd_seq_timestamp_t</type>
      <name>time</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned int</type>
      <name>position</name>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>snd_seq_queue_skew_t</type>
      <name>skew</name>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned int</type>
      <name>d32</name>
      <anchor>o4</anchor>
      <arglist>[2]</arglist>
    </member>
    <member kind="variable">
      <type>unsigned char</type>
      <name>d8</name>
      <anchor>o5</anchor>
      <arglist>[8]</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>snd_seq_ev_raw32</name>
    <filename>structsnd__seq__ev__raw32.html</filename>
    <member kind="variable">
      <type>unsigned int</type>
      <name>d</name>
      <anchor>o0</anchor>
      <arglist>[3]</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>snd_seq_ev_raw8</name>
    <filename>structsnd__seq__ev__raw8.html</filename>
    <member kind="variable">
      <type>unsigned char</type>
      <name>d</name>
      <anchor>o0</anchor>
      <arglist>[12]</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>snd_seq_ev_sample</name>
    <filename>structsnd__seq__ev__sample.html</filename>
    <member kind="variable">
      <type>unsigned int</type>
      <name>std</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned short</type>
      <name>bank</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned short</type>
      <name>prg</name>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>snd_seq_ev_sample_control</name>
    <filename>structsnd__seq__ev__sample__control.html</filename>
    <member kind="variable">
      <type>unsigned char</type>
      <name>channel</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned char</type>
      <name>unused</name>
      <anchor>o1</anchor>
      <arglist>[3]</arglist>
    </member>
    <member kind="variable">
      <type>snd_seq_ev_sample_control::@0</type>
      <name>param</name>
      <anchor>o10</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>snd_seq_ev_sample_t</type>
      <name>sample</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>snd_seq_ev_cluster_t</type>
      <name>cluster</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>snd_seq_position_t</type>
      <name>position</name>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>snd_seq_stop_mode_t</type>
      <name>stop_mode</name>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>snd_seq_frequency_t</type>
      <name>frequency</name>
      <anchor>o4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>snd_seq_ev_volume_t</type>
      <name>volume</name>
      <anchor>o5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>snd_seq_ev_loop_t</type>
      <name>loop</name>
      <anchor>o6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned char</type>
      <name>raw8</name>
      <anchor>o7</anchor>
      <arglist>[8]</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>snd_seq_ev_volume</name>
    <filename>structsnd__seq__ev__volume.html</filename>
    <member kind="variable">
      <type>signed short</type>
      <name>volume</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>signed short</type>
      <name>lr</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>signed short</type>
      <name>fr</name>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>signed short</type>
      <name>du</name>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>snd_seq_event</name>
    <filename>structsnd__seq__event.html</filename>
    <member kind="variable">
      <type>snd_seq_event_type_t</type>
      <name>type</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned char</type>
      <name>flags</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned char</type>
      <name>tag</name>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned char</type>
      <name>queue</name>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>snd_seq_timestamp_t</type>
      <name>time</name>
      <anchor>o4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>snd_seq_addr_t</type>
      <name>source</name>
      <anchor>o5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>snd_seq_addr_t</type>
      <name>dest</name>
      <anchor>o6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>snd_seq_event::@2</type>
      <name>data</name>
      <anchor>o18</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>snd_seq_ev_note_t</type>
      <name>note</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>snd_seq_ev_ctrl_t</type>
      <name>control</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>snd_seq_ev_raw8_t</type>
      <name>raw8</name>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>snd_seq_ev_raw32_t</type>
      <name>raw32</name>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>snd_seq_ev_ext_t</type>
      <name>ext</name>
      <anchor>o4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>snd_seq_ev_queue_control_t</type>
      <name>queue</name>
      <anchor>o5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>snd_seq_timestamp_t</type>
      <name>time</name>
      <anchor>o6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>snd_seq_addr_t</type>
      <name>addr</name>
      <anchor>o7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>snd_seq_connect_t</type>
      <name>connect</name>
      <anchor>o8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>snd_seq_result_t</type>
      <name>result</name>
      <anchor>o9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>snd_seq_ev_instr_begin_t</type>
      <name>instr_begin</name>
      <anchor>o10</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>snd_seq_ev_sample_control_t</type>
      <name>sample</name>
      <anchor>o11</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>snd_seq_instr</name>
    <filename>structsnd__seq__instr.html</filename>
    <member kind="variable">
      <type>snd_seq_instr_cluster_t</type>
      <name>cluster</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned int</type>
      <name>std</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned short</type>
      <name>bank</name>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned short</type>
      <name>prg</name>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>snd_seq_queue_skew</name>
    <filename>structsnd__seq__queue__skew.html</filename>
    <member kind="variable">
      <type>unsigned int</type>
      <name>value</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned int</type>
      <name>base</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>snd_seq_real_time</name>
    <filename>structsnd__seq__real__time.html</filename>
    <member kind="variable">
      <type>unsigned int</type>
      <name>tv_sec</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned int</type>
      <name>tv_nsec</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>snd_seq_result</name>
    <filename>structsnd__seq__result.html</filename>
    <member kind="variable">
      <type>int</type>
      <name>event</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>result</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="union">
    <name>snd_seq_timestamp</name>
    <filename>unionsnd__seq__timestamp.html</filename>
    <member kind="variable">
      <type>snd_seq_tick_time_t</type>
      <name>tick</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>snd_seq_real_time</type>
      <name>time</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SortablePoint</name>
    <filename>classSortablePoint.html</filename>
    <member kind="function">
      <type></type>
      <name>SortablePoint</name>
      <anchor>a1</anchor>
      <arglist>(QPoint p)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>operator&lt;</name>
      <anchor>a3</anchor>
      <arglist>(const QPoint &amp;p)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>operator==</name>
      <anchor>a4</anchor>
      <arglist>(const QPoint &amp;p)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>operator!=</name>
      <anchor>a5</anchor>
      <arglist>(const QPoint &amp;p)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setSelected</name>
      <anchor>a6</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>selected</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setSize</name>
      <anchor>a8</anchor>
      <arglist>(int s)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>getSamplePos</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSamplePos</name>
      <anchor>a10</anchor>
      <arglist>(long sp)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getValue</name>
      <anchor>a11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchor>a12</anchor>
      <arglist>(float val)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>sortOrder</type>
      <name>order</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>size</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>selectedVar</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>long</type>
      <name>sample_pos</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float</type>
      <name>value</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoundFilePreview</name>
    <filename>classSoundFilePreview.html</filename>
    <member kind="slot">
      <type>void</type>
      <name>play</name>
      <anchor>i0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>stop</name>
      <anchor>i1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>stopButtonOnly</name>
      <anchor>i2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>pause</name>
      <anchor>i3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>maxStartDisplayPositionChanged</name>
      <anchor>i4</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>startPositionChanged</name>
      <anchor>i5</anchor>
      <arglist>(int sp)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setPlayPosition</name>
      <anchor>i6</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoundFilePreview</name>
      <anchor>a0</anchor>
      <arglist>(SoundManager *sm, SoundPlayer *pl, FileManager *fm, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>previewUrl</name>
      <anchor>a2</anchor>
      <arglist>(const QUrl &amp;url)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getPlaying</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QSize</type>
      <name>minimumSizeHint</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getIsFileOk</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>closeEvent</name>
      <anchor>b0</anchor>
      <arglist>(QCloseEvent *ce)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>resizeEvent</name>
      <anchor>b1</anchor>
      <arglist>(QResizeEvent *)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>enableButtons</name>
      <anchor>b2</anchor>
      <arglist>(bool tf)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SoundPlayer *</type>
      <name>soundPlayer</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SoundManager *</type>
      <name>soundManager</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>FileManager *</type>
      <name>fileManager</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QPushButton *</type>
      <name>playButton</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QPushButton *</type>
      <name>pauseButton</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QPushButton *</type>
      <name>stopButton</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QVBox *</type>
      <name>vbox</name>
      <anchor>p6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QHBox *</type>
      <name>hbox</name>
      <anchor>p7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QString</type>
      <name>path</name>
      <anchor>p8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>playing</name>
      <anchor>p9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>PreviewWaveDisplay *</type>
      <name>waveDisplay</name>
      <anchor>p10</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QSlider *</type>
      <name>zoomSlider</name>
      <anchor>p11</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QScrollBar *</type>
      <name>positionScrollBar</name>
      <anchor>p12</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QVBox *</type>
      <name>mainFrame</name>
      <anchor>p13</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QHBox *</type>
      <name>audioPreviewFrame</name>
      <anchor>p14</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoundHolder</name>
    <filename>classSoundHolder.html</filename>
    <member kind="signal">
      <type>void</type>
      <name>nbFramesChanged</name>
      <anchor>l0</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoundHolder</name>
      <anchor>a0</anchor>
      <arglist>(QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getRate</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getChannels</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>sf_count_t</type>
      <name>getFrames</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHasLadspa</name>
      <anchor>a5</anchor>
      <arglist>(bool hl)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>saveChunkToAs</name>
      <anchor>a6</anchor>
      <arglist>(QString filename, long start, long end, int format, long start_at, bufferType type=FOR_OUTPUT)</arglist>
    </member>
    <member kind="function">
      <type>float *</type>
      <name>getLeftChannel</name>
      <anchor>a7</anchor>
      <arglist>(bufferType type=FOR_OUTPUT)</arglist>
    </member>
    <member kind="function">
      <type>float *</type>
      <name>getRightChannel</name>
      <anchor>a8</anchor>
      <arglist>(bufferType type=FOR_OUTPUT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>exportMultiplexedShortBuffer</name>
      <anchor>a9</anchor>
      <arglist>(short *data, long, long, bufferType type=FOR_OUTPUT)</arglist>
    </member>
    <member kind="function">
      <type>float *</type>
      <name>exportMultiplexedBuffer</name>
      <anchor>a10</anchor>
      <arglist>(long, long, bufferType type=FOR_OUTPUT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>exportMultiplexedBuffer</name>
      <anchor>a11</anchor>
      <arglist>(float *, long, long, bufferType type=FOR_OUTPUT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNbFrames</name>
      <anchor>a12</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getBps</name>
      <anchor>a13</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>toBpsCode</name>
      <anchor>a14</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cropBuffers</name>
      <anchor>a15</anchor>
      <arglist>(long start_sample, long end_sample)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>zapBuffers</name>
      <anchor>a16</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>zap</name>
      <anchor>a17</anchor>
      <arglist>(bufferType type)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>initBuffer</name>
      <anchor>a18</anchor>
      <arglist>(bufferType type, long length)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getBufferIndex</name>
      <anchor>a19</anchor>
      <arglist>(bufferType type)</arglist>
    </member>
    <member kind="function">
      <type>short *</type>
      <name>insertShortArray</name>
      <anchor>a20</anchor>
      <arglist>(short *dest, short *src, long position, long size)</arglist>
    </member>
    <member kind="function">
      <type>float *</type>
      <name>insertArray</name>
      <anchor>a21</anchor>
      <arglist>(float *dest, float *src, long position, long size)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHasEnvelope</name>
      <anchor>a22</anchor>
      <arglist>(bool tf)</arglist>
    </member>
    <member kind="function">
      <type>QByteArray</type>
      <name>getChunkAsAudioFile</name>
      <anchor>a23</anchor>
      <arglist>(long start, long end, bufferType type=FOR_OUTPUT)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getHasLADSPA</name>
      <anchor>a24</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual long</type>
      <name>insertFileAt</name>
      <anchor>a25</anchor>
      <arglist>(QString filename, long start_sample)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>replaceFileAt</name>
      <anchor>a26</anchor>
      <arglist>(QString filename, long start_sample, long end_sample)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>enlargeBuffersAt</name>
      <anchor>a27</anchor>
      <arglist>(long start_sample, long nb_frames)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getHasEnvelope</name>
      <anchor>a28</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>float *</type>
      <name>exportDerivatedLeftBuffer</name>
      <anchor>b0</anchor>
      <arglist>(long, long, bufferType type=FOR_OUTPUT)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>float *</type>
      <name>exportDerivatedRightBuffer</name>
      <anchor>b1</anchor>
      <arglist>(long, long, bufferType type=FOR_OUTPUT)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>float *</type>
      <name>exportLeftBuffer</name>
      <anchor>b2</anchor>
      <arglist>(long, long, bufferType type=FOR_OUTPUT)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>float *</type>
      <name>exportRightBuffer</name>
      <anchor>b3</anchor>
      <arglist>(long, long, bufferType type=FOR_OUTPUT)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>importLeftBuffer</name>
      <anchor>b4</anchor>
      <arglist>(float *, long start_sample, long end_sample, bufferType type=ORIGINAL_WAVE)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>importRightBuffer</name>
      <anchor>b5</anchor>
      <arglist>(float *, long start_sample, long end_sample, bufferType type=ORIGINAL_WAVE)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>importMultiplexedBuffer</name>
      <anchor>b6</anchor>
      <arglist>(float *, long, bufferType type=ORIGINAL_WAVE)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>importMultiplexedShortBuffer</name>
      <anchor>b7</anchor>
      <arglist>(short *, long, bufferType type=ORIGINAL_WAVE)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>loadBuffer</name>
      <anchor>b8</anchor>
      <arglist>(QString, bufferType type)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>double</type>
      <name>maxValue</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SF_INFO</type>
      <name>sfinfo</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>sf_count_t</type>
      <name>frames</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>rate</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>channels</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>_hasSound</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QValueList&lt; leftRightBuffer &gt;</type>
      <name>buffers</name>
      <anchor>p6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>hasLADSPA</name>
      <anchor>p7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>hasEnvelope</name>
      <anchor>p8</anchor>
      <arglist></arglist>
    </member>
    <class kind="struct">SoundHolder::leftRightBuffer</class>
  </compound>
  <compound kind="class">
    <name>SoundManager</name>
    <filename>classSoundManager.html</filename>
    <base>SoundHolder</base>
    <base>FFTHolder</base>
    <member kind="slot">
      <type>void</type>
      <name>applyPlugin</name>
      <anchor>i0</anchor>
      <arglist>(LADSPAEffect *)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>applyPlugin</name>
      <anchor>i1</anchor>
      <arglist>(LADSPAEffect *effect, long start_sample, long end_sample)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>recompute_subband_energies</name>
      <anchor>i2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>startBandChanged</name>
      <anchor>i3</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>endBandChanged</name>
      <anchor>i4</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>applyEnvelope</name>
      <anchor>i5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>lockedBeatLinesChanged</name>
      <anchor>i6</anchor>
      <arglist>(QValueList&lt; beatline_data &gt; beatlines)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>beatLinesChanged</name>
      <anchor>i7</anchor>
      <arglist>(QValueList&lt; beatline_data &gt; beatlines)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>envelopeChanged</name>
      <anchor>i8</anchor>
      <arglist>(EnvelopeData *envData)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>replaceFileAt</name>
      <anchor>i9</anchor>
      <arglist>(QString filename, long start, long end)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>waveChanged</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>waveChanged</name>
      <anchor>l1</anchor>
      <arglist>(long, long)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>newBeatLineAvailable</name>
      <anchor>l2</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>analysisFinished</name>
      <anchor>l3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>cropped</name>
      <anchor>l4</anchor>
      <arglist>(long, long)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>fftParamsChanged</name>
      <anchor>l5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>analysisParamsChanged</name>
      <anchor>l6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>reinitLADSPAValues</name>
      <anchor>l7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>replaced</name>
      <anchor>l8</anchor>
      <arglist>(long start, long end)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>inserted</name>
      <anchor>l9</anchor>
      <arglist>(long, long)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>resample</name>
      <anchor>a2</anchor>
      <arglist>(list&lt; long &gt;, double)</arglist>
    </member>
    <member kind="function">
      <type>QMemArray&lt; long &gt;</type>
      <name>analyse_time_domain</name>
      <anchor>a3</anchor>
      <arglist>(const double, const int, long, long)</arglist>
    </member>
    <member kind="function">
      <type>QMemArray&lt; long &gt;</type>
      <name>analyse_freq_domain</name>
      <anchor>a4</anchor>
      <arglist>(const double, const int, long, long)</arglist>
    </member>
    <member kind="function">
      <type>QMemArray&lt; long &gt;</type>
      <name>analyse_aubio_onsets</name>
      <anchor>a5</anchor>
      <arglist>(const double, const int, long, long)</arglist>
    </member>
    <member kind="function">
      <type>QMemArray&lt; long &gt;</type>
      <name>analyse</name>
      <anchor>a6</anchor>
      <arglist>(const double, const int, long, long)</arglist>
    </member>
    <member kind="function">
      <type>QMemArray&lt; long &gt;</type>
      <name>analyse</name>
      <anchor>a7</anchor>
      <arglist>(const double, const int)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>loadFile</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasSound</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>getMaxValue</name>
      <anchor>a10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>crop</name>
      <anchor>a11</anchor>
      <arglist>(long, long)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>insertFileAt</name>
      <anchor>a12</anchor>
      <arglist>(QString filename, long start_sample)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFileManager</name>
      <anchor>a13</anchor>
      <arglist>(FileManager *)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pushSoundBuffer</name>
      <anchor>a14</anchor>
      <arglist>(bufferType type)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>saveSoundBuffer</name>
      <anchor>a15</anchor>
      <arglist>(long, long)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>saveSoundBufferTo</name>
      <anchor>a16</anchor>
      <arglist>(QString, bufferType type)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>previousSoundBuffer</name>
      <anchor>a17</anchor>
      <arglist>(bufferType type)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>previousSoundBuffer</name>
      <anchor>a18</anchor>
      <arglist>(long, long)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>nextSoundBuffer</name>
      <anchor>a19</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QStringList *</type>
      <name>saveChunksTo</name>
      <anchor>a20</anchor>
      <arglist>(QString filename, QValueList&lt; beatline_data &gt; bld, int format)</arglist>
    </member>
    <member kind="function">
      <type>QStringList *</type>
      <name>saveChunksTo</name>
      <anchor>a21</anchor>
      <arglist>(QString filename, QValueList&lt; beatline_data &gt; bld)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>saveChunkTo</name>
      <anchor>a22</anchor>
      <arglist>(QString, long start_sample, long end_sample, long start_at=0)</arglist>
    </member>
    <member kind="function">
      <type>LADSPAEffects *</type>
      <name>getEffects</name>
      <anchor>a23</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>zapInstantEBuffer</name>
      <anchor>a24</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>float **</type>
      <name>compute_subband_energies</name>
      <anchor>a25</anchor>
      <arglist>(int, int, int, int, long, long, int, int, float &amp;, float &amp;, bufferType type)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAnalysisMethod</name>
      <anchor>a26</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDerivateSignal</name>
      <anchor>a27</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>QMemArray&lt; long &gt;</type>
      <name>keepUnique</name>
      <anchor>a28</anchor>
      <arglist>(QMemArray&lt; long &gt;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>loadEffects</name>
      <anchor>a29</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>float **</type>
      <name>getHiresTempSubbandEnergies</name>
      <anchor>a30</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>float **</type>
      <name>getHiresFreqSubbandEnergies</name>
      <anchor>a31</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getInstantEnergyBuffersize</name>
      <anchor>a32</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFFTParams</name>
      <anchor>a33</anchor>
      <arglist>(int, int, int, int, int, int, int, int, int, int, int, int, int, bool ssm)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAmpDomainParams</name>
      <anchor>a34</anchor>
      <arglist>(int, int)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addPostProcessEffect</name>
      <anchor>a35</anchor>
      <arglist>(CustomEffect *)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getLeftChannelBand</name>
      <anchor>a36</anchor>
      <arglist>(float *data, long start_sample, long end_sample, int start_band_freq, int end_band_freq, bool invert)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getRightChannelBand</name>
      <anchor>a37</anchor>
      <arglist>(float *data, long start_sample, long end_sample, int start_band_freq, int end_band_freq, bool invert)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>inversionBandChanged</name>
      <anchor>a38</anchor>
      <arglist>(bool tf)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getLeftChannelBand</name>
      <anchor>a39</anchor>
      <arglist>(float *data, long start_sample, long end_sample)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getRightChannelBand</name>
      <anchor>a40</anchor>
      <arglist>(float *data, long start_sample, long end_sample)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getBand</name>
      <anchor>a41</anchor>
      <arglist>(float *channel, float *data, long start_sample, long end_sample, int start_band_freq, int end_band_freq, bool inverted)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPlayingBandOnly</name>
      <anchor>a42</anchor>
      <arglist>(bool tf)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isPlayingBandOnly</name>
      <anchor>a43</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>exportMultiplexedShortChannelBand</name>
      <anchor>a44</anchor>
      <arglist>(short *data, long start_sample, long end_sample)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSubstractSpectralMean</name>
      <anchor>a45</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getSubstractSpectralMean</name>
      <anchor>a46</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getAverageEnergyBuffersize</name>
      <anchor>a47</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QMemArray&lt; beat &gt;</type>
      <name>findPreciseBeat</name>
      <anchor>a48</anchor>
      <arglist>(QMemArray&lt; beat &gt; input, int search_distance, int beatline_distance, float distance_to_min_conf, float lr_diff_conf)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>countNbZeroCrossing</name>
      <anchor>a49</anchor>
      <arglist>(float *data, int distance, int &amp;zc_left, int &amp;zc_right)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeBeatLineAt</name>
      <anchor>a50</anchor>
      <arglist>(long pos)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>updateMaxAmplitudes</name>
      <anchor>a51</anchor>
      <arglist>(QMemArray&lt; beat &gt; beatlines, int search_distance)</arglist>
    </member>
    <member kind="function">
      <type>QMemArray&lt; beat &gt;</type>
      <name>removeRedundantBeatlines</name>
      <anchor>a52</anchor>
      <arglist>(QMemArray&lt; beat &gt; input, int treshold)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getHasLADSPA</name>
      <anchor>a53</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getHasEnvelope</name>
      <anchor>a54</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>getFileExtension</name>
      <anchor>a55</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>getTempDir</name>
      <anchor>a56</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>canOpen</name>
      <anchor>a57</anchor>
      <arglist>(QString file)</arglist>
    </member>
    <member kind="variable">
      <type>QMemArray&lt; long &gt;</type>
      <name>beats</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>FileManager *</type>
      <name>fileManager</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>LADSPAEffects *</type>
      <name>effects</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>analysisMethod</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>derivateSignal</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>amp_domain_instant_energy_buffersize</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>amp_domain_average_energy_buffersize</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>windowMode</name>
      <anchor>p6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>CustomEffects *</type>
      <name>postProcessEffects</name>
      <anchor>p7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>playingBandOnly</name>
      <anchor>p8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>substractSpectralMean</name>
      <anchor>p9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QMemArray&lt; beat &gt;</type>
      <name>foundBeats</name>
      <anchor>p10</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QValueList&lt; beatline_data &gt;</type>
      <name>beatlines</name>
      <anchor>p11</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QValueList&lt; beatline_data &gt;</type>
      <name>lockedBeatlines</name>
      <anchor>p12</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>EnvelopeData *</type>
      <name>envelopeData</name>
      <anchor>p13</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float *</type>
      <name>envelopeArray</name>
      <anchor>p14</anchor>
      <arglist></arglist>
    </member>
    <class kind="struct">SoundManager::beat</class>
  </compound>
  <compound kind="class">
    <name>SoundPlayer</name>
    <filename>classSoundPlayer.html</filename>
    <member kind="function">
      <type>void</type>
      <name>setSoundmanager</name>
      <anchor>a2</anchor>
      <arglist>(SoundManager *)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>linux_open_dsp_device</name>
      <anchor>a3</anchor>
      <arglist>(int, int)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>exit</name>
      <anchor>a5</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>playDevDsp</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stopPlay</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>positionChanged</name>
      <anchor>a8</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isPlaying</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPlaying</name>
      <anchor>a10</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLoop</name>
      <anchor>a11</anchor>
      <arglist>(long, long)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setOneTimeLoop</name>
      <anchor>a12</anchor>
      <arglist>(long, long)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPlayingOnce</name>
      <anchor>a13</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>connect_jack</name>
      <anchor>a14</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>connect_devdsp</name>
      <anchor>a15</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>jack_callback</name>
      <anchor>a16</anchor>
      <arglist>(jack_nframes_t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchor>a17</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBufferLen</name>
      <anchor>a18</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setJackBuffersLen</name>
      <anchor>a19</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getOutputType</name>
      <anchor>a20</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cropped</name>
      <anchor>a21</anchor>
      <arglist>(long, long)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>setJackNotPlaying</name>
      <anchor>a22</anchor>
      <arglist>(jack_default_audio_sample_t *, jack_nframes_t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addSoundMonitor</name>
      <anchor>a23</anchor>
      <arglist>(QObject *)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>initLoop</name>
      <anchor>a24</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>playFromFile</name>
      <anchor>a25</anchor>
      <arglist>(QString path)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>playFromFileThreaded</name>
      <anchor>a26</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stopPlayFromFile</name>
      <anchor>a27</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>resetLoop</name>
      <anchor>a28</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPosition</name>
      <anchor>a29</anchor>
      <arglist>(long pos)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close</name>
      <anchor>a30</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeSoundMonitor</name>
      <anchor>a31</anchor>
      <arglist>(QObject *sm)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pausePlayFromFile</name>
      <anchor>a32</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>portaudio_callback</name>
      <anchor>a33</anchor>
      <arglist>(const void *inputBuffer, void *outputBuffer, unsigned long framesPerBuffer, const PaStreamCallbackTimeInfo *timeInfo, PaStreamCallbackFlags statusFlags)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>connect_portaudio</name>
      <anchor>a34</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>closePortaudio</name>
      <anchor>a35</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>startPAStream</name>
      <anchor>a36</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>stopPAStream</name>
      <anchor>a37</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLeftLoop</name>
      <anchor>a38</anchor>
      <arglist>(const long &amp;theValue)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>getLeftLoop</name>
      <anchor>a39</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static int</type>
      <name>jack_static_callback</name>
      <anchor>e0</anchor>
      <arglist>(jack_nframes_t, void *)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static int</type>
      <name>portaudio_static_callback</name>
      <anchor>e1</anchor>
      <arglist>(const void *inputBuffer, void *outputBuffer, unsigned long framesPerBuffer, const PaStreamCallbackTimeInfo *timeInfo, PaStreamCallbackFlags statusFlags, void *userData)</arglist>
    </member>
    <member kind="variable">
      <type>QPtrList&lt; QObject &gt;</type>
      <name>soundMonitors</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>OutputDriver</type>
      <name>output</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>static const int</type>
      <name>PLAY_PORTS</name>
      <anchor>s0</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>closeJack</name>
      <anchor>b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>setRightLoop</name>
      <anchor>b1</anchor>
      <arglist>(const long &amp;theValue)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>long</type>
      <name>getRightLoop</name>
      <anchor>b2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SoundManager *</type>
      <name>soundManager</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>long</type>
      <name>position</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>playing</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>playingOnce</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>stopped</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>short *</type>
      <name>bufferLR</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float *</type>
      <name>bufferPointerL</name>
      <anchor>p6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float *</type>
      <name>bufferPointerR</name>
      <anchor>p7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>buffer_len</name>
      <anchor>p8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>long</type>
      <name>leftLoop</name>
      <anchor>p9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>long</type>
      <name>rightLoop</name>
      <anchor>p10</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>long</type>
      <name>savedLeftLoop</name>
      <anchor>p11</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>long</type>
      <name>savedRightLoop</name>
      <anchor>p12</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>devdsp_audio_device</name>
      <anchor>p13</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>jack_client_t *</type>
      <name>jack_handle</name>
      <anchor>p14</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>jack_port_t *</type>
      <name>jack_out</name>
      <anchor>p15</anchor>
      <arglist>[PLAY_PORTS]</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QString</type>
      <name>playFromFilePath</name>
      <anchor>p16</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SNDFILE *</type>
      <name>previewFile</name>
      <anchor>p17</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SF_INFO</type>
      <name>sfinfoForPreview</name>
      <anchor>p18</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>closeV</name>
      <anchor>p19</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>PaStream *</type>
      <name>portaudio_stream</name>
      <anchor>p20</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SpectrumView</name>
    <filename>classSpectrumView.html</filename>
    <member kind="slot">
      <type>void</type>
      <name>paintEvent</name>
      <anchor>i0</anchor>
      <arglist>(QPaintEvent *)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>showEvent</name>
      <anchor>i1</anchor>
      <arglist>(QShowEvent *)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SpectrumView</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>customEvent</name>
      <anchor>a2</anchor>
      <arglist>(QCustomEvent *)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSoundManager</name>
      <anchor>a3</anchor>
      <arglist>(SoundManager *)</arglist>
    </member>
    <member kind="function">
      <type>QSize</type>
      <name>sizeHint</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>resizeEvent</name>
      <anchor>b0</anchor>
      <arglist>(QResizeEvent *ev)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SoundManager *</type>
      <name>soundManager</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>playing</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SplineLine</name>
    <filename>classSplineLine.html</filename>
    <base>PolyLine</base>
    <member kind="slot">
      <type>void</type>
      <name>crop</name>
      <anchor>i0</anchor>
      <arglist>(long start, long end)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SplineLine</name>
      <anchor>a0</anchor>
      <arglist>(QCanvas *canvas)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>rtti</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addPoint</name>
      <anchor>a3</anchor>
      <arglist>(QPoint p, long sample_pos, float value)</arglist>
    </member>
    <member kind="function">
      <type>QPointArray</type>
      <name>toBezierPointArray</name>
      <anchor>a4</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function">
      <type>SortablePoint *</type>
      <name>movingPoint</name>
      <anchor>a5</anchor>
      <arglist>(QPoint p)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>moveSelectedPoint</name>
      <anchor>a6</anchor>
      <arglist>(QPoint to, long sample_pos, float value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>deselectAll</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removePoint</name>
      <anchor>a8</anchor>
      <arglist>(QPoint p)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>updateSize</name>
      <anchor>a9</anchor>
      <arglist>(QSize size)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getYAtX</name>
      <anchor>a10</anchor>
      <arglist>(int x)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getValueAtSample</name>
      <anchor>a11</anchor>
      <arglist>(long sample)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>count</name>
      <anchor>a12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchor>a13</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QPointArray</type>
      <name>toPointArray</name>
      <anchor>a14</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMinValue</name>
      <anchor>a15</anchor>
      <arglist>(float)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMaxValue</name>
      <anchor>a16</anchor>
      <arglist>(float)</arglist>
    </member>
    <member kind="function">
      <type>QValueList&lt; SplinePoint &gt;</type>
      <name>getSplinePoints</name>
      <anchor>a17</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSplinePoints</name>
      <anchor>a18</anchor>
      <arglist>(QValueList&lt; SplinePoint &gt; pts)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setZoomRatio</name>
      <anchor>a19</anchor>
      <arglist>(long zr)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>valToYPos</name>
      <anchor>a20</anchor>
      <arglist>(float val)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>drawShape</name>
      <anchor>b0</anchor>
      <arglist>(QPainter &amp;p)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>toSortablePoints</name>
      <anchor>b1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>long</type>
      <name>zoomRatio</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QValueList&lt; SplinePoint &gt;</type>
      <name>splinePoints</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float</type>
      <name>maxValue</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float</type>
      <name>minValue</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SplinePoint</name>
    <filename>classSplinePoint.html</filename>
    <base>SortablePoint</base>
    <member kind="function">
      <type></type>
      <name>SplinePoint</name>
      <anchor>a1</anchor>
      <arglist>(QPoint p)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SplinePoint</name>
      <anchor>a2</anchor>
      <arglist>(QPoint p, QPoint cp1, QPoint cp2)</arglist>
    </member>
    <member kind="variable">
      <type>SortablePoint</type>
      <name>cp1</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SortablePoint</type>
      <name>cp2</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>cpSize</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>UeberStyle</name>
    <filename>classUeberStyle.html</filename>
    <member kind="function">
      <type>void</type>
      <name>drawPrimitive</name>
      <anchor>a2</anchor>
      <arglist>(PrimitiveElement pe, QPainter *p, const QRect &amp;r, const QColorGroup &amp;cg, SFlags flags=Style_Default, const QStyleOption &amp;opt=QStyleOption::Default) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>drawControl</name>
      <anchor>a3</anchor>
      <arglist>(ControlElement element, QPainter *p, const QWidget *widget, const QRect &amp;r, const QColorGroup &amp;cg, SFlags how=Style_Default, const QStyleOption &amp;opt=QStyleOption::Default) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>drawComplexControl</name>
      <anchor>a4</anchor>
      <arglist>(ComplexControl control, QPainter *p, const QWidget *widget, const QRect &amp;r, const QColorGroup &amp;cg, SFlags how=Style_Default, SCFlags sub=SC_All, SCFlags subActive=SC_None, const QStyleOption &amp;opt=QStyleOption::Default) const </arglist>
    </member>
    <member kind="function">
      <type>QRect</type>
      <name>querySubControlMetrics</name>
      <anchor>a5</anchor>
      <arglist>(ComplexControl control, const QWidget *widget, SubControl subcontrol, const QStyleOption &amp;opt=QStyleOption::Default) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>pixelMetric</name>
      <anchor>a6</anchor>
      <arglist>(PixelMetric metric, const QWidget *widget=0) const </arglist>
    </member>
    <member kind="function">
      <type>QRect</type>
      <name>subRect</name>
      <anchor>a7</anchor>
      <arglist>(SubRect subrect, const QWidget *widget) const </arglist>
    </member>
    <member kind="function">
      <type>QSize</type>
      <name>sizeFromContents</name>
      <anchor>a8</anchor>
      <arglist>(ContentsType contents, const QWidget *widget, const QSize &amp;contentsSize, const QStyleOption &amp;opt=QStyleOption::Default) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>polish</name>
      <anchor>a9</anchor>
      <arglist>(QWidget *w)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ValueLine</name>
    <filename>classValueLine.html</filename>
    <member kind="function">
      <type></type>
      <name>ValueLine</name>
      <anchor>a0</anchor>
      <arglist>(QCanvas *, long, float *)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>getSamplePos</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getValue</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>float *</type>
      <name>getValuePointer</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>rtti</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QPoint</type>
      <name>startPoint</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QPoint</type>
      <name>endPoint</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPoints</name>
      <anchor>a8</anchor>
      <arglist>(int x1, int y1, int x2, int y2)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setWidth</name>
      <anchor>a9</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSamplePos</name>
      <anchor>a10</anchor>
      <arglist>(long pos)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValuePointer</name>
      <anchor>a11</anchor>
      <arglist>(float *val)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>drawShape</name>
      <anchor>b0</anchor>
      <arglist>(QPainter &amp;p)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float *</type>
      <name>value</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>VerticalSelectionRectangle</name>
    <filename>classVerticalSelectionRectangle.html</filename>
    <base>SelectionRectangle</base>
    <member kind="function">
      <type></type>
      <name>VerticalSelectionRectangle</name>
      <anchor>a0</anchor>
      <arglist>(QCanvas *canvas)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>VerticalSelectionRectangle</name>
      <anchor>a1</anchor>
      <arglist>(SoundManager *sm, int band_pos, int x, int y, int width, int height, QCanvas *, bool)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setStartBandPos</name>
      <anchor>a3</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setEndBandPos</name>
      <anchor>a4</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getStartBandPos</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getEndBandPos</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>drawShape</name>
      <anchor>a7</anchor>
      <arglist>(QPainter &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setInverted</name>
      <anchor>a8</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getInverted</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>start_band_pos</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>end_band_pos</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>inverted</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SoundManager *</type>
      <name>soundManager</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>VolumeSlider</name>
    <filename>classVolumeSlider.html</filename>
    <member kind="function">
      <type></type>
      <name>VolumeSlider</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>QSize</type>
      <name>sizeHint</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>WaveCanvas</name>
    <filename>classWaveCanvas.html</filename>
    <member kind="slot">
      <type>void</type>
      <name>zapBuffers</name>
      <anchor>i0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>zapBuffers</name>
      <anchor>i1</anchor>
      <arglist>(long start, long end)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>WaveCanvas</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setZoomRatio</name>
      <anchor>a2</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSoundManager</name>
      <anchor>a3</anchor>
      <arglist>(SoundManager *)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBgColor</name>
      <anchor>a4</anchor>
      <arglist>(int r, int g, int b)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>hasRuler</name>
      <anchor>a5</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getRulerHeight</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>forceRepaint</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>forceRepaint</name>
      <anchor>a8</anchor>
      <arglist>(long, long)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>changeViewMode</name>
      <anchor>a9</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>drawWave</name>
      <anchor>a10</anchor>
      <arglist>(long, long)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>drawSpectrum</name>
      <anchor>a11</anchor>
      <arglist>(long, long)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPixmapXOrigin</name>
      <anchor>a12</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasPixmap</name>
      <anchor>a13</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setVisibleWidth</name>
      <anchor>a14</anchor>
      <arglist>(int w)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>emptyBuffers</name>
      <anchor>a15</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>viewMode</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>drawBackground</name>
      <anchor>b0</anchor>
      <arglist>(QPainter &amp;localpainter, const QRect &amp;clip)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>drawBackgroundImage</name>
      <anchor>b1</anchor>
      <arglist>(long, long)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>long</type>
      <name>zoomRatio</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SoundManager *</type>
      <name>soundManager</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QColor</type>
      <name>bgColor</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>QColor</type>
      <name>spectrumBgColor</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>_hasRuler</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>bool</type>
      <name>drawing</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>pixmapXOrigin</name>
      <anchor>p6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>visibleWidth</name>
      <anchor>p7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>rms_env *</type>
      <name>rmsL</name>
      <anchor>p8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>rms_env *</type>
      <name>rmsR</name>
      <anchor>p9</anchor>
      <arglist></arglist>
    </member>
    <class kind="struct">WaveCanvas::maxAndMin</class>
    <class kind="struct">WaveCanvas::spectrogramMax</class>
  </compound>
  <compound kind="class">
    <name>WaveDrag</name>
    <filename>classWaveDrag.html</filename>
    <member kind="function">
      <type></type>
      <name>WaveDrag</name>
      <anchor>a0</anchor>
      <arglist>(QStrList list, QWidget *parent=0, const char *name=0)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>SeqEvents</name>
    <title>Sequencer Event Definitions</title>
    <filename>group__SeqEvents.html</filename>
    <class kind="struct">snd_seq_addr</class>
    <class kind="struct">snd_seq_connect</class>
    <class kind="struct">snd_seq_real_time</class>
    <class kind="union">snd_seq_timestamp</class>
    <class kind="struct">snd_seq_ev_note</class>
    <class kind="struct">snd_seq_ev_ctrl</class>
    <class kind="struct">snd_seq_ev_raw8</class>
    <class kind="struct">snd_seq_ev_raw32</class>
    <class kind="struct">snd_seq_ev_ext</class>
    <class kind="struct">snd_seq_instr</class>
    <class kind="struct">snd_seq_ev_sample</class>
    <class kind="struct">snd_seq_ev_cluster</class>
    <class kind="struct">snd_seq_ev_volume</class>
    <class kind="struct">snd_seq_ev_loop</class>
    <class kind="struct">snd_seq_ev_sample_control</class>
    <class kind="struct">snd_seq_ev_instr_begin</class>
    <class kind="struct">snd_seq_result</class>
    <class kind="struct">snd_seq_queue_skew</class>
    <class kind="struct">snd_seq_ev_queue_control</class>
    <class kind="struct">snd_seq_event</class>
    <member kind="define">
      <type>#define</type>
      <name>SND_SEQ_TIME_STAMP_TICK</name>
      <anchor>ga26</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SND_SEQ_TIME_STAMP_REAL</name>
      <anchor>ga27</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SND_SEQ_TIME_STAMP_MASK</name>
      <anchor>ga28</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SND_SEQ_TIME_MODE_ABS</name>
      <anchor>ga29</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SND_SEQ_TIME_MODE_REL</name>
      <anchor>ga30</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SND_SEQ_TIME_MODE_MASK</name>
      <anchor>ga31</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SND_SEQ_EVENT_LENGTH_FIXED</name>
      <anchor>ga32</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SND_SEQ_EVENT_LENGTH_VARIABLE</name>
      <anchor>ga33</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SND_SEQ_EVENT_LENGTH_VARUSR</name>
      <anchor>ga34</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SND_SEQ_EVENT_LENGTH_MASK</name>
      <anchor>ga35</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SND_SEQ_PRIORITY_NORMAL</name>
      <anchor>ga36</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SND_SEQ_PRIORITY_HIGH</name>
      <anchor>ga37</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SND_SEQ_PRIORITY_MASK</name>
      <anchor>ga38</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>unsigned char</type>
      <name>snd_seq_event_type_t</name>
      <anchor>ga0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>snd_seq_addr</type>
      <name>snd_seq_addr_t</name>
      <anchor>ga1</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>snd_seq_connect</type>
      <name>snd_seq_connect_t</name>
      <anchor>ga2</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>snd_seq_real_time</type>
      <name>snd_seq_real_time_t</name>
      <anchor>ga3</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>unsigned int</type>
      <name>snd_seq_tick_time_t</name>
      <anchor>ga4</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>snd_seq_timestamp</type>
      <name>snd_seq_timestamp_t</name>
      <anchor>ga5</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>snd_seq_ev_note</type>
      <name>snd_seq_ev_note_t</name>
      <anchor>ga6</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>snd_seq_ev_ctrl</type>
      <name>snd_seq_ev_ctrl_t</name>
      <anchor>ga7</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>snd_seq_ev_raw8</type>
      <name>snd_seq_ev_raw8_t</name>
      <anchor>ga8</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>snd_seq_ev_raw32</type>
      <name>snd_seq_ev_raw32_t</name>
      <anchor>ga9</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>snd_seq_ev_ext</type>
      <name>snd_seq_ev_ext_t</name>
      <anchor>ga10</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>unsigned int</type>
      <name>snd_seq_instr_cluster_t</name>
      <anchor>ga11</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>snd_seq_instr</type>
      <name>snd_seq_instr_t</name>
      <anchor>ga12</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>snd_seq_ev_sample</type>
      <name>snd_seq_ev_sample_t</name>
      <anchor>ga13</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>snd_seq_ev_cluster</type>
      <name>snd_seq_ev_cluster_t</name>
      <anchor>ga14</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>unsigned int</type>
      <name>snd_seq_position_t</name>
      <anchor>ga15</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>enum snd_seq_stop_mode</type>
      <name>snd_seq_stop_mode_t</name>
      <anchor>ga16</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>int</type>
      <name>snd_seq_frequency_t</name>
      <anchor>ga17</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>snd_seq_ev_volume</type>
      <name>snd_seq_ev_volume_t</name>
      <anchor>ga18</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>snd_seq_ev_loop</type>
      <name>snd_seq_ev_loop_t</name>
      <anchor>ga19</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>snd_seq_ev_sample_control</type>
      <name>snd_seq_ev_sample_control_t</name>
      <anchor>ga20</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>snd_seq_ev_instr_begin</type>
      <name>snd_seq_ev_instr_begin_t</name>
      <anchor>ga21</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>snd_seq_result</type>
      <name>snd_seq_result_t</name>
      <anchor>ga22</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>snd_seq_queue_skew</type>
      <name>snd_seq_queue_skew_t</name>
      <anchor>ga23</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>snd_seq_ev_queue_control</type>
      <name>snd_seq_ev_queue_control_t</name>
      <anchor>ga24</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>snd_seq_event</type>
      <name>snd_seq_event_t</name>
      <anchor>ga25</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>snd_seq_event_type</name>
      <anchor>ga39</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_SYSTEM</name>
      <anchor>gga39a39</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_RESULT</name>
      <anchor>gga39a40</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_NOTE</name>
      <anchor>gga39a41</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_NOTEON</name>
      <anchor>gga39a42</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_NOTEOFF</name>
      <anchor>gga39a43</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_KEYPRESS</name>
      <anchor>gga39a44</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_CONTROLLER</name>
      <anchor>gga39a45</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_PGMCHANGE</name>
      <anchor>gga39a46</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_CHANPRESS</name>
      <anchor>gga39a47</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_PITCHBEND</name>
      <anchor>gga39a48</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_CONTROL14</name>
      <anchor>gga39a49</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_NONREGPARAM</name>
      <anchor>gga39a50</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_REGPARAM</name>
      <anchor>gga39a51</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_SONGPOS</name>
      <anchor>gga39a52</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_SONGSEL</name>
      <anchor>gga39a53</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_QFRAME</name>
      <anchor>gga39a54</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_TIMESIGN</name>
      <anchor>gga39a55</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_KEYSIGN</name>
      <anchor>gga39a56</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_START</name>
      <anchor>gga39a57</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_CONTINUE</name>
      <anchor>gga39a58</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_STOP</name>
      <anchor>gga39a59</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_SETPOS_TICK</name>
      <anchor>gga39a60</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_SETPOS_TIME</name>
      <anchor>gga39a61</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_TEMPO</name>
      <anchor>gga39a62</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_CLOCK</name>
      <anchor>gga39a63</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_TICK</name>
      <anchor>gga39a64</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_QUEUE_SKEW</name>
      <anchor>gga39a65</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_SYNC_POS</name>
      <anchor>gga39a66</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_TUNE_REQUEST</name>
      <anchor>gga39a67</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_RESET</name>
      <anchor>gga39a68</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_SENSING</name>
      <anchor>gga39a69</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_ECHO</name>
      <anchor>gga39a70</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_OSS</name>
      <anchor>gga39a71</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_CLIENT_START</name>
      <anchor>gga39a72</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_CLIENT_EXIT</name>
      <anchor>gga39a73</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_CLIENT_CHANGE</name>
      <anchor>gga39a74</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_PORT_START</name>
      <anchor>gga39a75</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_PORT_EXIT</name>
      <anchor>gga39a76</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_PORT_CHANGE</name>
      <anchor>gga39a77</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_PORT_SUBSCRIBED</name>
      <anchor>gga39a78</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_PORT_UNSUBSCRIBED</name>
      <anchor>gga39a79</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_SAMPLE</name>
      <anchor>gga39a80</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_SAMPLE_CLUSTER</name>
      <anchor>gga39a81</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_SAMPLE_START</name>
      <anchor>gga39a82</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_SAMPLE_STOP</name>
      <anchor>gga39a83</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_SAMPLE_FREQ</name>
      <anchor>gga39a84</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_SAMPLE_VOLUME</name>
      <anchor>gga39a85</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_SAMPLE_LOOP</name>
      <anchor>gga39a86</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_SAMPLE_POSITION</name>
      <anchor>gga39a87</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_SAMPLE_PRIVATE1</name>
      <anchor>gga39a88</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_USR0</name>
      <anchor>gga39a89</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_USR1</name>
      <anchor>gga39a90</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_USR2</name>
      <anchor>gga39a91</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_USR3</name>
      <anchor>gga39a92</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_USR4</name>
      <anchor>gga39a93</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_USR5</name>
      <anchor>gga39a94</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_USR6</name>
      <anchor>gga39a95</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_USR7</name>
      <anchor>gga39a96</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_USR8</name>
      <anchor>gga39a97</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_USR9</name>
      <anchor>gga39a98</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_INSTR_BEGIN</name>
      <anchor>gga39a99</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_INSTR_END</name>
      <anchor>gga39a100</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_INSTR_INFO</name>
      <anchor>gga39a101</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_INSTR_INFO_RESULT</name>
      <anchor>gga39a102</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_INSTR_FINFO</name>
      <anchor>gga39a103</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_INSTR_FINFO_RESULT</name>
      <anchor>gga39a104</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_INSTR_RESET</name>
      <anchor>gga39a105</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_INSTR_STATUS</name>
      <anchor>gga39a106</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_INSTR_STATUS_RESULT</name>
      <anchor>gga39a107</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_INSTR_PUT</name>
      <anchor>gga39a108</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_INSTR_GET</name>
      <anchor>gga39a109</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_INSTR_GET_RESULT</name>
      <anchor>gga39a110</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_INSTR_FREE</name>
      <anchor>gga39a111</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_INSTR_LIST</name>
      <anchor>gga39a112</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_INSTR_LIST_RESULT</name>
      <anchor>gga39a113</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_INSTR_CLUSTER</name>
      <anchor>gga39a114</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_INSTR_CLUSTER_GET</name>
      <anchor>gga39a115</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_INSTR_CLUSTER_RESULT</name>
      <anchor>gga39a116</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_INSTR_CHANGE</name>
      <anchor>gga39a117</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_SYSEX</name>
      <anchor>gga39a118</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_BOUNCE</name>
      <anchor>gga39a119</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_USR_VAR0</name>
      <anchor>gga39a120</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_USR_VAR1</name>
      <anchor>gga39a121</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_USR_VAR2</name>
      <anchor>gga39a122</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_USR_VAR3</name>
      <anchor>gga39a123</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_USR_VAR4</name>
      <anchor>gga39a124</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_EVENT_NONE</name>
      <anchor>gga39a125</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>snd_seq_stop_mode</name>
      <anchor>ga40</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_SAMPLE_STOP_IMMEDIATELY</name>
      <anchor>gga40a126</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_SAMPLE_STOP_VENVELOPE</name>
      <anchor>gga40a127</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SND_SEQ_SAMPLE_STOP_LOOP</name>
      <anchor>gga40a128</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="dir">
    <name>Pers/Freecycle/savannah-cvs/freecycle/src/pics/acidknob/</name>
    <path>/home/predrag/Pers/Freecycle/savannah-cvs/freecycle/src/pics/acidknob/</path>
    <filename>dir_000006.html</filename>
    <file>acidknob.h</file>
  </compound>
  <compound kind="dir">
    <name>Pers/Freecycle/savannah-cvs/freecycle/src/pics/button/</name>
    <path>/home/predrag/Pers/Freecycle/savannah-cvs/freecycle/src/pics/button/</path>
    <filename>dir_000007.html</filename>
    <file>button.h</file>
  </compound>
  <compound kind="dir">
    <name>Pers/Freecycle/savannah-cvs/freecycle/src/pics/check/</name>
    <path>/home/predrag/Pers/Freecycle/savannah-cvs/freecycle/src/pics/check/</path>
    <filename>dir_000008.html</filename>
    <file>check.h</file>
  </compound>
  <compound kind="dir">
    <name>Pers/Freecycle/savannah-cvs/freecycle/src/pics/frame/</name>
    <path>/home/predrag/Pers/Freecycle/savannah-cvs/freecycle/src/pics/frame/</path>
    <filename>dir_000009.html</filename>
    <file>frame.h</file>
  </compound>
  <compound kind="dir">
    <name>Pers/Freecycle/savannah-cvs/freecycle/</name>
    <path>/home/predrag/Pers/Freecycle/savannah-cvs/freecycle/</path>
    <filename>dir_000003.html</filename>
    <dir>Pers/Freecycle/savannah-cvs/freecycle/src/</dir>
  </compound>
  <compound kind="dir">
    <name>Pers/Freecycle/</name>
    <path>/home/predrag/Pers/Freecycle/</path>
    <filename>dir_000001.html</filename>
    <dir>Pers/Freecycle/savannah-cvs/</dir>
  </compound>
  <compound kind="dir">
    <name>Pers/Freecycle/savannah-cvs/freecycle/src/pics/lever2/</name>
    <path>/home/predrag/Pers/Freecycle/savannah-cvs/freecycle/src/pics/lever2/</path>
    <filename>dir_000010.html</filename>
    <file>lever2.h</file>
  </compound>
  <compound kind="dir">
    <name>Pers/Freecycle/savannah-cvs/freecycle/src/pics/lever_yellow/</name>
    <path>/home/predrag/Pers/Freecycle/savannah-cvs/freecycle/src/pics/lever_yellow/</path>
    <filename>dir_000011.html</filename>
    <file>lever_yellow.h</file>
  </compound>
  <compound kind="dir">
    <name>Pers/</name>
    <path>/home/predrag/Pers/</path>
    <filename>dir_000000.html</filename>
    <dir>Pers/Freecycle/</dir>
  </compound>
  <compound kind="dir">
    <name>Pers/Freecycle/savannah-cvs/freecycle/src/pics/</name>
    <path>/home/predrag/Pers/Freecycle/savannah-cvs/freecycle/src/pics/</path>
    <filename>dir_000005.html</filename>
    <dir>Pers/Freecycle/savannah-cvs/freecycle/src/pics/acidknob/</dir>
    <dir>Pers/Freecycle/savannah-cvs/freecycle/src/pics/button/</dir>
    <dir>Pers/Freecycle/savannah-cvs/freecycle/src/pics/check/</dir>
    <dir>Pers/Freecycle/savannah-cvs/freecycle/src/pics/frame/</dir>
    <dir>Pers/Freecycle/savannah-cvs/freecycle/src/pics/lever2/</dir>
    <dir>Pers/Freecycle/savannah-cvs/freecycle/src/pics/lever_yellow/</dir>
    <dir>Pers/Freecycle/savannah-cvs/freecycle/src/pics/radio/</dir>
    <dir>Pers/Freecycle/savannah-cvs/freecycle/src/pics/volumeslider/</dir>
    <file>fileopen.xpm</file>
    <file>fileprint.xpm</file>
    <file>filesave.xpm</file>
    <file>icons.h</file>
  </compound>
  <compound kind="dir">
    <name>Pers/Freecycle/savannah-cvs/freecycle/src/pics/radio/</name>
    <path>/home/predrag/Pers/Freecycle/savannah-cvs/freecycle/src/pics/radio/</path>
    <filename>dir_000012.html</filename>
    <file>radio.h</file>
  </compound>
  <compound kind="dir">
    <name>Pers/Freecycle/savannah-cvs/</name>
    <path>/home/predrag/Pers/Freecycle/savannah-cvs/</path>
    <filename>dir_000002.html</filename>
    <dir>Pers/Freecycle/savannah-cvs/freecycle/</dir>
  </compound>
  <compound kind="dir">
    <name>Pers/Freecycle/savannah-cvs/freecycle/src/</name>
    <path>/home/predrag/Pers/Freecycle/savannah-cvs/freecycle/src/</path>
    <filename>dir_000004.html</filename>
    <dir>Pers/Freecycle/savannah-cvs/freecycle/src/pics/</dir>
    <file>akpmanager.cpp</file>
    <file>akpmanager.h</file>
    <file>ampdomaindialog.cpp</file>
    <file>ampdomaindialog.h</file>
    <file>AmpDomainDialogBase.cpp</file>
    <file>AmpDomainDialogBase.h</file>
    <file>AmpDomainDialogBase.ui.h</file>
    <file>beatline.cpp</file>
    <file>beatline.h</file>
    <file>beatlinedata.h</file>
    <file>beatlinelist.cpp</file>
    <file>beatlinelist.h</file>
    <file>bitspersampledropdown.cpp</file>
    <file>bitspersampledropdown.h</file>
    <file>blinkable.cpp</file>
    <file>blinkable.h</file>
    <file>bpmmodifierdropdown.cpp</file>
    <file>bpmmodifierdropdown.h</file>
    <file>bpmmodifierspinbox.cpp</file>
    <file>bpmmodifierspinbox.h</file>
    <file>controllercanvas.cpp</file>
    <file>controllercanvas.h</file>
    <file>customeffect.cpp</file>
    <file>customeffect.h</file>
    <file>customeffects.cpp</file>
    <file>customeffects.h</file>
    <file>defs.h</file>
    <file>displayenvelopewidget.cpp</file>
    <file>displayenvelopewidget.h</file>
    <file>dlsmanager.cpp</file>
    <file>dlsmanager.h</file>
    <file>drawallsoundwidget.cpp</file>
    <file>drawallsoundwidget.h</file>
    <file>drawingline.cpp</file>
    <file>drawingline.h</file>
    <file>drawsoundwidget.cpp</file>
    <file>drawsoundwidget.h</file>
    <file>drawsoundwidgetabstract.cpp</file>
    <file>drawsoundwidgetabstract.h</file>
    <file>effectframe.cpp</file>
    <file>effectframe.h</file>
    <file>effectportframe.cpp</file>
    <file>effectportframe.h</file>
    <file>envelope.cpp</file>
    <file>envelope.h</file>
    <file>envelopecontrollerwidget.cpp</file>
    <file>envelopecontrollerwidget.h</file>
    <file>envelopedata.cpp</file>
    <file>envelopedata.h</file>
    <file>fftdialog.cpp</file>
    <file>fftdialog.h</file>
    <file>FFTDialogBase.cpp</file>
    <file>FFTDialogBase.h</file>
    <file>FFTDialogBase.ui.h</file>
    <file>fftholder.cpp</file>
    <file>fftholder.h</file>
    <file>filemanager.cpp</file>
    <file>filemanager.h</file>
    <file>floatspinbox.cpp</file>
    <file>floatspinbox.h</file>
    <file>freecycle.cpp</file>
    <file>freecycle.h</file>
    <file>freecycle_to_sf2_with_libinstpatch.c</file>
    <file>gigamanager.cpp</file>
    <file>gigamanager.h</file>
    <file>helpmanager.cpp</file>
    <file>helpmanager.h</file>
    <file>inputzero.cpp</file>
    <file>inputzero.h</file>
    <file>keyboardview.cpp</file>
    <file>keyboardview.h</file>
    <file>keypressglobaleventfilter.cpp</file>
    <file>keypressglobaleventfilter.h</file>
    <file>ladspadialog.cpp</file>
    <file>ladspadialog.h</file>
    <file>ladspadialogbase.cpp</file>
    <file>ladspadialogbase.h</file>
    <file>ladspadialogbase.ui.h</file>
    <file>ladspaeffect.cpp</file>
    <file>ladspaeffect.h</file>
    <file>ladspaeffects.cpp</file>
    <file>ladspaeffects.h</file>
    <file>ladspaport.cpp</file>
    <file>ladspaport.h</file>
    <file>ladspavalueview.cpp</file>
    <file>ladspavalueview.h</file>
    <file>lockedbeatrect.cpp</file>
    <file>lockedbeatrect.h</file>
    <file>lockedbeatrectlist.cpp</file>
    <file>lockedbeatrectlist.h</file>
    <file>loopmarker.cpp</file>
    <file>loopmarker.h</file>
    <file>main.cpp</file>
    <file>measuremarker.cpp</file>
    <file>measuremarker.h</file>
    <file>midiconfigdialog.cpp</file>
    <file>midiconfigdialog.h</file>
    <file>MidiConfigDialogBase.cpp</file>
    <file>MidiConfigDialogBase.h</file>
    <file>MidiConfigDialogBase.ui.h</file>
    <file>midiinput.cpp</file>
    <file>midiinput.h</file>
    <file>midiinputevent.cpp</file>
    <file>midiinputevent.h</file>
    <file>midiinputthread.cpp</file>
    <file>midiinputthread.h</file>
    <file>midimanager.cpp</file>
    <file>midimanager.h</file>
    <file>midioutput.cpp</file>
    <file>midioutput.h</file>
    <file>midioutputthread.cpp</file>
    <file>midioutputthread.h</file>
    <file>moc_akpmanager.cpp</file>
    <file>moc_ampdomaindialog.cpp</file>
    <file>moc_AmpDomainDialogBase.cpp</file>
    <file>moc_bitspersampledropdown.cpp</file>
    <file>moc_blinkable.cpp</file>
    <file>moc_blinkanimator.cpp</file>
    <file>moc_bpmmodifierdropdown.cpp</file>
    <file>moc_bpmmodifierspinbox.cpp</file>
    <file>moc_customeffect.cpp</file>
    <file>moc_customeffects.cpp</file>
    <file>moc_displayenvelopewidget.cpp</file>
    <file>moc_dlsmanager.cpp</file>
    <file>moc_drawallsoundwidget.cpp</file>
    <file>moc_drawsoundwidget.cpp</file>
    <file>moc_drawsoundwidgetabstract.cpp</file>
    <file>moc_effectframe.cpp</file>
    <file>moc_effectportframe.cpp</file>
    <file>moc_envelope.cpp</file>
    <file>moc_envelopecontrollerwidget.cpp</file>
    <file>moc_envelopedata.cpp</file>
    <file>moc_envelopeholder.cpp</file>
    <file>moc_fftdialog.cpp</file>
    <file>moc_FFTDialogBase.cpp</file>
    <file>moc_filemanager.cpp</file>
    <file>moc_freecycle.cpp</file>
    <file>moc_gigamanager.cpp</file>
    <file>moc_helpmanager.cpp</file>
    <file>moc_inputzero.cpp</file>
    <file>moc_keypressglobaleventfilter.cpp</file>
    <file>moc_ladspadialog.cpp</file>
    <file>moc_ladspadialogbase.cpp</file>
    <file>moc_ladspaeffect.cpp</file>
    <file>moc_ladspaeffects.cpp</file>
    <file>moc_ladspaport.cpp</file>
    <file>moc_midiconfigdialog.cpp</file>
    <file>moc_MidiConfigDialogBase.cpp</file>
    <file>moc_midiinput.cpp</file>
    <file>moc_midimanager.cpp</file>
    <file>moc_midioutput.cpp</file>
    <file>moc_monotostereosplitter.cpp</file>
    <file>moc_myloadprojectdialog.cpp</file>
    <file>moc_mymath.cpp</file>
    <file>moc_myopenfiledialog.cpp</file>
    <file>moc_mysavefiledialog.cpp</file>
    <file>moc_mysaveprojectdialog.cpp</file>
    <file>moc_mysplitter.cpp</file>
    <file>moc_ntomonomixer.cpp</file>
    <file>moc_outputtozero.cpp</file>
    <file>moc_passthrough.cpp</file>
    <file>moc_potentiometerwidget.cpp</file>
    <file>moc_power2label.cpp</file>
    <file>moc_previewwavedisplay.cpp</file>
    <file>moc_projectmanager.cpp</file>
    <file>moc_rangeindicatorwidget.cpp</file>
    <file>moc_replacedwaveholder.cpp</file>
    <file>moc_scenebutton.cpp</file>
    <file>moc_sceneframe.cpp</file>
    <file>moc_scopeview.cpp</file>
    <file>moc_sf2manager.cpp</file>
    <file>moc_soundfilepreview.cpp</file>
    <file>moc_soundholder.cpp</file>
    <file>moc_soundmanager.cpp</file>
    <file>moc_spectrumview.cpp</file>
    <file>moc_ueberstyle.cpp</file>
    <file>moc_volumeslider.cpp</file>
    <file>moc_wavedrag.cpp</file>
    <file>monotostereosplitter.cpp</file>
    <file>monotostereosplitter.h</file>
    <file>myloadprojectdialog.cpp</file>
    <file>myloadprojectdialog.h</file>
    <file>mymath.cpp</file>
    <file>mymath.h</file>
    <file>myopenfiledialog.cpp</file>
    <file>myopenfiledialog.h</file>
    <file>mysavefiledialog.cpp</file>
    <file>mysavefiledialog.h</file>
    <file>mysaveprojectdialog.cpp</file>
    <file>mysaveprojectdialog.h</file>
    <file>mysplitter.cpp</file>
    <file>mysplitter.h</file>
    <file>ntomonomixer.cpp</file>
    <file>ntomonomixer.h</file>
    <file>outputtozero.cpp</file>
    <file>outputtozero.h</file>
    <file>passthrough.cpp</file>
    <file>passthrough.h</file>
    <file>playline.cpp</file>
    <file>playline.h</file>
    <file>playpositionchanged.cpp</file>
    <file>playpositionchanged.h</file>
    <file>polyline.cpp</file>
    <file>polyline.h</file>
    <file>potentiometerwidget.cpp</file>
    <file>potentiometerwidget.h</file>
    <file>power2label.cpp</file>
    <file>power2label.h</file>
    <file>previewwavedisplay.cpp</file>
    <file>previewwavedisplay.h</file>
    <file>projectmanager.cpp</file>
    <file>projectmanager.h</file>
    <file>rangeindicatorwidget.cpp</file>
    <file>rangeindicatorwidget.h</file>
    <file>replacedwaveholder.cpp</file>
    <file>replacedwaveholder.h</file>
    <file>rms.cpp</file>
    <file>rms.h</file>
    <file>samplenumberdisplay.cpp</file>
    <file>samplenumberdisplay.h</file>
    <file>samplenumberdisplaylist.cpp</file>
    <file>samplenumberdisplaylist.h</file>
    <file>samplevalueview.cpp</file>
    <file>samplevalueview.h</file>
    <file>scenebutton.cpp</file>
    <file>scenebutton.h</file>
    <file>sceneframe.cpp</file>
    <file>sceneframe.h</file>
    <file>scopeview.cpp</file>
    <file>scopeview.h</file>
    <file>selectionrectangle.cpp</file>
    <file>selectionrectangle.h</file>
    <file>seq_event.h</file>
    <file>sf2manager.cpp</file>
    <file>sf2manager.h</file>
    <file>showinsertatrect.cpp</file>
    <file>showinsertatrect.h</file>
    <file>sortablepoint.cpp</file>
    <file>sortablepoint.h</file>
    <file>soundfilepreview.cpp</file>
    <file>soundfilepreview.h</file>
    <file>soundholder.cpp</file>
    <file>soundholder.h</file>
    <file>soundmanager.cpp</file>
    <file>soundmanager.h</file>
    <file>soundplayer.cpp</file>
    <file>soundplayer.h</file>
    <file>spectrumview.cpp</file>
    <file>spectrumview.h</file>
    <file>splineline.cpp</file>
    <file>splineline.h</file>
    <file>splinepoint.cpp</file>
    <file>splinepoint.h</file>
    <file>splitter.xpm</file>
    <file>ueberstyle.cpp</file>
    <file>ueberstyle.h</file>
    <file>valueline.cpp</file>
    <file>valueline.h</file>
    <file>verticalselectionrectangle.cpp</file>
    <file>verticalselectionrectangle.h</file>
    <file>volumeslider.cpp</file>
    <file>volumeslider.h</file>
    <file>wavecanvas.cpp</file>
    <file>wavecanvas.h</file>
    <file>wavedrag.cpp</file>
    <file>wavedrag.h</file>
  </compound>
  <compound kind="dir">
    <name>Pers/Freecycle/savannah-cvs/freecycle/src/pics/volumeslider/</name>
    <path>/home/predrag/Pers/Freecycle/savannah-cvs/freecycle/src/pics/volumeslider/</path>
    <filename>dir_000013.html</filename>
    <file>volumeslider.h</file>
  </compound>
</tagfile>
