/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef SORTABLEPOINT_H
#define SORTABLEPOINT_H

#include <qpoint.h>

/**
@author Predrag Viceic
*/
class SortablePoint : public QPoint
{
public:
    SortablePoint();
    SortablePoint(QPoint p);

    virtual ~SortablePoint();

    enum sortOrder{HORIZONTAL,VERTICAL};

    virtual bool operator<( const QPoint &p);
    virtual bool operator==( const QPoint &p);
    virtual bool operator!=( const QPoint &p);
    virtual void setSelected(bool);
    virtual bool selected();
    virtual void setSize(int s);
    long getSamplePos();
    void setSamplePos(long sp);
    float getValue();
    void setValue(float val);


protected:
    sortOrder order;
    int size;
    bool selectedVar;
    long sample_pos;
    float value;


};

#endif
